/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Shell;
import org.gvt.ChisioMain;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.editpart.ChsScalableRootEditPart;
import org.gvt.model.CompoundModel;

public class PrintAction
extends Action {
    ChisioMain main;

    public PrintAction(ChisioMain chisio) {
        super("Print Pathway ...");
        this.setToolTipText(this.getText());
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/print.png"));
        this.main = chisio;
    }

    @Override
    public void run() {
        Shell shell = this.main.getShell();
        if (this.main.getViewer() == null) {
            return;
        }
        Figure rootFigure = (Figure)((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getFigure().getChildren().get(0);
        ScalableLayeredPane layer = (ScalableLayeredPane)rootFigure.getChildren().get(0);
        double scale = layer.getScale();
        layer.setScale(1.0);
        org.eclipse.swt.graphics.Rectangle bounds = this.getBounds(this.main.getViewer(), rootFigure);
        Image image = new Image((Device)shell.getDisplay(), bounds);
        GC gc = new GC(image);
        if (ChisioMain.runningOnWindows) {
            gc.setAntialias(1);
            gc.setTextAntialias(1);
        } else {
            gc.setAntialias(0);
            gc.setTextAntialias(0);
        }
        SWTGraphics graphics = new SWTGraphics(gc);
        rootFigure.paint(graphics);
        ((Graphics)graphics).dispose();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        loader.save(os, 0);
        layer.setScale(scale);
        try {
            HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
            pras.add(new Copies(1));
            String filename = this.main.getOwlFileName();
            if (filename == null) {
                filename = "temp";
            }
            pras.add(new JobName(filename, Locale.getDefault()));
            PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.JPEG, pras);
            if (services != null && services.length > 0) {
                PrintService ps = ServiceUI.printDialog(null, 100, 100, services, PrintServiceLookup.lookupDefaultPrintService(), DocFlavor.INPUT_STREAM.JPEG, pras);
                if (ps != null) {
                    DocPrintJob job = ps.createPrintJob();
                    ByteArrayInputStream bis = new ByteArrayInputStream(os.toByteArray());
                    SimpleDoc doc = new SimpleDoc(bis, DocFlavor.INPUT_STREAM.JPEG, null);
                    job.print(doc, pras);
                }
            } else {
                MessageDialog.openError(this.main.getShell(), "No Printer", "No printer installed.");
            }
        }
        catch (PrintException pe) {
            pe.printStackTrace();
            MessageDialog.openError(this.main.getShell(), "Print Error!", pe.getMessage());
        }
    }

    public org.eclipse.swt.graphics.Rectangle getBounds(ScrollingGraphicalViewer viewer, Figure f) {
        CompoundModel rootModel = (CompoundModel)((ChsRootEditPart)viewer.getRootEditPart().getChildren().get(0)).getModel();
        Rectangle bounds = rootModel.calculateBounds();
        Rectangle boundsRoot = f.getBounds();
        boundsRoot.setSize(bounds.x + bounds.width + CompoundModel.MARGIN_SIZE, bounds.y + bounds.height + CompoundModel.MARGIN_SIZE);
        return new org.eclipse.swt.graphics.Rectangle(boundsRoot.x, boundsRoot.y, boundsRoot.width, boundsRoot.height);
    }
}

