/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.CPathClient;
import cpath.client.util.CPathException;
import cpath.service.GraphType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.gvt.ChisioMain;
import org.gvt.action.QueryPCAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.CommonStreamQueryParamWithEntitiesDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.GraphObject;

public class QueryPCCommonStreamAction
extends QueryPCAction {
    public QueryPCCommonStreamAction(ChisioMain main, QueryPCAction.QueryLocation qLoc) {
        super(main, "Common Stream ...", false, qLoc);
    }

    public QueryPCCommonStreamAction(ChisioMain main, boolean downstream, QueryPCAction.QueryLocation qLoc) {
        this(main, qLoc);
        this.useSelected = true;
        this.setText(downstream ? "Downstream" : "Upstream");
        this.options.setUpstream(!downstream);
        this.options.setDownstream(downstream);
        this.options.setLengthLimit(2);
    }

    @Override
    public void run() {
        this.execute();
    }

    @Override
    protected String getSIFQueryType() {
        return "commonstream";
    }

    @Override
    protected Model doQuery() throws CPathException {
        List<String> sourceSymbols = this.options.getConvertedSourceList();
        return this.getPCGraphQuery().kind(GraphType.COMMONSTREAM).sources(sourceSymbols).limit(this.options.getLengthLimit()).direction(this.options.isDownstream() ? CPathClient.Direction.DOWNSTREAM : CPathClient.Direction.UPSTREAM).result();
    }

    @Override
    protected Set<BioPAXElement> doFileQuery(Model model) {
        List<String> symbols = this.options.getConvertedSourceList();
        Set<BioPAXElement> source = this.findRelatedReferences(model, symbols);
        return QueryExecuter.runCommonStreamWithPOI(source, model, this.options.isUpstream() ? Direction.UPSTREAM : Direction.DOWNSTREAM, this.options.getLengthLimit(), new Filter[0]);
    }

    @Override
    protected Collection<GraphObject> doSIFQuery(BasicSIFGraph graph) throws CPathException {
        return AlgoRunner.searchCommonStream(QueryPCCommonStreamAction.getSeed(graph, this.options.getConvertedSourceList()), this.options.isDownstream(), this.options.getLengthLimit(), !this.options.undirectedSIFTypeSelected());
    }

    @Override
    protected AbstractQueryParamDialog getDialog() {
        return new CommonStreamQueryParamWithEntitiesDialog(this.main, this.queryLoc.isSIF());
    }

    @Override
    protected boolean canQuery() {
        List<String> sourceSymbols = this.options.getConvertedSourceList();
        this.warnForUnknownSymbols(this.options.getUnknownSymbols());
        if (sourceSymbols.size() < 2) {
            this.warnForLowInput(2, sourceSymbols.size());
        }
        return sourceSymbols.size() > 1;
    }
}

