/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.util.CPathException;
import cpath.service.jaxb.SearchHit;
import cpath.service.jaxb.SearchResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.QueryPCAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.StringInputDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.patika.mada.graph.GraphObject;

public class QueryPCPathwaysAction
extends QueryPCAction {
    String keyword;
    String latestKeyword;
    String pathwayID;

    public QueryPCPathwaysAction(ChisioMain main, QueryPCAction.QueryLocation qLoc) {
        super(main, "Pathways With Keyword ...", false, qLoc);
        this.createNewPathwayForView = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.main.getBioPAXModel() == null || this.main.getBioPAXModel().getLevel().equals((Object)BioPAXLevel.L3)) {
            try {
                StringInputDialog dialog = new StringInputDialog(this.main.getShell(), "Query Pathways", "Enter a keyword for pathway name", this.keyword != null ? this.keyword : this.latestKeyword, "Find pathways related to the specified keyword");
                this.keyword = dialog.open();
                if (this.keyword == null || this.keyword.trim().length() == 0) {
                    return;
                }
                this.latestKeyword = this.keyword;
                this.keyword = this.keyword.trim().toLowerCase();
                this.main.lockWithMessage("Querying Pathway Commons ...");
                SearchResponse resp = this.getPCSearchQuery().typeFilter("Pathway").queryString("name:" + this.keyword).result();
                this.main.unlock();
                if (resp != null) {
                    List<Holder> holders = this.extractResultFromServResp(resp, this.keyword);
                    ItemSelectionDialog isd = new ItemSelectionDialog(this.main.getShell(), 500, "Result Pathways", "Select Pathway to Get", holders, null, false, true, null);
                    isd.setDoSort(false);
                    Object selected = isd.open();
                    if (selected == null) {
                        return;
                    }
                    this.pathwayID = ((Holder)selected).getID();
                    this.setOpenPathwayName(((Holder)selected).getName());
                    this.execute();
                }
                MessageDialog.openInformation(this.main.getShell(), "No result", "Could not find any match.\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError(this.main.getShell(), "Error", "An error occured during querying:\n" + e.getMessage());
            }
            finally {
                this.main.unlock();
                this.pathwayID = null;
                this.keyword = null;
            }
        } else {
            MessageDialog.openError(this.main.getShell(), "Incompatible Levels", "This query is only applicable to Level 3 models.");
        }
    }

    private List<Holder> extractResultFromServResp(SearchResponse resp, String keyword) {
        ArrayList<Holder> holders = new ArrayList<Holder>();
        for (SearchHit hit : resp.getSearchHit()) {
            Holder h = new Holder(hit);
            if (h.getID() == null || h.getName() == null) continue;
            holders.add(h);
        }
        return holders;
    }

    private List<String> getIDList(List<Holder> holders) {
        ArrayList<String> ids = new ArrayList<String>(holders.size());
        for (Holder holder : holders) {
            ids.add(holder.getID());
        }
        return ids;
    }

    private Set<String> getKeywords(String keyword) {
        HashSet<String> set = new HashSet<String>();
        for (String s : keyword.split(" ")) {
            if ((s = s.trim()).length() <= 1) continue;
            set.add(s);
        }
        return set;
    }

    @Override
    protected String getSIFQueryType() {
        throw new RuntimeException("Code should not reach here!");
    }

    @Override
    protected Model doQuery() throws CPathException {
        return this.getPCGetQuery().sources(new String[]{this.pathwayID}).result();
    }

    @Override
    protected Set<BioPAXElement> doFileQuery(Model model) {
        return this.findInFile(model, Collections.singleton(this.pathwayID));
    }

    @Override
    protected Collection<GraphObject> doSIFQuery(BasicSIFGraph graph) throws CPathException {
        throw new UnsupportedOperationException("Cannot get from SIF");
    }

    @Override
    protected AbstractQueryParamDialog getDialog() {
        return null;
    }

    @Override
    protected boolean canQuery() {
        return this.pathwayID != null && this.pathwayID.length() > 0;
    }

    private class Holder
    implements Comparable {
        SearchHit hit;

        private Holder(SearchHit hit) {
            this.hit = hit;
        }

        public int compareTo(Object o) {
            return this.hit.getName().compareTo(((Holder)o).hit.getName());
        }

        public int hashCode() {
            return this.hit.getUri().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Holder) {
                Holder h = (Holder)o;
                return this.hit.getUri().equals(h.hit.getUri());
            }
            return false;
        }

        public String getDataSource() {
            if (!this.hit.getDataSource().isEmpty()) {
                String s = this.hit.getDataSource().iterator().next();
                if (s.contains("/") && !s.endsWith("/")) {
                    s = s.substring(s.lastIndexOf("/") + 1);
                }
                return s;
            }
            return null;
        }

        public String getOrganism() {
            if (!this.hit.getOrganism().isEmpty()) {
                String s = this.hit.getOrganism().iterator().next();
                if (s.contains("/") && !s.endsWith("/")) {
                    s = s.substring(s.lastIndexOf("/") + 1);
                }
                if (s.equals("9606")) {
                    s = "Human";
                }
                return s;
            }
            return null;
        }

        public String getID() {
            return this.hit.getUri();
        }

        public String getName() {
            return this.hit.getName();
        }

        public String toString() {
            String o;
            String s = this.hit.getName();
            String d = this.getDataSource();
            if (d != null) {
                s = s + " [" + d + "]";
            }
            if ((o = this.getOrganism()) != null) {
                s = s + " [" + o + "]";
            }
            return s;
        }
    }
}

