/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.Collections;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.gvt.ChisioMain;
import org.gvt.editpart.ChsRootEditPart;

public class SelectNodesAction
extends Action {
    ChisioMain main;
    int selectionType;
    public static final int ALL_NODES = 0;
    public static final int SIMPLE_NODES = 1;
    public static final int COMPOUND_NODES = 2;

    public SelectNodesAction(ChisioMain main, int selectionType) {
        this.selectionType = selectionType;
        this.main = main;
        if (selectionType == 0) {
            this.setText("Select All Nodes");
        } else if (selectionType == 1) {
            this.setText("Select Simple Nodes");
        } else if (selectionType == 2) {
            this.setText("Select Compound Nodes");
        }
        this.setToolTipText(this.getText());
    }

    @Override
    public void run() {
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        if (viewer != null) {
            ChsRootEditPart root = (ChsRootEditPart)viewer.getRootEditPart().getChildren().get(0);
            viewer.deselectAll();
            this.selectNodes(root);
        }
    }

    public void selectNodes(EditPart parent) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            EditPart node = (EditPart)parent.getChildren().get(i);
            if (node.getChildren() != Collections.EMPTY_LIST) {
                if (this.selectionType != 1) {
                    this.main.getViewer().appendSelection(node);
                }
                this.selectNodes(node);
                continue;
            }
            if (this.selectionType == 2) continue;
            this.main.getViewer().appendSelection(node);
        }
    }
}

