/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.data.drug.DrugData;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Color;
import org.gvt.ChisioMain;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.ItemSelectionRunnable;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.sifl3.SIFGraph;

public class ShowDruggableAction
extends Action {
    ChisioMain main;
    private static final String CANCER_DRUG = "Cancer drug";
    private static final String FDA_APPROVED = "FDA approved";
    private static final String NUTRACEUTICAL = "Nutraceutical";
    private static final Color NO_DRUG_BG = new Color(null, 255, 255, 255);
    private static final Color DRUGGABLE_BG = new Color(null, 255, 180, 150);

    public ShowDruggableAction(ChisioMain main) {
        super("Show druggable ...");
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        if (this.main.getViewer() == null) {
            return;
        }
        final BioPAXGraph graph = this.main.getPathwayGraph();
        if (!(graph instanceof BasicSIFGraph) && !(graph instanceof SIFGraph)) {
            return;
        }
        Map<NodeModel, Color> colors = this.getColors(graph);
        Map<NodeModel, String> tooltips = this.getTooltips(graph);
        ArrayList<String> opts = new ArrayList<String>(Arrays.asList(CANCER_DRUG, FDA_APPROVED, NUTRACEUTICAL));
        ArrayList selected = new ArrayList();
        ItemSelectionRunnable runner = new ItemSelectionRunnable(){

            @Override
            public void run(Collection selectedTerms) {
                for (Object o : graph.getNodes()) {
                    if (!(o instanceof NodeModel)) continue;
                    NodeModel node = (NodeModel)o;
                    String name = node.getText();
                    HashSet<String> drugs = new HashSet<String>(DrugData.getDrugs(name));
                    Iterator iter = drugs.iterator();
                    while (iter.hasNext()) {
                        String drug = (String)iter.next();
                        if (!(selectedTerms.contains(ShowDruggableAction.CANCER_DRUG) && !DrugData.isCancerDrug(drug) || selectedTerms.contains(ShowDruggableAction.FDA_APPROVED) && !DrugData.isFDAApproved(drug)) && (!selectedTerms.contains(ShowDruggableAction.NUTRACEUTICAL) || DrugData.isNutraceutical(drug))) continue;
                        iter.remove();
                    }
                    if (drugs.isEmpty()) {
                        node.setColor(NO_DRUG_BG);
                        node.setTooltipText(name);
                        continue;
                    }
                    node.setColor(DRUGGABLE_BG);
                    node.setTooltipText(ShowDruggableAction.this.getTooltip(drugs));
                }
            }
        };
        ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 100, "Drugs", "Select options", opts, selected, true, false, runner);
        dialog.setUpdateUponSelection(true);
        runner.run(Collections.EMPTY_SET);
        dialog.open();
        this.restoreColors(graph, colors);
        this.restoreTooltips(graph, tooltips);
    }

    private String getTooltip(Set<String> drugs) {
        ArrayList<String> list = new ArrayList<String>(drugs);
        Collections.sort(list);
        StringBuilder s = new StringBuilder();
        for (String drug : list) {
            s.append(drug).append("\n");
        }
        return s.toString().trim();
    }

    private Map<NodeModel, Color> getColors(BioPAXGraph graph) {
        HashMap<NodeModel, Color> colors = new HashMap<NodeModel, Color>();
        for (Object o : graph.getNodes()) {
            if (!(o instanceof BioPAXNode)) continue;
            colors.put((NodeModel)o, ((NodeModel)o).getColor());
        }
        return colors;
    }

    private void restoreColors(BioPAXGraph graph, Map<NodeModel, Color> colors) {
        for (Object o : graph.getNodes()) {
            if (!(o instanceof BioPAXNode) || !colors.containsKey(o)) continue;
            ((BioPAXNode)o).setColor(colors.get(o));
        }
    }

    private Map<NodeModel, String> getTooltips(BioPAXGraph graph) {
        HashMap<NodeModel, String> tooltips = new HashMap<NodeModel, String>();
        for (Object o : graph.getNodes()) {
            if (!(o instanceof BioPAXNode)) continue;
            tooltips.put((NodeModel)o, ((NodeModel)o).getTooltipText());
        }
        return tooltips;
    }

    private void restoreTooltips(BioPAXGraph graph, Map<NodeModel, String> tooltips) {
        for (Object o : graph.getNodes()) {
            if (!(o instanceof BioPAXNode) || !tooltips.containsKey(o)) continue;
            ((BioPAXNode)o).setTooltipText(tooltips.get(o));
        }
    }
}

