/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.cbio.causality.data.portal.BroadAccessor;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;
import org.cbio.causality.util.Overlap;
import org.cbio.causality.util.Summary;
import org.eclipse.swt.custom.CTabItem;
import org.gvt.ChisioMain;
import org.gvt.action.TCGASIFAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.ItemSelectionRunnable;
import org.gvt.model.CompoundModel;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class ShowMutexGroupsAction
extends TCGASIFAction {
    public ShowMutexGroupsAction(ChisioMain main) {
        super("Show mutex groups in TCGA SIF ...", main);
    }

    @Override
    public void run() {
        if (!ShowMutexGroupsAction.okToRun(this.main)) {
            return;
        }
        CTabItem tab = this.main.getSelectedTab();
        CompoundModel root = (CompoundModel)this.main.getTabToViewerMap().get(tab).getContents().getModel();
        BioPAXL3Graph graph = (BioPAXL3Graph)root;
        List<Set<String>> gisticSets = BroadAccessor.getGisticGeneSets(graph.getName(), 1.0);
        Set<String> genes = this.getNodeNames(graph);
        HashSet<Set<String>> empty = new HashSet<Set<String>>();
        for (Set<String> set : gisticSets) {
            set.retainAll(genes);
            if (!set.isEmpty()) continue;
            empty.add(set);
        }
        gisticSets.removeAll(empty);
        this.main.lockWithMessage("Calculating mutex ...");
        List<NodeGroup> list = this.getMutexGroups(graph, gisticSets, 0.05);
        this.main.unlock();
        Set<GraphObject> gos = this.getHighlighted(graph);
        graph.removeHighlights();
        ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 250, "Mutex groups", "Select mutex group to highlight", list, null, false, false, new ItemSelectionRunnable(){
            NodeGroup prev;

            @Override
            public void run(Collection selectedTerms) {
                if (this.prev != null) {
                    this.prev.highlight(false);
                }
                if (selectedTerms.isEmpty()) {
                    this.prev = null;
                    return;
                }
                Object o = selectedTerms.iterator().next();
                if (o.equals("None")) {
                    this.prev = null;
                    return;
                }
                NodeGroup group = (NodeGroup)o;
                group.highlight(true);
                this.prev = group;
            }
        });
        dialog.setUpdateUponSelection(true);
        dialog.open();
        graph.removeHighlights();
        this.highlight(gos);
    }

    private Set<String> getNodeNames(Graph graph) {
        HashSet<String> names = new HashSet<String>();
        for (Node node : graph.getNodes()) {
            names.add(node.getName());
        }
        return names;
    }

    private AlterationPack getAltPack(Node node) {
        return ChisioMain.cBioPortalAccessor.getAlterations(node.getName());
    }

    private List<NodeGroup> getMutexGroups(Graph graph, List<Set<String>> gisticSets, double pvalThr) {
        ArrayList<NodeGroup> groups = new ArrayList<NodeGroup>();
        ArrayList<Node> nodes = new ArrayList<Node>(graph.getNodes());
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (this.getAltPack(node) != null) continue;
            iter.remove();
        }
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                AlterationPack p1 = ShowMutexGroupsAction.this.getAltPack(o1);
                AlterationPack p2 = ShowMutexGroupsAction.this.getAltPack(o2);
                return new Integer(p2.getAlteredCount(Alteration.GENOMIC)).compareTo(p1.getAlteredCount(Alteration.GENOMIC));
            }
        });
        for (Node node : nodes) {
            NodeGroup group = new NodeGroup(node, gisticSets);
            for (int i = 0; i < 5; ++i) {
                this.addNextBestGene(group, nodes);
            }
            while (group.size() > 1 && group.getWorstMutexPVal() > pvalThr) {
                group.removeLast();
            }
            if (group.size() <= 1 || groups.contains(group)) continue;
            groups.add(group);
        }
        return groups;
    }

    private void addNextBestGene(NodeGroup group, List<Node> nodes) {
        Node best = null;
        double bestPval = 1.0;
        for (Node node : nodes) {
            if (group.contains(node) || this.getAltPack(node) == null) continue;
            group.addNode(node);
            double pval = group.getMeanMutexPVal();
            if (pval < bestPval) {
                bestPval = pval;
                best = node;
            }
            group.removeLast();
        }
        group.addNode(best);
    }

    class NodeGroup
    implements Comparable {
        List<Set<String>> closeGenes;
        LinkedList<Node> nodes;
        LinkedList<Change[]> alts;
        List<Edge> edges;
        Set<String> nodeNames;

        NodeGroup(Node node, List<Set<String>> closeGenes) {
            this.closeGenes = closeGenes;
            this.nodes = new LinkedList();
            this.nodes.add(node);
            this.nodeNames = new HashSet<String>();
            this.nodeNames.add(node.getName());
            this.alts = new LinkedList();
            this.alts.add(ShowMutexGroupsAction.this.getAltPack(node).get(Alteration.GENOMIC));
        }

        void addNode(Node node) {
            assert (this.edges == null);
            assert (!this.nodes.contains(node));
            if (this.hasDNAProximity(this.nodeNames, node.getName())) {
                this.alts.add(ShowMutexGroupsAction.this.getAltPack(node).get(Alteration.MUTATION));
            } else {
                this.alts.add(ShowMutexGroupsAction.this.getAltPack(node).get(Alteration.GENOMIC));
            }
            this.nodes.add(node);
            this.nodeNames.add(node.getName());
        }

        private boolean hasDNAProximity(Set<String> current, String query) {
            for (Set<String> set : this.closeGenes) {
                if (!set.contains(query)) continue;
                for (String s : current) {
                    if (!set.contains(s)) continue;
                    return true;
                }
            }
            return false;
        }

        void removeLast() {
            assert (this.edges == null);
            Node node = this.nodes.removeLast();
            this.nodeNames.remove(node.getName());
            this.alts.removeLast();
        }

        double[] getMutexPvals() {
            double[] pval = new double[this.nodes.size()];
            Iterator nodeIter = this.nodes.iterator();
            Iterator altIter = this.alts.iterator();
            int i = 0;
            while (nodeIter.hasNext()) {
                Node node = (Node)nodeIter.next();
                Change[] alt = (Change[])altIter.next();
                Change[] others = this.uniteAltExcluding(node);
                pval[i++] = Overlap.calcMutexPval(alt, others);
            }
            return pval;
        }

        double getMeanMutexPVal() {
            return Summary.geometricMean(this.getMutexPvals());
        }

        double getWorstMutexPVal() {
            return Summary.max(this.getMutexPvals());
        }

        Change[] uniteAltExcluding(Node node) {
            assert (this.size() > 1);
            if (this.size() == 2) {
                if (this.nodes.getFirst() == node) {
                    return this.alts.getLast();
                }
                return this.alts.getFirst();
            }
            Change[] ch = new Change[this.alts.getFirst().length];
            block0: for (int i = 0; i < ch.length; ++i) {
                ch[i] = Change.NO_CHANGE;
                Iterator nodeIter = this.nodes.iterator();
                Iterator altIter = this.alts.iterator();
                while (nodeIter.hasNext()) {
                    Node n = (Node)nodeIter.next();
                    Change[] alt = (Change[])altIter.next();
                    if (n == node || !alt[i].isAltered()) continue;
                    ch[i] = Change.UNKNOWN_CHANGE;
                    continue block0;
                }
            }
            return ch;
        }

        int size() {
            return this.nodes.size();
        }

        boolean contains(Node node) {
            return this.nodes.contains(node);
        }

        public String toString() {
            String s = this.nodes.get(0).getName();
            for (int i = 1; i < this.nodes.size(); ++i) {
                s = s + " - " + this.nodes.get(i).getName();
            }
            return s;
        }

        void highlight(boolean onoff) {
            if (this.edges == null) {
                this.fillEdges();
            }
            for (Node node : this.nodes) {
                node.setHighlight(onoff);
            }
            for (Edge edge : this.edges) {
                edge.setHighlight(onoff);
            }
        }

        private void fillEdges() {
            this.edges = new ArrayList<Edge>();
            for (Node node : this.nodes) {
                for (Edge edge : node.getUpstream()) {
                    if (!this.nodes.contains(edge.getSourceNode())) continue;
                    this.edges.add(edge);
                }
                for (Edge edge : node.getDownstream()) {
                    if (!this.nodes.contains(edge.getTargetNode())) continue;
                    this.edges.add(edge);
                }
            }
        }

        public int compareTo(Object o) {
            if (o instanceof NodeGroup) {
                NodeGroup g = (NodeGroup)o;
                return new Double(this.getMeanMutexPVal()).compareTo(g.getMeanMutexPVal());
            }
            return 0;
        }

        public int hashCode() {
            int h = 0;
            for (Node node : this.nodes) {
                h += node.hashCode();
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeGroup) {
                NodeGroup g = (NodeGroup)obj;
                return g.size() == this.size() && g.nodes.containsAll(this.nodes);
            }
            return false;
        }
    }
}

