/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeModel;
import org.gvt.model.NodeModel;

public class DeleteCommand
extends Command {
    private NodeModel child;
    private CompoundModel parent;
    private List sourceConnections = new ArrayList();
    private List targetConnections = new ArrayList();

    public DeleteCommand() {
        super("DeleteCommand_Label");
    }

    private void deleteConnections(NodeModel part) {
        int i;
        if (part instanceof CompoundModel) {
            List children = ((CompoundModel)part).getChildren();
            for (int i2 = 0; i2 < children.size(); ++i2) {
                this.deleteConnections((NodeModel)children.get(i2));
            }
        }
        this.sourceConnections.addAll(part.getSourceConnections());
        for (i = 0; i < this.sourceConnections.size(); ++i) {
            EdgeModel wire = (EdgeModel)this.sourceConnections.get(i);
            wire.setHighlight(false);
            wire.getTarget().removeTargetConnection(wire);
            wire.getSource().removeSourceConnection(wire);
        }
        this.targetConnections.addAll(part.getTargetConnections());
        for (i = 0; i < this.targetConnections.size(); ++i) {
            EdgeModel wire = (EdgeModel)this.targetConnections.get(i);
            wire.setHighlight(false);
            wire.getTarget().removeTargetConnection(wire);
            wire.getSource().removeSourceConnection(wire);
        }
    }

    @Override
    public void execute() {
        this.child.setHighlight(false);
        if (this.child instanceof CompoundModel) {
            this.removeHighlights((CompoundModel)this.child);
        }
        this.primExecute();
        this.parent.calculateSizeUp();
    }

    public void removeHighlights(CompoundModel mdl) {
        for (int i = 0; i < mdl.getChildren().size(); ++i) {
            NodeModel node = (NodeModel)mdl.getChildren().get(i);
            node.setHighlight(false);
            if (!(node instanceof CompoundModel)) continue;
            this.removeHighlights((CompoundModel)node);
        }
    }

    protected void primExecute() {
        this.deleteConnections(this.child);
        this.parent.removeChild(this.child);
    }

    @Override
    public void redo() {
        this.primExecute();
    }

    private void restoreConnections() {
        this.sourceConnections.clear();
        this.targetConnections.clear();
    }

    public void setChild(NodeModel c) {
        this.child = c;
    }

    public void setParent(CompoundModel p) {
        this.parent = p;
    }

    @Override
    public void undo() {
        this.parent.addChild(this.child);
        this.child.setParentModel(this.parent);
        this.restoreConnections();
    }
}

