/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.editpolicy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.gvt.command.CreateBendpointCommand;
import org.gvt.command.DeleteBendpointCommand;
import org.gvt.command.MoveBendpointCommand;
import org.gvt.figure.ConnectionBendpointHandle;
import org.gvt.model.EdgeModel;

public class ChsBendpointEditPolicy
extends BendpointEditPolicy {
    @Override
    protected List createSelectionHandles() {
        ArrayList<ConnectionBendpointHandle> list = new ArrayList<ConnectionBendpointHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        ArrayList bendPoints = (ArrayList)this.getConnection().getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = new ArrayList();
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = ((Bendpoint)bendPoints.get(0)).getLocation();
        }
        for (int i = 0; i < points.size() - 1; ++i) {
            list.add(new ConnectionBendpointHandle(connEP, bendPointIndex, i, "create"));
            if (i >= points.size() - 1 || bendPointIndex >= bendPoints.size() || !currBendPoint.equals(points.getPoint(i + 1))) continue;
            list.add(new ConnectionBendpointHandle(connEP, bendPointIndex, i + 1, "move"));
            if (++bendPointIndex >= bendPoints.size()) continue;
            currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
        }
        return list;
    }

    @Override
    protected Command getCreateBendpointCommand(BendpointRequest request) {
        CreateBendpointCommand com = new CreateBendpointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative(p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative(ref1);
        conn.translateToRelative(ref2);
        com.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        com.setWire((EdgeModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    @Override
    protected Command getMoveBendpointCommand(BendpointRequest request) {
        MoveBendpointCommand com = new MoveBendpointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative(p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative(ref1);
        conn.translateToRelative(ref2);
        com.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        com.setWire((EdgeModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    @Override
    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        DeleteBendpointCommand com = new DeleteBendpointCommand();
        Point p = request.getLocation();
        com.setLocation(p);
        com.setWire((EdgeModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }
}

