/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.editpolicy;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.gvt.ChsXYLayout;
import org.gvt.command.AddCommand;
import org.gvt.command.CreateCommand;
import org.gvt.command.MoveCommand;
import org.gvt.editpart.ChsCompoundEditPart;
import org.gvt.editpolicy.ChsNonResizableEditPolicy;
import org.gvt.editpolicy.ChsResizableEditPolicy;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;

public class ChsXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public ChsXYLayoutEditPolicy() {
        this.setXyLayout(new ChsXYLayout());
    }

    protected Command createAddCommand(Request request, EditPart childEditPart, Object constraint) {
        NodeModel part = (NodeModel)childEditPart.getModel();
        Rectangle rect = (Rectangle)constraint;
        AddCommand add = new AddCommand();
        add.setParent((CompoundModel)this.getHost().getModel());
        add.setChild(part);
        MoveCommand move = new MoveCommand(part, rect);
        move.setParent((CompoundModel)this.getHost().getModel());
        return add.chain(move);
    }

    @Override
    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return new MoveCommand(child, (Rectangle)constraint);
    }

    @Override
    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof ChsCompoundEditPart) {
            return new ChsNonResizableEditPolicy();
        }
        return new ChsResizableEditPolicy();
    }

    @Override
    protected IFigure createSizeOnDropFeedback(CreateRequest createRequest) {
        RectangleFigure figure = new RectangleFigure();
        figure.setFill(true);
        figure.setBackgroundColor(NodeModel.DEFAULT_COLOR);
        figure.setForegroundColor(ColorConstants.white);
        this.addFeedback(figure);
        return figure;
    }

    @Override
    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Add in ConstrainedLayoutEditPolicy");
        for (int i = 0; i < editParts.size(); ++i) {
            GraphicalEditPart childPart = (GraphicalEditPart)editParts.get(i);
            Rectangle r = childPart.getFigure().getBounds().getCopy();
            childPart.getFigure().translateToAbsolute(r);
            r = request.getTransformedRectangle(r);
            this.getLayoutContainer().translateToRelative(r);
            this.getLayoutContainer().translateFromParent(r);
            r.translate(this.getLayoutOrigin().getNegated());
            r.setSize(childPart.getFigure().getSize().getCopy());
            r.setLocation(r.getLocation().translate(1, 1));
            Object constraint = this.getConstraintFor(r);
            command.add(this.createAddCommand(generic, childPart, this.translateToModelConstraint(constraint)));
        }
        return command.unwrap();
    }

    @Override
    protected Command getCreateCommand(CreateRequest request) {
        CreateCommand create = new CreateCommand((CompoundModel)this.getHost().getModel(), (NodeModel)request.getNewObject());
        Rectangle constraint = (Rectangle)this.getConstraintFor(request);
        create.setConstraint(constraint);
        return create;
    }

    @Override
    protected Insets getCreationFeedbackOffset(CreateRequest request) {
        return new Insets();
    }

    @Override
    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    @Override
    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }

    @Override
    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }
}

