/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;

public class ConnectionPointHandle
extends ConnectionHandle {
    String point;

    public ConnectionPointHandle(ConnectionEditPart owner, String point) {
        this.setOwner(owner);
        this.point = point;
        if (point.equals("END")) {
            this.setLocator(new ConnectionLocator(this.getConnection(), 3));
        } else if (point.equals("START")) {
            this.setLocator(new ConnectionLocator(this.getConnection(), 2));
        }
    }

    @Override
    protected DragTracker createDragTracker() {
        if (this.isFixed()) {
            return null;
        }
        ConnectionEndpointTracker tracker = new ConnectionEndpointTracker((ConnectionEditPart)this.getOwner());
        if (this.point.equals("END")) {
            tracker.setCommandName("Reconnection target");
        } else if (this.point.equals("START")) {
            tracker.setCommandName("Reconnection source");
        }
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    @Override
    public void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r.shrink(1, 1);
        try {
            g.setBackgroundColor(ColorConstants.cyan);
            g.fillRectangle(r.x, r.y, r.width, r.height);
            g.setForegroundColor(ColorConstants.cyan);
            g.drawRectangle(r.x, r.y, r.width, r.height);
        }
        finally {
            r.expand(1, 1);
        }
    }
}

