/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import java.util.HashMap;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.gvt.ChisioMain;
import org.gvt.figure.EdgeFigure;
import org.gvt.figure.NodeFigure;
import org.gvt.model.ECluster;
import org.ivis.layout.Cluster;

public class HighlightLayer
extends Layer {
    public static final String HIGHLIGHT_LAYER = "Highlight Layer";
    public HashMap<Integer, HighlightClusterFigure> clusterHighlights = new HashMap();
    public HashMap highlighted = new HashMap();
    private int highlightBorder = 6;
    public static int counter = 0;

    public HighlightLayer() {
        this.setOpaque(true);
        this.setLayoutManager(new XYLayout());
    }

    public void addHighlightToCluster(Cluster cluster) {
        if (this.clusterHighlights.containsKey(cluster.getClusterID())) {
            this.remove(this.clusterHighlights.get(cluster.getClusterID()));
            this.clusterHighlights.remove(cluster.getClusterID());
        }
        HighlightClusterFigure highlight = new HighlightClusterFigure(this, cluster);
        this.clusterHighlights.put(cluster.getClusterID(), highlight);
        this.add((IFigure)highlight, ((ECluster)cluster).getPointList().getBounds().getCopy().expand(1, 1));
    }

    public void removeHighlightFromCluster(Cluster cluster) {
        if (this.clusterHighlights.containsKey(cluster.getClusterID())) {
            this.remove(this.clusterHighlights.get(cluster.getClusterID()));
            this.clusterHighlights.remove(cluster.getClusterID());
        }
    }

    public void addHighlightToNode(NodeFigure object) {
        this.removeHighlight(object);
        HighlightNodeFigure highlight = new HighlightNodeFigure(object);
        this.highlighted.put(object, highlight);
        this.add((IFigure)highlight, object.getBounds().getCopy());
    }

    public void addHighlightToEdge(EdgeFigure object) {
        this.removeHighlight(object);
        HighlightEdgeFigure highlight = new HighlightEdgeFigure(object);
        this.highlighted.put(object, highlight);
        this.add((IFigure)highlight, object.getBounds().getCopy());
    }

    public void removeHighlight(IFigure object) {
        if (this.highlighted.containsKey(object)) {
            this.remove((IFigure)this.highlighted.get(object));
            this.highlighted.remove(object);
        }
    }

    public void refreshHighlights() {
        Object[] keys = this.highlighted.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            Figure fig;
            Object obj = keys[i];
            if (obj instanceof EdgeFigure) {
                fig = (EdgeFigure)obj;
                ((EdgeFigure)fig).updateHighlight(this, ((EdgeFigure)fig).highlight);
                continue;
            }
            fig = (NodeFigure)obj;
            ((NodeFigure)fig).updateHighlight(this, ((NodeFigure)fig).highlight);
        }
    }

    class HighlightEdgeFigure
    extends Figure {
        EdgeFigure figure;

        public HighlightEdgeFigure(IFigure figure) {
            this.figure = (EdgeFigure)figure;
            if (this.figure.highlightColor == null) {
                this.figure.highlightColor = ChisioMain.higlightColor;
            }
        }

        @Override
        protected void paintFigure(Graphics graphics) {
            this.setBounds(this.figure.getBounds());
            graphics.setForegroundColor(this.figure.highlightColor);
            graphics.setLineWidth(HighlightLayer.this.highlightBorder);
            if (ChisioMain.runningOnWindows) {
                graphics.setAlpha(150);
            }
            graphics.drawPolyline(this.figure.getPoints().getCopy());
        }
    }

    class HighlightNodeFigure
    extends Figure {
        NodeFigure figure;

        public HighlightNodeFigure(IFigure figure) {
            this.figure = (NodeFigure)figure;
            if (this.figure.highlightColor == null) {
                this.figure.highlightColor = ChisioMain.higlightColor;
            }
        }

        @Override
        protected void paintFigure(Graphics graphics) {
            Rectangle r = this.figure.getBounds().getCopy();
            r.expand(HighlightLayer.this.highlightBorder - 1, HighlightLayer.this.highlightBorder - 1);
            this.setBounds(r);
            if (ChisioMain.runningOnWindows) {
                graphics.setAlpha(150);
            }
            graphics.setBackgroundColor(this.figure.highlightColor);
            Rectangle rect = r.getCopy();
            rect.width = HighlightLayer.this.highlightBorder;
            graphics.fillRectangle(rect);
            rect.x = r.x + r.width - HighlightLayer.this.highlightBorder;
            graphics.fillRectangle(rect);
            rect = r.getCopy();
            rect.width -= 2 * (HighlightLayer.this.highlightBorder - 1);
            rect.height = HighlightLayer.this.highlightBorder;
            rect.x += HighlightLayer.this.highlightBorder - 1;
            graphics.fillRectangle(rect);
            rect.y = r.y + r.height - HighlightLayer.this.highlightBorder;
            graphics.fillRectangle(rect);
        }
    }

    class HighlightClusterFigure
    extends Figure {
        ECluster cluster;
        HighlightLayer layer;

        public HighlightClusterFigure(HighlightLayer layer, Cluster cluster) {
            this.cluster = (ECluster)cluster;
            this.layer = layer;
        }

        @Override
        protected void paintFigure(Graphics graphics) {
            if (ChisioMain.runningOnWindows) {
                graphics.setAlpha(100);
            }
            PointList pl = this.cluster.getPointList();
            Rectangle rect = pl.getBounds().getCopy();
            this.setBounds(rect);
            graphics.setBackgroundColor(this.cluster.getHighlightColor());
            graphics.setForegroundColor(this.cluster.getHighlightColor());
            graphics.fillPolygon(pl);
            this.layer.repaint(rect);
        }
    }
}

