/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.gvt.figure.InfoFigure;

public class RoundRectWithInfo
extends Figure {
    List<String> infos;
    boolean multimer;
    int borderWidth;
    protected static final int SPAN = 12;

    public RoundRectWithInfo(Rectangle bounds, List<String> infos, Label label, boolean multimer, int borderWidth) {
        this.setBounds(bounds);
        this.infos = infos;
        this.multimer = multimer;
        this.borderWidth = borderWidth;
        this.add(label);
        if (infos != null) {
            bounds = bounds.getCopy();
            bounds.x += 2;
            bounds.width -= 4;
            for (int i = 0; i < infos.size(); ++i) {
                String info = infos.get(i);
                InfoFigure fig = new InfoFigure(info, i, bounds, new Dimension(12, 12));
                this.add(fig);
            }
        }
    }

    @Override
    protected void paintFigure(Graphics g) {
        g.setAntialias(1);
        Rectangle bounds = this.getParent().getBounds().getCopy();
        this.setBounds(bounds);
        Rectangle rect = bounds.getCopy();
        rect.y += 6;
        rect.height -= 12;
        int rounding = 10;
        Rectangle copy = rect.getCopy();
        copy.x -= this.borderWidth;
        copy.y -= this.borderWidth;
        copy.width += 2 * this.borderWidth;
        copy.height += 2 * this.borderWidth;
        g.setClip(copy);
        int old = g.getLineWidth();
        g.setLineWidth(this.borderWidth);
        if (this.multimer) {
            int shift = 2;
            rect.height -= shift;
            rect.width -= shift;
            rect.x += shift;
            rect.y += shift;
            g.fillRoundRectangle(rect, rounding, rounding);
            --rect.height;
            --rect.width;
            g.drawRoundRectangle(rect, rounding, rounding);
            ++rect.height;
            ++rect.width;
            rect.x -= shift;
            rect.y -= shift;
            g.fillRoundRectangle(rect, rounding, rounding);
            --rect.height;
            --rect.width;
            g.drawRoundRectangle(rect, rounding, rounding);
        } else {
            g.fillRoundRectangle(rect, rounding, rounding);
            --rect.height;
            --rect.width;
            g.drawRoundRectangle(rect, rounding, rounding);
        }
        g.setLineWidth(old);
    }
}

