/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.text.DecimalFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;

public class HighlightWithDataValuesDialog
extends Dialog {
    private Shell shell;
    private Label infoLabel;
    private Button buttonMin;
    private Button buttonMax;
    private Text textMin;
    private Text textMax;
    private Scale scaleMin;
    private Scale scaleMax;
    private Button withinButton;
    private Button outsideButton;
    private Button okButton;
    private Button cancelButton;
    private double minBound;
    private double maxBound;
    private double minResult;
    private double maxResult;
    private double[] resultArray;
    private boolean rangeType;
    private boolean okPressed;
    private boolean newData;
    static boolean[] currentBoolean = new boolean[3];
    static int[] currentInt = new int[2];
    static String[] currentString = new String[2];

    public HighlightWithDataValuesDialog(Shell parent, double maxBound, double minBound, boolean newData) {
        super(parent, 0);
        this.minBound = minBound;
        this.maxBound = maxBound;
        this.newData = newData;
        this.minResult = -1.7976931348623157E308;
        this.maxResult = Double.MAX_VALUE;
        this.resultArray = new double[]{this.minResult, this.maxResult};
        this.rangeType = true;
        this.okPressed = false;
    }

    public boolean open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.okPressed;
    }

    public void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Highlight With Data Values");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.shell.setLayout(gridLayout);
        this.infoLabel = new Label(this.shell, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 5;
        this.infoLabel.setLayoutData(gridData);
        this.infoLabel.setText("Choose range of interest for data values");
        Group scaleGroup = new Group(this.shell, 0);
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 3;
        scaleGroup.setLayoutData(gridData);
        scaleGroup.setLayout(new GridLayout(3, false));
        this.buttonMin = new Button(scaleGroup, 96);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        this.buttonMin.setLayoutData(gridData);
        this.buttonMin.setText("Min");
        this.buttonMin.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                HighlightWithDataValuesDialog.this.textMin.setEnabled(HighlightWithDataValuesDialog.this.buttonMin.getSelection());
                HighlightWithDataValuesDialog.this.scaleMin.setEnabled(HighlightWithDataValuesDialog.this.buttonMin.getSelection());
                if (HighlightWithDataValuesDialog.this.buttonMin.getSelection() && HighlightWithDataValuesDialog.this.scaleMin.getSelection() > HighlightWithDataValuesDialog.this.scaleMax.getSelection()) {
                    HighlightWithDataValuesDialog.this.scaleMin.setSelection(HighlightWithDataValuesDialog.this.scaleMax.getSelection());
                    HighlightWithDataValuesDialog.this.textMin.setText(HighlightWithDataValuesDialog.this.textMax.getText());
                }
                if (!HighlightWithDataValuesDialog.this.buttonMax.getSelection() || !HighlightWithDataValuesDialog.this.buttonMin.getSelection()) {
                    HighlightWithDataValuesDialog.this.outsideButton.setEnabled(false);
                    HighlightWithDataValuesDialog.this.withinButton.setEnabled(false);
                    HighlightWithDataValuesDialog.this.rangeType = true;
                } else {
                    HighlightWithDataValuesDialog.this.outsideButton.setEnabled(true);
                    HighlightWithDataValuesDialog.this.withinButton.setEnabled(true);
                    HighlightWithDataValuesDialog.this.rangeType = HighlightWithDataValuesDialog.this.withinButton.getSelection();
                }
            }
        });
        this.textMin = new Text(scaleGroup, 2052);
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.widthHint = 60;
        this.textMin.setLayoutData(gridData);
        this.textMin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                try {
                    String text;
                    int code = event.keyCode;
                    if (code == 13 && !(text = ((Text)event.widget).getText()).isEmpty()) {
                        Double textDouble = Double.parseDouble(text);
                        int value = HighlightWithDataValuesDialog.this.double2Scale(textDouble);
                        if (textDouble < HighlightWithDataValuesDialog.this.minBound) {
                            HighlightWithDataValuesDialog.this.textMin.setText(HighlightWithDataValuesDialog.this.minBound + "");
                        }
                        if (textDouble > HighlightWithDataValuesDialog.this.maxBound) {
                            HighlightWithDataValuesDialog.this.textMin.setText(HighlightWithDataValuesDialog.this.maxBound + "");
                        }
                        if (value > HighlightWithDataValuesDialog.this.scaleMax.getSelection() && HighlightWithDataValuesDialog.this.buttonMax.getSelection()) {
                            HighlightWithDataValuesDialog.this.scaleMin.setSelection(HighlightWithDataValuesDialog.this.scaleMax.getSelection());
                            HighlightWithDataValuesDialog.this.textMin.setText(HighlightWithDataValuesDialog.this.textMax.getText());
                        } else {
                            HighlightWithDataValuesDialog.this.scaleMin.setSelection(value);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    MessageDialog.openError(HighlightWithDataValuesDialog.this.shell, "Invalid input!", "Please enter a valid number.");
                }
            }
        });
        this.scaleMin = new Scale(scaleGroup, 256);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = 200;
        this.scaleMin.setLayoutData(gridData);
        this.scaleMin.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                HighlightWithDataValuesDialog.this.textMin.setText(HighlightWithDataValuesDialog.this.scale2Double(HighlightWithDataValuesDialog.this.scaleMin.getSelection()) + "");
                if (HighlightWithDataValuesDialog.this.scaleMax.getSelection() < HighlightWithDataValuesDialog.this.scaleMin.getSelection() && HighlightWithDataValuesDialog.this.buttonMax.getSelection()) {
                    HighlightWithDataValuesDialog.this.scaleMax.setSelection(HighlightWithDataValuesDialog.this.scaleMin.getSelection());
                    HighlightWithDataValuesDialog.this.textMax.setText(HighlightWithDataValuesDialog.this.textMin.getText());
                }
            }
        });
        this.scaleMin.setMaximum(1000);
        this.scaleMin.setMinimum(0);
        this.scaleMin.setIncrement(1);
        this.scaleMin.setPageIncrement(100);
        this.buttonMax = new Button(scaleGroup, 96);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        this.buttonMax.setLayoutData(gridData);
        this.buttonMax.setText("Max");
        this.buttonMax.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                HighlightWithDataValuesDialog.this.textMax.setEnabled(HighlightWithDataValuesDialog.this.buttonMax.getSelection());
                HighlightWithDataValuesDialog.this.scaleMax.setEnabled(HighlightWithDataValuesDialog.this.buttonMax.getSelection());
                if (HighlightWithDataValuesDialog.this.buttonMax.getSelection() && HighlightWithDataValuesDialog.this.scaleMax.getSelection() < HighlightWithDataValuesDialog.this.scaleMin.getSelection()) {
                    HighlightWithDataValuesDialog.this.scaleMax.setSelection(HighlightWithDataValuesDialog.this.scaleMin.getSelection());
                    HighlightWithDataValuesDialog.this.textMax.setText(HighlightWithDataValuesDialog.this.textMin.getText());
                }
                if (!HighlightWithDataValuesDialog.this.buttonMax.getSelection() || !HighlightWithDataValuesDialog.this.buttonMin.getSelection()) {
                    HighlightWithDataValuesDialog.this.outsideButton.setEnabled(false);
                    HighlightWithDataValuesDialog.this.withinButton.setEnabled(false);
                    HighlightWithDataValuesDialog.this.rangeType = true;
                } else {
                    HighlightWithDataValuesDialog.this.outsideButton.setEnabled(true);
                    HighlightWithDataValuesDialog.this.withinButton.setEnabled(true);
                    HighlightWithDataValuesDialog.this.rangeType = HighlightWithDataValuesDialog.this.withinButton.getSelection();
                }
            }
        });
        this.textMax = new Text(scaleGroup, 2052);
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.widthHint = 60;
        this.textMax.setLayoutData(gridData);
        this.textMax.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                try {
                    String text;
                    int code = event.keyCode;
                    if (code == 13 && !(text = ((Text)event.widget).getText()).isEmpty()) {
                        Double textDouble = Double.parseDouble(text);
                        int value = HighlightWithDataValuesDialog.this.double2Scale(textDouble);
                        if (textDouble < HighlightWithDataValuesDialog.this.minBound) {
                            HighlightWithDataValuesDialog.this.textMax.setText(HighlightWithDataValuesDialog.this.minBound + "");
                        }
                        if (textDouble > HighlightWithDataValuesDialog.this.maxBound) {
                            HighlightWithDataValuesDialog.this.textMax.setText(HighlightWithDataValuesDialog.this.maxBound + "");
                        }
                        if (value < HighlightWithDataValuesDialog.this.scaleMin.getSelection() && HighlightWithDataValuesDialog.this.buttonMin.getSelection()) {
                            HighlightWithDataValuesDialog.this.scaleMax.setSelection(HighlightWithDataValuesDialog.this.scaleMin.getSelection());
                            HighlightWithDataValuesDialog.this.textMax.setText(HighlightWithDataValuesDialog.this.textMin.getText());
                        } else {
                            HighlightWithDataValuesDialog.this.scaleMax.setSelection(value);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    MessageDialog.openError(HighlightWithDataValuesDialog.this.shell, "Invalid input!", "Please enter a valid number.");
                }
            }
        });
        this.scaleMax = new Scale(scaleGroup, 256);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = 200;
        this.scaleMax.setLayoutData(gridData);
        this.scaleMax.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                HighlightWithDataValuesDialog.this.textMax.setText(HighlightWithDataValuesDialog.this.scale2Double(HighlightWithDataValuesDialog.this.scaleMax.getSelection()) + "");
                if (HighlightWithDataValuesDialog.this.scaleMax.getSelection() < HighlightWithDataValuesDialog.this.scaleMin.getSelection() && HighlightWithDataValuesDialog.this.buttonMin.getSelection()) {
                    HighlightWithDataValuesDialog.this.scaleMin.setSelection(HighlightWithDataValuesDialog.this.scaleMax.getSelection());
                    HighlightWithDataValuesDialog.this.textMin.setText(HighlightWithDataValuesDialog.this.textMax.getText());
                }
            }
        });
        this.scaleMax.setMaximum(1000);
        this.scaleMax.setMinimum(0);
        this.scaleMax.setIncrement(1);
        this.scaleMax.setPageIncrement(100);
        Group rangeGroup = new Group(this.shell, 0);
        gridData = new GridData(0x1000008, 1, false, false);
        gridData.horizontalSpan = 1;
        rangeGroup.setLayoutData(gridData);
        rangeGroup.setLayout(new GridLayout(1, true));
        this.withinButton = new Button(rangeGroup, 16);
        gridData = new GridData(1, 0x1000000, false, false);
        this.withinButton.setLayoutData(gridData);
        this.withinButton.setText("Within specified range");
        this.withinButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                HighlightWithDataValuesDialog.this.rangeType = HighlightWithDataValuesDialog.this.withinButton.getSelection();
            }
        });
        this.outsideButton = new Button(rangeGroup, 16);
        gridData = new GridData(1, 0x1000000, false, false);
        this.outsideButton.setLayoutData(gridData);
        this.outsideButton.setText("Outside specified range");
        Composite okCancelGroup = new Composite(this.shell, 0);
        gridData = new GridData(4, 0x1000008, false, false);
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 9;
        okCancelGroup.setLayoutData(gridData);
        okCancelGroup.setLayout(new GridLayout(2, true));
        this.okButton = new Button(okCancelGroup, 0);
        this.okButton.setText("OK");
        gridData = new GridData(0x1000008, 0x1000000, true, false);
        this.okButton.setLayoutData(gridData);
        this.okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!HighlightWithDataValuesDialog.this.buttonMax.getSelection() && !HighlightWithDataValuesDialog.this.buttonMin.getSelection() || HighlightWithDataValuesDialog.this.textMax.getText().isEmpty() && HighlightWithDataValuesDialog.this.textMin.getText().isEmpty()) {
                    MessageDialog.openWarning(HighlightWithDataValuesDialog.this.shell, "No Data", "Choose at least one boundary.");
                    return;
                }
                if (HighlightWithDataValuesDialog.this.buttonMax.getSelection() && !HighlightWithDataValuesDialog.this.textMax.getText().isEmpty()) {
                    HighlightWithDataValuesDialog.this.maxResult = Double.parseDouble(HighlightWithDataValuesDialog.this.textMax.getText());
                }
                if (HighlightWithDataValuesDialog.this.buttonMin.getSelection() && !HighlightWithDataValuesDialog.this.textMin.getText().isEmpty()) {
                    HighlightWithDataValuesDialog.this.minResult = Double.parseDouble(HighlightWithDataValuesDialog.this.textMin.getText());
                }
                ((HighlightWithDataValuesDialog)HighlightWithDataValuesDialog.this).resultArray[0] = HighlightWithDataValuesDialog.this.minResult;
                ((HighlightWithDataValuesDialog)HighlightWithDataValuesDialog.this).resultArray[1] = HighlightWithDataValuesDialog.this.maxResult;
                HighlightWithDataValuesDialog.this.okPressed = true;
                HighlightWithDataValuesDialog.this.storeSelections();
                HighlightWithDataValuesDialog.this.shell.close();
            }
        });
        this.cancelButton = new Button(okCancelGroup, 0);
        this.cancelButton.setText("Cancel");
        gridData = new GridData(1, 0x1000000, true, false);
        this.cancelButton.setLayoutData(gridData);
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                HighlightWithDataValuesDialog.this.shell.close();
            }
        });
        if (this.newData) {
            this.setInitialValues();
        } else {
            this.useCurrentSelections();
        }
    }

    private void setInitialValues() {
        this.buttonMin.setSelection(true);
        this.buttonMax.setSelection(true);
        this.withinButton.setSelection(true);
        this.scaleMin.setSelection(this.scaleMin.getMinimum());
        this.scaleMax.setSelection(this.scaleMax.getMaximum());
        this.textMin.setText(this.minBound + "");
        this.textMax.setText(this.maxBound + "");
    }

    private void storeSelections() {
        HighlightWithDataValuesDialog.currentBoolean[0] = this.buttonMin.getSelection();
        HighlightWithDataValuesDialog.currentBoolean[1] = this.buttonMax.getSelection();
        HighlightWithDataValuesDialog.currentBoolean[2] = this.withinButton.getSelection();
        HighlightWithDataValuesDialog.currentInt[0] = this.scaleMin.getSelection();
        HighlightWithDataValuesDialog.currentInt[1] = this.scaleMax.getSelection();
        HighlightWithDataValuesDialog.currentString[0] = this.textMin.getText();
        HighlightWithDataValuesDialog.currentString[1] = this.textMax.getText();
    }

    private void useCurrentSelections() {
        this.buttonMin.setSelection(currentBoolean[0]);
        this.buttonMax.setSelection(currentBoolean[1]);
        this.withinButton.setSelection(currentBoolean[2]);
        this.outsideButton.setSelection(!currentBoolean[2]);
        this.withinButton.setEnabled(currentBoolean[0] && currentBoolean[1]);
        this.outsideButton.setEnabled(currentBoolean[0] && currentBoolean[1]);
        this.rangeType = !currentBoolean[0] || !currentBoolean[1] ? true : currentBoolean[2];
        this.scaleMin.setSelection(currentInt[0]);
        this.scaleMin.setEnabled(currentBoolean[0]);
        this.scaleMax.setSelection(currentInt[1]);
        this.scaleMax.setEnabled(currentBoolean[1]);
        this.textMin.setText(currentString[0]);
        this.textMin.setEnabled(currentBoolean[0]);
        this.textMax.setText(currentString[1]);
        this.textMax.setEnabled(currentBoolean[1]);
    }

    private int double2Scale(double actual) {
        double factor = 1000.0 / (this.maxBound - this.minBound);
        double scale = (actual - this.minBound) * factor;
        return (int)scale;
    }

    private double scale2Double(int scale) {
        double factor = (this.maxBound - this.minBound) / 1000.0;
        double actual = this.minBound + (double)scale * factor;
        double formatted = Double.parseDouble(new DecimalFormat("#.##").format(actual));
        return formatted;
    }

    public double[] getResultArray() {
        return this.resultArray;
    }

    public boolean getRangeType() {
        return this.rangeType;
    }
}

