/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cbio.causality.rppa.RPPAData;
import org.cbio.causality.rppa.RPPAFileReader;
import org.cbio.causality.rppa.RPPANetworkMapper;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.gvt.gui.ItemSelectionDialog;

public class RPPAWizard
extends Wizard {
    FormatType formatType;
    ValueAmount valueAmount;
    public ValueMetric valueMetric;
    public ComparisonType comparisonType;
    String platFile;
    String valuesFile;
    String idColName;
    String siteColName;
    String symbolColName;
    String effectColName;
    String valueColName;
    List<String> vals0;
    List<String> vals1;
    public NetworkType networkType;
    public Centricity centricity;
    public double threshold = -1.0;
    public Set<RPPAData> activities;
    public Set<String> filterToGenes;
    FormatSelectionPage formatSelectionPage;
    PlatLoadPage platLoadPage;
    SingleFileSingleValueLoadPage singleFileSingleValueLoadPage;
    TwoGroupsPage twoGroupsPage;
    SingleValuePage singleValuePage;
    NetworkPage networkPage;
    ActivityAndFilterPage activityAndFilterPage;
    Text activityText;
    Text filterText;

    @Override
    public void addPages() {
        this.formatSelectionPage = new FormatSelectionPage();
        this.addPage(this.formatSelectionPage);
        this.platLoadPage = new PlatLoadPage();
        this.addPage(this.platLoadPage);
        this.singleFileSingleValueLoadPage = new SingleFileSingleValueLoadPage();
        this.addPage(this.singleFileSingleValueLoadPage);
        this.twoGroupsPage = new TwoGroupsPage();
        this.addPage(this.twoGroupsPage);
        this.singleValuePage = new SingleValuePage();
        this.addPage(this.singleValuePage);
        this.networkPage = new NetworkPage();
        this.addPage(this.networkPage);
        this.activityAndFilterPage = new ActivityAndFilterPage();
        this.addPage(this.activityAndFilterPage);
    }

    @Override
    public boolean performFinish() {
        this.readActivityAndFilter();
        return true;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.formatSelectionPage) {
            if (this.formatType == FormatType.SINGLE_FILE && this.valueAmount == ValueAmount.SINGLE) {
                return this.singleFileSingleValueLoadPage;
            }
            return this.platLoadPage;
        }
        if (page == this.platLoadPage && this.valueAmount == ValueAmount.TWO_GROUPS) {
            this.twoGroupsPage.initList();
            this.getShell().pack();
            return this.twoGroupsPage;
        }
        if (page == this.platLoadPage && this.formatType == FormatType.TWO_FILES) {
            return this.singleValuePage;
        }
        if (page == this.singleFileSingleValueLoadPage || page == this.twoGroupsPage) {
            return this.networkPage;
        }
        if (page == this.networkPage) {
            return this.activityAndFilterPage;
        }
        return super.getNextPage(page);
    }

    @Override
    public boolean canFinish() {
        return this.networkType != null;
    }

    protected void readActivityAndFilter() {
        this.activities = new HashSet<RPPAData>();
        for (String s : this.activityText.getText().split("\\n")) {
            String sym;
            Boolean b;
            String first = s = s.trim();
            if (s.contains(" ")) {
                first = s.substring(0, s.indexOf(" "));
            }
            Boolean bl = first.endsWith("+") ? Boolean.TRUE : (b = first.endsWith("-") ? Boolean.FALSE : null);
            if (b == null || (sym = first.substring(0, first.length() - 1)).isEmpty()) continue;
            RPPAData data = new RPPAData(s, null, Arrays.asList(sym), null);
            data.makeActivityNode(b);
            this.activities.add(data);
        }
        this.filterToGenes = new HashSet<String>();
        for (String s : this.filterText.getText().split("\\s+")) {
            if (s.isEmpty()) continue;
            this.filterToGenes.add(s);
        }
    }

    public List<RPPAData> readData() throws FileNotFoundException {
        List<RPPAData> datas = RPPAFileReader.readAnnotation(this.platFile, this.idColName, this.symbolColName, this.siteColName, this.effectColName);
        if (this.formatType == FormatType.SINGLE_FILE) {
            RPPAFileReader.addValues(datas, this.platFile, this.idColName, this.vals0, this.vals1, 0.0);
        } else if (this.formatType == FormatType.TWO_FILES) {
            RPPAFileReader.addValues(datas, this.valuesFile, this.idColName, this.vals0, this.vals1, 0.0);
        }
        datas.addAll(this.activities);
        RPPAData.ChangeAdapter chDet = null;
        if (this.valueAmount != ValueAmount.TWO_GROUPS && this.valueMetric == ValueMetric.VALS_AROUND_ZERO) {
            chDet = ChangeDet.VALS_WITH_CENTER_0.det;
        } else if (this.valueAmount == ValueAmount.TWO_GROUPS) {
            if (this.comparisonType == ComparisonType.TTEST) {
                chDet = ChangeDet.TTEST.det;
            } else if (this.comparisonType == ComparisonType.LOG2_RATIO) {
                chDet = ChangeDet.LOG_2_OF_RATIOS.det;
            } else if (this.comparisonType == ComparisonType.DIFF) {
                chDet = ChangeDet.DIFF.det;
            }
        } else if (this.valueAmount == ValueAmount.SINGLE) {
            if (this.valueMetric == ValueMetric.PVAL) {
                chDet = ChangeDet.SIGNED_PVAL.det;
            } else if (this.valueMetric == ValueMetric.RATIO) {
                chDet = ChangeDet.TAKE_LOG_2_OF_VAL.det;
            }
        }
        if (chDet == null) {
            System.err.println("Not implemented yet.");
            return null;
        }
        chDet.setThreshold(this.threshold);
        for (RPPAData data : datas) {
            if (data.isActivity()) continue;
            data.setChDet(chDet);
        }
        return datas;
    }

    public String getSIFFilename() {
        String s = null;
        if (this.valuesFile != null) {
            s = this.valuesFile;
        } else if (this.platFile != null) {
            s = this.platFile;
        }
        if (s == null) {
            return null;
        }
        int sepIndex = s.lastIndexOf(File.separator);
        int dotInd = s.lastIndexOf(".");
        if (dotInd > 0 && dotInd > sepIndex) {
            s = s.substring(0, dotInd);
        }
        s = s + ".sif";
        return s;
    }

    static enum ChangeDet {
        VALS_WITH_CENTER_0(new RPPAData.ChangeAdapter(){}),
        POSITIVE_VALS_WITH_CENTER_1(new RPPAData.ChangeAdapter(){

            @Override
            public int getChangeSign(RPPAData data) {
                double val = this.getChangeValue(data);
                if (val >= this.threshold) {
                    return 1;
                }
                if (val <= 1.0 / this.threshold) {
                    return -1;
                }
                return 0;
            }
        }),
        TAKE_LOG_2_OF_VAL(new RPPAData.ChangeAdapter(){

            @Override
            public double getChangeValue(RPPAData data) {
                return data.getLog2MeanVal();
            }
        }),
        LOG_2_OF_RATIOS(new RPPAData.ChangeAdapter(){

            @Override
            public double getChangeValue(RPPAData data) {
                return data.getLog2Ratio();
            }
        }),
        TTEST(new RPPAData.ChangeAdapter(){

            @Override
            public int getChangeSign(RPPAData data) {
                double pval = data.getTTestPval();
                if (pval > this.threshold) {
                    return 0;
                }
                if (this.getChangeValue(data) > 0.0) {
                    return 1;
                }
                return -1;
            }

            @Override
            public double getChangeValue(RPPAData data) {
                return data.getSignificanceBasedVal();
            }
        }),
        SIGNED_PVAL(new RPPAData.ChangeAdapter(){

            @Override
            public int getChangeSign(RPPAData data) {
                double pval = data.getMeanVal();
                if (Math.abs(pval) > this.threshold) {
                    return 0;
                }
                return pval > 0.0 ? 1 : -1;
            }

            @Override
            public double getChangeValue(RPPAData data) {
                double val = -Math.log(Math.abs(data.getMeanVal())) / Math.log(2.0);
                if (data.getMeanVal() < 0.0) {
                    val *= -1.0;
                }
                return val;
            }
        }),
        DIFF(new RPPAData.ChangeAdapter(){

            @Override
            public double getChangeValue(RPPAData data) {
                return data.getDifOfMeans();
            }
        });

        RPPAData.ChangeAdapter det;

        private ChangeDet(RPPAData.ChangeAdapter det) {
            this.det = det;
        }
    }

    public static enum Centricity {
        GENE_CENTRIC("Gene Centric Network"),
        ANTIBODY_CENTRIC("Antibody Centric Network");

        String text;

        private Centricity(String text) {
            this.text = text;
        }

        static Centricity typeOf(String text) {
            for (Centricity type : Centricity.values()) {
                if (!type.text.equals(text)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum NetworkType {
        COMPATIBLE_NETWORK("Show compatible relations between changed molecules", RPPANetworkMapper.GraphType.COMPATIBLE),
        COMPATIBLE_WITH_SITE_MATCH("Show compatible relations with matching sites", RPPANetworkMapper.GraphType.COMPATIBLE_WITH_SITE_MATCH),
        CONFLICTING_NETWORK("Show conflicting relations between changed molecules", RPPANetworkMapper.GraphType.CONFLICTING),
        CONFLICTING_WITH_SITE_MATCH("Show conflicting relations with matching sites", RPPANetworkMapper.GraphType.CONFLICTING_WITH_SITE_MATCH);

        String text;
        public RPPANetworkMapper.GraphType type;

        private NetworkType(String text, RPPANetworkMapper.GraphType type) {
            this.text = text;
            this.type = type;
        }

        static NetworkType typeOf(String text) {
            for (NetworkType type : NetworkType.values()) {
                if (!type.text.equals(text)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ComparisonType {
        LOG2_RATIO("Log-2-ratio of values"),
        TTEST("P-value of a t-test"),
        DIFF("Difference of values");

        String text;

        private ComparisonType(String text) {
            this.text = text;
        }

        static ComparisonType typeOf(String text) {
            for (ComparisonType type : ComparisonType.values()) {
                if (!type.text.equals(text)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ValueMetric {
        MEASUREMENT("Measurement (non-negative)"),
        VALS_AROUND_ZERO("Values around zero"),
        RATIO("Ratio (take log-2)"),
        LOG2_RAT("Log-2-ratio"),
        PVAL("P-values (use sign to indicate decrease)");

        String text;

        private ValueMetric(String text) {
            this.text = text;
        }

        static ValueMetric typeOf(String text) {
            for (ValueMetric type : ValueMetric.values()) {
                if (!type.text.equals(text)) continue;
                return type;
            }
            return null;
        }
    }

    static enum ValueAmount {
        SINGLE("Single value"),
        GROUP("A group of values"),
        TWO_GROUPS("Two groups of values");

        String text;

        private ValueAmount(String text) {
            this.text = text;
        }

        static ValueAmount typeOf(String text) {
            for (ValueAmount type : ValueAmount.values()) {
                if (!type.text.equals(text)) continue;
                return type;
            }
            return null;
        }
    }

    static enum FormatType {
        SINGLE_FILE("Single file"),
        TWO_FILES("An annotation and one value(s) file"),
        MULTIPLE_FILES("An annotation and several value files");

        String text;

        private FormatType(String text) {
            this.text = text;
        }

        static FormatType typeOf(String text) {
            for (FormatType type : FormatType.values()) {
                if (!type.text.equals(text)) continue;
                return type;
            }
            return null;
        }
    }

    class ActivityAndFilterPage
    extends WizardPage {
        ActivityAndFilterPage() {
            super("filter");
            this.setTitle("Activities and gene filter");
            this.setDescription("Enter other activity changes that should be included to the analysis. The network can also be cropped to gene symbols of focus using this page.");
        }

        @Override
        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout(layout);
            Group group = new Group(composite, 2048);
            layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout(layout);
            group.setText("Enter activites as symbol and a plus (+) or a minus (-)");
            group.setToolTipText("Examples: AKT1+ EGFR-");
            RPPAWizard.this.activityText = new Text(group, 2);
            GridData data = new GridData();
            data.minimumWidth = 300;
            data.minimumHeight = 80;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            RPPAWizard.this.activityText.setLayoutData(data);
            group = new Group(composite, 2048);
            layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout(layout);
            group.setText("Enter genes to crop the network");
            group.setToolTipText("Only the relation(s) that are related with these genes will be shown.");
            RPPAWizard.this.filterText = new Text(group, 2);
            data = new GridData();
            data.minimumWidth = 300;
            data.minimumHeight = 80;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            RPPAWizard.this.filterText.setLayoutData(data);
            this.setControl(composite);
        }
    }

    class NetworkPage
    extends WizardPage {
        NetworkPage() {
            super("network");
            this.setTitle("Network type");
            this.setDescription("Select the desired method to generate the network using RPPA data.");
        }

        @Override
        public void createControl(Composite parent) {
            Button b;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = true;
            composite.setLayout(layout);
            Group group = new Group(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout(layout);
            group.setText("Select desired network type");
            SelectionAdapter listener = new NetworkTypeListener();
            for (NetworkType networkType : NetworkType.values()) {
                b = new Button(group, 16);
                b.setText(networkType.text);
                b.addSelectionListener(listener);
                if (networkType != RPPAWizard.this.networkType) continue;
                b.setSelection(true);
            }
            group = new Group(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout(layout);
            group.setText("Select desired network centricity");
            listener = new CentricityListener();
            for (Enum enum_ : Centricity.values()) {
                b = new Button(group, 16);
                b.setText(((Centricity)enum_).text);
                b.addSelectionListener(listener);
                if (enum_ != RPPAWizard.this.centricity) continue;
                b.setSelection(true);
            }
            this.setControl(composite);
        }

        @Override
        public boolean isPageComplete() {
            return RPPAWizard.this.networkType != null && RPPAWizard.this.centricity != null;
        }

        class CentricityListener
        extends SelectionAdapter {
            CentricityListener() {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                RPPAWizard.this.centricity = Centricity.typeOf(b.getText());
                NetworkPage.this.setPageComplete(NetworkPage.this.isPageComplete());
            }
        }

        class NetworkTypeListener
        extends SelectionAdapter {
            NetworkTypeListener() {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                RPPAWizard.this.networkType = NetworkType.typeOf(b.getText());
                NetworkPage.this.setPageComplete(NetworkPage.this.isPageComplete());
            }
        }
    }

    class SingleValuePage
    extends PlatLoadPage {
        Combo valueCombo;
        Text thresholdText;
        Text valuesFileText;

        SingleValuePage() {
            this.setTitle("Values");
            this.setDescription("Identify the columns in values file.");
        }

        @Override
        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout(layout);
            Group group = new Group(composite, 0);
            group.setText("Select RPPA values file");
            group.setLayout(new RowLayout());
            this.valuesFileText = new Text(group, 2052);
            this.valuesFileText.setTextLimit(50);
            this.valuesFileText.setEditable(false);
            if (RPPAWizard.this.valuesFile != null) {
                this.valuesFileText.setText(RPPAWizard.this.valuesFile);
            }
            Button platButton = new Button(group, 8);
            platButton.setText("Browse");
            platButton.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    FileDialog dialog = new FileDialog(SingleValuePage.this.getShell(), 4096);
                    String file = dialog.open();
                    if (file != null) {
                        SingleValuePage.this.valuesFileText.setText(file);
                        RPPAWizard.this.valuesFile = file;
                        SingleValuePage.this.parseFile();
                    }
                }
            });
            PlatLoadPage.ComboListener listener = new PlatLoadPage.ComboListener();
            group = new Group(composite, 0);
            group.setText("Select \"ID\" column");
            group.setLayout(new RowLayout());
            this.idCombo = new Combo(group, 0);
            this.idCombo.addSelectionListener(listener);
            group = new Group(composite, 0);
            group.setText("Select \"value\" column");
            group.setLayout(new RowLayout());
            this.valueCombo = new Combo(group, 0);
            this.valueCombo.addSelectionListener(listener);
            group = new Group(composite, 0);
            group.setText("Enter a threshold value");
            group.setLayout(new RowLayout());
            this.thresholdText = new Text(group, 4);
            this.thresholdText.setText(RPPAWizard.this.threshold + "");
            this.thresholdText.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    SingleValuePage.this.readThreshold();
                    SingleValuePage.this.setPageComplete(SingleValuePage.this.isPageComplete());
                }
            });
            this.setControl(composite);
        }

        @Override
        protected void parseFile() {
            RPPAWizard.this.idColName = null;
            RPPAWizard.this.valueColName = null;
            this.header = RPPAFileReader.getHeader(RPPAWizard.this.valuesFile);
            if (this.header != null) {
                this.idCombo.setItems(this.header);
                this.valueCombo.setItems(this.header);
                int potentialID = RPPAFileReader.getPotentialIDColIndex(this.header);
                if (potentialID >= 0) {
                    this.idCombo.select(potentialID);
                }
                this.valueCombo.select(this.header.length - 1);
            }
            this.readFields();
            this.getShell().pack();
        }

        private void readThreshold() {
            try {
                String text = this.thresholdText.getText();
                RPPAWizard.this.threshold = Double.parseDouble(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        public boolean isPageComplete() {
            return RPPAWizard.this.valuesFile != null && RPPAWizard.this.vals0 != null && !RPPAWizard.this.vals0.isEmpty() && RPPAWizard.this.threshold > 0.0;
        }

        @Override
        protected void readFields() {
            String colName = this.getSelected(this.valueCombo);
            if (colName != null) {
                RPPAWizard.this.vals0 = new ArrayList<String>(1);
                RPPAWizard.this.vals0.add(colName);
            }
            RPPAWizard.this.idColName = this.getSelected(this.idCombo);
            this.readThreshold();
            this.setPageComplete(this.isPageComplete());
        }
    }

    class TwoGroupsPage
    extends WizardPage {
        org.eclipse.swt.widgets.List list1;
        org.eclipse.swt.widgets.List list2;
        List<String> allItems;
        Button add0;
        Button add1;
        Button remove0;
        Button remove1;
        Button toRight;
        Button toLeft;
        Text thresholdText;
        Group thrGroup;

        TwoGroupsPage() {
            super("two-groups");
            this.setTitle("Groups to compare");
            this.setDescription("Select two sets of groups to compare.");
        }

        @Override
        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout(layout);
            this.thrGroup = new Group(composite, 2048);
            this.thrGroup.setText("Enter t-test p-value threshold");
            RowLayout rowL = new RowLayout();
            this.thrGroup.setLayout(rowL);
            this.thresholdText = new Text(this.thrGroup, 4);
            this.thresholdText.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    TwoGroupsPage.this.readThreshold();
                    TwoGroupsPage.this.setPageComplete(TwoGroupsPage.this.isPageComplete());
                }
            });
            Composite listsGroup = new Composite(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            listsGroup.setLayout(layout);
            Group leftPanel = new Group(listsGroup, 0);
            leftPanel.setText("Control group");
            Group middlePanel = new Group(listsGroup, 0);
            Group rightPanel = new Group(listsGroup, 0);
            rightPanel.setText("Test group");
            layout = new GridLayout();
            layout.numColumns = 1;
            leftPanel.setLayout(layout);
            layout = new GridLayout();
            layout.numColumns = 1;
            middlePanel.setLayout(layout);
            layout = new GridLayout();
            layout.numColumns = 1;
            rightPanel.setLayout(layout);
            ButtonListener listener = new ButtonListener();
            layout = new GridLayout();
            layout.numColumns = 2;
            Composite comp = new Composite(leftPanel, 0);
            comp.setLayout(layout);
            this.add0 = new Button(comp, 8);
            this.add0.setText("Add");
            this.add0.addSelectionListener(listener);
            this.remove0 = new Button(comp, 8);
            this.remove0.setText("Remove");
            this.remove0.addSelectionListener(listener);
            layout = new GridLayout();
            layout.numColumns = 2;
            comp = new Composite(rightPanel, 0);
            comp.setLayout(layout);
            this.add1 = new Button(comp, 8);
            this.add1.setText("Add");
            this.add1.addSelectionListener(listener);
            this.remove1 = new Button(comp, 8);
            this.remove1.setText("Remove");
            this.remove1.addSelectionListener(listener);
            this.list1 = new org.eclipse.swt.widgets.List(leftPanel, 2562);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            this.list1.setLayoutData(data);
            this.list2 = new org.eclipse.swt.widgets.List(rightPanel, 2562);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            this.list2.setLayoutData(data);
            if (RPPAWizard.this.platFile != null) {
                this.initList();
            } else {
                RPPAWizard.this.vals0 = Collections.emptyList();
                RPPAWizard.this.vals1 = Collections.emptyList();
                this.initListWithDecoy();
            }
            this.toRight = new Button(middlePanel, 8);
            this.toRight.setText("-->");
            this.toRight.addSelectionListener(listener);
            this.toLeft = new Button(middlePanel, 8);
            this.toLeft.setText("<--");
            this.toLeft.addSelectionListener(listener);
            this.setControl(composite);
        }

        private void readThreshold() {
            try {
                String text = this.thresholdText.getText();
                RPPAWizard.this.threshold = Double.parseDouble(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void updateTexts() {
            if (RPPAWizard.this.comparisonType == ComparisonType.TTEST) {
                this.thrGroup.setText("Enter t-test p-value threshold");
            } else if (RPPAWizard.this.comparisonType == ComparisonType.LOG2_RATIO) {
                this.thrGroup.setText("Enter log-2-ratio threshold");
            }
        }

        protected void initList() {
            this.allItems = RPPAFileReader.getNamesOfNumberColumns(RPPAWizard.this.platFile);
            int midIndex = this.allItems.size() / 2;
            RPPAWizard.this.vals0 = new ArrayList<String>(this.allItems.subList(0, midIndex));
            RPPAWizard.this.vals1 = new ArrayList<String>(this.allItems.subList(midIndex, this.allItems.size()));
            this.updateListContents();
            this.updateTexts();
        }

        protected void initListWithDecoy() {
            for (int i = 0; i < 5; ++i) {
                this.list1.add("              ");
                this.list2.add("              ");
            }
        }

        protected void add(List<String> current) {
            List<String> addable = this.getAddable();
            ArrayList selected = new ArrayList();
            ItemSelectionDialog dialog = new ItemSelectionDialog(this.getShell(), 300, "Select items", "Add one or more items to the list", addable, selected, true, true, null);
            dialog.open();
            if (!dialog.isCancelled()) {
                current.addAll(selected);
                this.sort(current);
            }
        }

        protected void remove(List<String> current, org.eclipse.swt.widgets.List list) {
            String[] selection;
            for (String s : selection = list.getSelection()) {
                current.remove(s);
            }
        }

        protected void sort(List<String> toSort) {
            Collections.sort(toSort, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    Integer i1 = TwoGroupsPage.this.allItems.indexOf(o1);
                    Integer i2 = TwoGroupsPage.this.allItems.indexOf(o2);
                    return i1.compareTo(i2);
                }
            });
        }

        protected List<String> getAddable() {
            ArrayList<String> list = new ArrayList<String>(this.allItems);
            list.removeAll(RPPAWizard.this.vals0);
            list.removeAll(RPPAWizard.this.vals1);
            return list;
        }

        protected void transfer(List<String> fromList, List<String> toList, org.eclipse.swt.widgets.List from) {
            String[] selection;
            for (String s : selection = from.getSelection()) {
                fromList.remove(s);
                toList.add(s);
            }
            this.sort(toList);
        }

        protected void updateListContents() {
            this.list1.removeAll();
            for (String s : RPPAWizard.this.vals0) {
                this.list1.add(s);
            }
            this.list2.removeAll();
            for (String s : RPPAWizard.this.vals1) {
                this.list2.add(s);
            }
        }

        @Override
        public boolean isPageComplete() {
            return !RPPAWizard.this.vals0.isEmpty() && !RPPAWizard.this.vals1.isEmpty() && RPPAWizard.this.threshold > 0.0;
        }

        class ButtonListener
        extends SelectionAdapter {
            ButtonListener() {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                if (b == TwoGroupsPage.this.add0) {
                    TwoGroupsPage.this.add(RPPAWizard.this.vals0);
                } else if (b == TwoGroupsPage.this.add1) {
                    TwoGroupsPage.this.add(RPPAWizard.this.vals1);
                } else if (b == TwoGroupsPage.this.remove0) {
                    TwoGroupsPage.this.remove(RPPAWizard.this.vals0, TwoGroupsPage.this.list1);
                } else if (b == TwoGroupsPage.this.remove1) {
                    TwoGroupsPage.this.remove(RPPAWizard.this.vals1, TwoGroupsPage.this.list2);
                } else if (b == TwoGroupsPage.this.toRight) {
                    TwoGroupsPage.this.transfer(RPPAWizard.this.vals0, RPPAWizard.this.vals1, TwoGroupsPage.this.list1);
                } else if (b == TwoGroupsPage.this.toLeft) {
                    TwoGroupsPage.this.transfer(RPPAWizard.this.vals1, RPPAWizard.this.vals0, TwoGroupsPage.this.list2);
                }
                TwoGroupsPage.this.updateListContents();
                TwoGroupsPage.this.setPageComplete(TwoGroupsPage.this.isPageComplete());
            }
        }
    }

    class SingleFileSingleValueLoadPage
    extends PlatLoadPage {
        Combo valueCombo;
        Text thresholdText;

        SingleFileSingleValueLoadPage() {
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            Composite composite = (Composite)this.getControl();
            PlatLoadPage.ComboListener listener = new PlatLoadPage.ComboListener();
            Group group = new Group(composite, 0);
            group.setText("Select \"value\" column");
            group.setLayout(new RowLayout());
            this.valueCombo = new Combo(group, 0);
            this.valueCombo.addSelectionListener(listener);
            group = new Group(composite, 0);
            group.setText("Enter a threshold value");
            group.setLayout(new RowLayout());
            this.thresholdText = new Text(group, 4);
            this.thresholdText.setText(RPPAWizard.this.threshold + "");
            this.thresholdText.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent modifyEvent) {
                    SingleFileSingleValueLoadPage.this.readThreshold();
                    SingleFileSingleValueLoadPage.this.setPageComplete(SingleFileSingleValueLoadPage.this.isPageComplete());
                }
            });
        }

        @Override
        public boolean isPageComplete() {
            return super.isPageComplete() && RPPAWizard.this.vals0 != null && !RPPAWizard.this.vals0.isEmpty() && RPPAWizard.this.threshold > 0.0;
        }

        @Override
        protected void parseFile() {
            super.parseFile();
            if (this.header != null) {
                this.valueCombo.setItems(this.header);
                List<String> columns = RPPAFileReader.getNamesOfNumberColumns(RPPAWizard.this.platFile);
                if (columns != null && !columns.isEmpty()) {
                    this.valueCombo.select(Arrays.binarySearch(this.header, columns.get(0)));
                }
            }
            this.readFields();
            this.getShell().pack();
        }

        @Override
        protected void readFields() {
            String colName = this.getSelected(this.valueCombo);
            if (colName != null) {
                RPPAWizard.this.vals0 = new ArrayList<String>(1);
                RPPAWizard.this.vals0.add(colName);
            }
            this.readThreshold();
            super.readFields();
        }

        private void readThreshold() {
            try {
                String text = this.thresholdText.getText();
                RPPAWizard.this.threshold = Double.parseDouble(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class PlatLoadPage
    extends WizardPage {
        Text platFileText;
        Combo idCombo;
        Combo symbolCombo;
        Combo siteCombo;
        Combo effectCombo;
        String[] header;

        protected PlatLoadPage() {
            super("file-load");
            this.setTitle("Load file");
            this.setDescription("Select files and designate columns.");
        }

        @Override
        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout(layout);
            Group group = new Group(composite, 0);
            group.setText(RPPAWizard.this.formatType == FormatType.SINGLE_FILE ? "Select RPPA data file" : "Select RPPA annotation file");
            group.setLayout(new RowLayout());
            this.platFileText = new Text(group, 2052);
            this.platFileText.setTextLimit(50);
            this.platFileText.setEditable(false);
            if (RPPAWizard.this.platFile != null) {
                this.platFileText.setText(RPPAWizard.this.platFile);
            }
            Button platButton = new Button(group, 8);
            platButton.setText("Browse");
            platButton.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    FileDialog dialog = new FileDialog(PlatLoadPage.this.getShell(), 4096);
                    String file = dialog.open();
                    if (file != null) {
                        PlatLoadPage.this.platFileText.setText(file);
                        RPPAWizard.this.platFile = file;
                        PlatLoadPage.this.parseFile();
                    }
                }
            });
            ComboListener listener = new ComboListener();
            group = new Group(composite, 0);
            group.setText("Select \"ID\" column");
            group.setLayout(new RowLayout());
            this.idCombo = new Combo(group, 0);
            this.idCombo.addSelectionListener(listener);
            group = new Group(composite, 0);
            group.setText("Select \"symbol\" column");
            group.setLayout(new RowLayout());
            this.symbolCombo = new Combo(group, 0);
            this.symbolCombo.addSelectionListener(listener);
            group = new Group(composite, 0);
            group.setText("Select \"site\" column");
            group.setLayout(new RowLayout());
            this.siteCombo = new Combo(group, 0);
            this.siteCombo.addSelectionListener(listener);
            group = new Group(composite, 0);
            group.setText("Select \"effect\" column");
            group.setLayout(new RowLayout());
            this.effectCombo = new Combo(group, 0);
            this.effectCombo.addSelectionListener(listener);
            this.setControl(composite);
        }

        protected String getSelected(Combo combo) {
            int selectionIndex = combo.getSelectionIndex();
            if (selectionIndex >= 0) {
                return this.header[selectionIndex];
            }
            return null;
        }

        protected void readFields() {
            RPPAWizard.this.idColName = this.getSelected(this.idCombo);
            RPPAWizard.this.symbolColName = this.getSelected(this.symbolCombo);
            RPPAWizard.this.siteColName = this.getSelected(this.siteCombo);
            RPPAWizard.this.effectColName = this.getSelected(this.effectCombo);
            this.setPageComplete(this.isPageComplete());
        }

        protected void parseFile() {
            RPPAWizard.this.idColName = null;
            RPPAWizard.this.symbolColName = null;
            RPPAWizard.this.siteColName = null;
            RPPAWizard.this.effectColName = null;
            this.header = RPPAFileReader.getHeader(RPPAWizard.this.platFile);
            if (this.header != null) {
                int potEffect;
                int potSite;
                int potentialSym;
                this.idCombo.setItems(this.header);
                this.symbolCombo.setItems(this.header);
                this.siteCombo.setItems(this.header);
                this.effectCombo.setItems(this.header);
                int potentialID = RPPAFileReader.getPotentialIDColIndex(this.header);
                if (potentialID >= 0) {
                    this.idCombo.select(potentialID);
                }
                if ((potentialSym = RPPAFileReader.getPotentialSymbolColIndex(this.header)) >= 0) {
                    this.symbolCombo.select(potentialSym);
                }
                if ((potSite = RPPAFileReader.getPotentialSiteColIndex(this.header)) >= 0) {
                    this.siteCombo.select(potSite);
                }
                if ((potEffect = RPPAFileReader.getPotentialEffectColIndex(this.header)) >= 0) {
                    this.effectCombo.select(potEffect);
                }
            }
            this.readFields();
            this.getShell().pack();
        }

        @Override
        public boolean isPageComplete() {
            return RPPAWizard.this.platFile != null && RPPAWizard.this.idColName != null && RPPAWizard.this.symbolColName != null && RPPAWizard.this.siteColName != null;
        }

        class ComboListener
        extends SelectionAdapter {
            ComboListener() {
            }

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                PlatLoadPage.this.readFields();
            }
        }
    }

    class FormatSelectionPage
    extends WizardPage {
        List<Button> comparisonTypeButtons;
        List<Button> valueMetricButtons;

        protected FormatSelectionPage() {
            super("intro");
            this.setTitle("File format");
            this.setDescription("Select if the RPPA data is in a single or multiple files. Also state how to use the values.");
        }

        @Override
        public void createControl(Composite parent) {
            Button b;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = true;
            composite.setLayout(layout);
            Group group = new Group(composite, 0);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            group.setLayoutData(data);
            layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout(layout);
            group.setText("Select number of files");
            ButtonListener listener = new ButtonListener();
            for (FormatType formatType : FormatType.values()) {
                b = new Button(group, 16);
                b.setText(formatType.text);
                b.addSelectionListener(listener);
            }
            group = new Group(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout(layout);
            group.setText("Select amount of value columns");
            for (Enum enum_ : ValueAmount.values()) {
                b = new Button(group, 16);
                b.setText(((ValueAmount)enum_).text);
                b.addSelectionListener(listener);
            }
            this.valueMetricButtons = new ArrayList<Button>();
            group = new Group(composite, 0);
            group.setToolTipText("What we will find in the given data files?");
            layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout(layout);
            group.setText("Select the type of values");
            for (Enum enum_ : ValueMetric.values()) {
                b = new Button(group, 16);
                b.setText(((ValueMetric)enum_).text);
                b.addSelectionListener(listener);
                this.valueMetricButtons.add(b);
            }
            this.comparisonTypeButtons = new ArrayList<Button>();
            group = new Group(composite, 0);
            group.setToolTipText("How should we compare the two groups?");
            layout = new GridLayout();
            layout.numColumns = 1;
            group.setLayout(layout);
            group.setText("Select comparison method");
            for (Enum enum_ : ComparisonType.values()) {
                b = new Button(group, 16);
                b.setText(((ComparisonType)enum_).text);
                b.addSelectionListener(listener);
                this.comparisonTypeButtons.add(b);
                b.setEnabled(false);
            }
            this.setControl(composite);
        }

        @Override
        public boolean isPageComplete() {
            return RPPAWizard.this.formatType != null && RPPAWizard.this.valueAmount != null && RPPAWizard.this.valueMetric != null && (RPPAWizard.this.valueAmount != ValueAmount.TWO_GROUPS || RPPAWizard.this.comparisonType != null);
        }

        class ButtonListener
        extends SelectionAdapter {
            ButtonListener() {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                ComparisonType ct;
                ValueMetric valueMetric;
                ValueAmount va;
                Button b = (Button)e.getSource();
                FormatType ft = FormatType.typeOf(b.getText());
                if (ft != null) {
                    RPPAWizard.this.formatType = ft;
                    if (RPPAWizard.this.formatType == FormatType.MULTIPLE_FILES) {
                        for (Button button : FormatSelectionPage.this.valueMetricButtons) {
                            if (ValueMetric.typeOf(button.getText()) != ValueMetric.MEASUREMENT) continue;
                            if (button.getSelection()) {
                                button.setSelection(false);
                                RPPAWizard.this.valueMetric = null;
                            }
                            button.setEnabled(false);
                        }
                    } else {
                        for (Button button : FormatSelectionPage.this.valueMetricButtons) {
                            button.setEnabled(true);
                        }
                    }
                }
                if ((va = ValueAmount.typeOf(b.getText())) != null) {
                    RPPAWizard.this.valueAmount = va;
                    for (Button but : FormatSelectionPage.this.comparisonTypeButtons) {
                        but.setEnabled(RPPAWizard.this.valueAmount == ValueAmount.TWO_GROUPS);
                    }
                }
                if ((valueMetric = ValueMetric.typeOf(b.getText())) != null) {
                    RPPAWizard.this.valueMetric = valueMetric;
                }
                if ((ct = ComparisonType.typeOf(b.getText())) != null) {
                    RPPAWizard.this.comparisonType = ct;
                }
                FormatSelectionPage.this.setPageComplete(FormatSelectionPage.this.isPageComplete());
            }
        }
    }
}

