/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeModel;
import org.gvt.model.NodeModel;

public class EdgeIterator
implements Iterator {
    private int ledgeType;
    private HashSet<EdgeModel> ledges;
    private Iterator literator;
    private EdgeModel lnext;
    private boolean lisRecursive;
    private boolean lonlyEndsWithinRoot;
    private CompoundModel startingRoot;

    public EdgeIterator(CompoundModel root, int edgeType, boolean isRecursive, boolean onlyEndsWithinRoot) {
        this.startingRoot = root;
        this.ledgeType = edgeType;
        this.lisRecursive = isRecursive;
        this.lonlyEndsWithinRoot = onlyEndsWithinRoot;
        this.ledges = new HashSet();
        this.constructEdges(root);
        this.literator = this.ledges.iterator();
    }

    private void constructEdges(CompoundModel root) {
        for (NodeModel node : root.children) {
            this.ledges.addAll(node.sourceConnections);
            this.ledges.addAll(node.targetConnections);
            if (!(node instanceof CompoundModel) || !this.lisRecursive) continue;
            this.constructEdges((CompoundModel)node);
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.lnext != null;
    }

    public Object next() {
        return this.lnext;
    }

    private void findNext() {
        this.lnext = null;
        while (this.literator.hasNext()) {
            EdgeModel edge = (EdgeModel)this.literator.next();
            boolean isIntragraph = edge.isIntragraph();
            if (this.ledgeType == 0) {
                if (this.lonlyEndsWithinRoot) {
                    if (!this.startingRoot.isAncestorofNode(edge.getSource()) || !this.startingRoot.isAncestorofNode(edge.getTarget())) continue;
                    this.lnext = edge;
                    break;
                }
                this.lnext = edge;
                break;
            }
            if (this.ledgeType == 1) {
                if (!isIntragraph) continue;
                this.lnext = edge;
                break;
            }
            if (isIntragraph) continue;
            if (this.lonlyEndsWithinRoot) {
                if (!this.startingRoot.isAncestorofNode(edge.getSource()) || !this.startingRoot.isAncestorofNode(edge.getTarget())) continue;
                this.lnext = edge;
                break;
            }
            this.lnext = edge;
            break;
        }
    }

    @Override
    public void remove() {
    }

    public Set<EdgeModel> getEdges() {
        return this.ledges;
    }
}

