/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.Map;
import org.biopax.paxtools.model.level2.catalysis;
import org.biopax.paxtools.model.level2.control;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.BioPAXEdge;
import org.gvt.model.biopaxl2.Control;
import org.gvt.model.biopaxl2.Conversion;
import org.gvt.model.biopaxl2.Hub;
import org.gvt.model.biopaxl2.IBioPAXL2Node;
import org.gvt.util.ID;

public class EffectorSecondHalf
extends BioPAXEdge {
    control cont;
    protected int sign;

    public EffectorSecondHalf(NodeModel source, NodeModel target, control cont) {
        super(source, target);
        assert (source instanceof Control);
        assert (target instanceof Conversion || target instanceof Control || target instanceof Hub);
        this.cont = cont;
        int n = this.sign = Control.isActivation(cont) ? 1 : -1;
        this.setArrow(cont instanceof catalysis ? "Catalysis" : (cont.getCONTROL_TYPE() == null ? "Modulation" : (this.isPositive() ? "Stimulation" : "Inhibition")));
        this.setColor(this.isPositive() ? Control.EDGE_COLOR_ACTIVATE : Control.EDGE_COLOR_INHIBIT);
    }

    public EffectorSecondHalf(EffectorSecondHalf excised, Map<NodeModel, NodeModel> map) {
        super(excised, map);
        this.cont = excised.getControl();
        this.sign = excised.getSign();
    }

    @Override
    public int getSign() {
        return this.sign;
    }

    public control getControl() {
        return this.cont;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.cont) + ((IBioPAXL2Node)this.getTargetNode()).getIDHash();
    }
}

