/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.level2.evidence;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.physicalInteraction;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.Actor;
import org.gvt.model.biopaxl2.BioPAXNode;
import org.gvt.model.biopaxl2.Complex;
import org.gvt.model.biopaxl2.PEPBasedEdge;
import org.gvt.util.ID;

public class Pairing
extends PEPBasedEdge {
    interaction inter;
    private static final Color COLOR = new Color(null, 100, 100, 100);

    public Pairing(interaction inter, physicalEntityParticipant first, NodeModel pair1, NodeModel pair2) {
        super(pair1, pair2, first);
        assert (pair1 instanceof Actor || pair1 instanceof Complex);
        assert (pair2 instanceof Actor || pair2 instanceof Complex);
        this.inter = inter;
        this.setColor(COLOR);
    }

    public Pairing(Pairing excised, Map<NodeModel, NodeModel> map) {
        super(excised, map);
        this.inter = excised.getInteraction();
    }

    public interaction getInteraction() {
        return this.inter;
    }

    @Override
    public int getSign() {
        return 0;
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public String getIDHash() {
        return super.getIDHash() + ID.get(this.inter);
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        BioPAXNode.addNamesAndTypeAndID(list, this.inter);
        for (evidence ev : this.inter.getEVIDENCE()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        if (this.inter instanceof physicalInteraction && !((physicalInteraction)this.inter).getINTERACTION_TYPE().isEmpty()) {
            String s = BioPAXNode.formatInString(((physicalInteraction)this.inter).getINTERACTION_TYPE());
            list.add(new String[]{"Interaction Type", s});
        }
        BioPAXNode.addDataSourceAndXrefAndComments(list, this.inter);
        return list;
    }
}

