/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.GeneticProfile;
import org.cbio.causality.idmapping.HGNC;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.ChisioMain;
import org.gvt.command.CreateCommand;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXCompoundNode;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.model.biopaxl3.ChbControl;
import org.gvt.model.biopaxl3.Compartment;
import org.gvt.model.biopaxl3.EffectorSecondHalf;
import org.gvt.model.biopaxl3.IBioPAXL3Node;
import org.gvt.model.biopaxl3.NodeUtil;
import org.gvt.model.biopaxl3.NonModulatedEffector;
import org.gvt.util.EntityHolder;
import org.gvt.util.ID;
import org.gvt.util.NodeProvider;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.ExperimentData;
import org.patika.mada.util.Representable;
import org.patika.mada.util.XRef;

public abstract class BioPAXNode
extends NodeModel
implements IBioPAXL3Node {
    private int id;
    private List<XRef> references;
    private List<XRef> secondaryReferences;
    protected NodeUtil util;
    public static final String NAME_REF = "Name";
    public static final int PROPERTY_CHAR_LIMIT = 5000;
    public static final int MAX_INITIAL_WIDTH = 100;

    public BioPAXNode(CompoundModel root) {
        CreateCommand command = new CreateCommand(root, this);
        command.execute();
        this.references = new ArrayList<XRef>();
        this.secondaryReferences = new ArrayList<XRef>();
        this.util = new NodeUtil(this);
    }

    public BioPAXNode(BioPAXNode excised, CompoundModel root) {
        this(root);
        this.id = excised.id;
        this.references.addAll(excised.getReferences());
        this.setShape(excised.getShape());
        this.setSize(excised.getSize());
        this.setColor(excised.getColor());
        this.setText(excised.getText());
        this.setTextColor(excised.getTextColor());
        this.setTooltipText(excised.getTooltipText());
        for (Object key : excised.getAllLabels()) {
            this.putLabel(key, excised.getLabel(key));
        }
        this.getGraph().putInExcisionMap(excised, this);
        this.putLabel("EXCISED_FROM", excised);
    }

    @Override
    public boolean isComplexMember() {
        return false;
    }

    @Override
    public void configFromModel() {
    }

    @Override
    public BioPAXL3Graph getGraph() {
        return this.util.getGraph();
    }

    public Compartment getCompartment() {
        return this.util.getCompartment();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.getText();
    }

    public NodeUtil getUtil() {
        return this.util;
    }

    @Override
    public List<XRef> getReferences() {
        return this.references;
    }

    public void addReference(XRef ref) {
        if (!this.references.contains(ref)) {
            this.references.add(ref);
        }
    }

    @Override
    public List<XRef> getSecondaryReferences() {
        return this.secondaryReferences;
    }

    public void addSecondaryReference(XRef ref) {
        if (!this.secondaryReferences.contains(ref)) {
            this.secondaryReferences.add(ref);
        }
    }

    protected String extractReferences(Named ent) {
        SimplePhysicalEntity spe;
        EntityReference er;
        ArrayList<String> list = new ArrayList<String>();
        if (ent.getStandardName() != null && ent.getStandardName().length() > 0) {
            this.addReference(new XRef(NAME_REF, ent.getStandardName()));
            if (!list.contains(ent.getStandardName())) {
                list.add(ent.getStandardName());
            }
        }
        for (String nm : ent.getName()) {
            this.addReference(new XRef(NAME_REF, nm));
            if (list.contains(nm)) continue;
            list.add(nm);
        }
        for (Xref xr : ent.getXref()) {
            if (xr == null) continue;
            this.addReference(new XRef(xr));
        }
        if (ent instanceof SimplePhysicalEntity && (er = (spe = (SimplePhysicalEntity)ent).getEntityReference()) != null) {
            for (Xref xr : er.getXref()) {
                this.addSecondaryReference(new XRef(xr));
            }
            for (String name : er.getName()) {
                this.addSecondaryReference(new XRef(NAME_REF, name));
            }
        }
        String names = "";
        if (!list.isEmpty()) {
            names = (String)list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                names = names + "\n" + (String)list.get(i);
            }
        }
        return names;
    }

    protected int suggestInitialWidth() {
        Dimension dim = TextUtilities.INSTANCE.getStringExtents(this.getText(), this.getTextFont());
        int width = Math.min(dim.width + 4, 100);
        return width;
    }

    public String getShortestNameRef() {
        int shortest = Integer.MAX_VALUE;
        String name = null;
        for (XRef ref : this.references) {
            String value;
            if (!ref.getDb().equals(NAME_REF) || (value = ref.getRef()).length() >= shortest) continue;
            name = value;
            shortest = value.length();
        }
        return name;
    }

    public static String getDisplayName(Named ent) {
        EntityReference er;
        String txt = null;
        if (ent instanceof SmallMolecule && (txt = ent.getDisplayName()) == null && (er = ((SmallMolecule)ent).getEntityReference()) != null && er.getDisplayName() != null) {
            txt = er.getDisplayName();
        }
        if (txt == null) {
            txt = BioPAXNode.extractGeneSymbol(ent);
        }
        if (txt == null) {
            txt = ent.getDisplayName();
        }
        if (txt == null) {
            for (String name : ent.getName()) {
                if (txt != null && (name == null || name.length() >= txt.length())) continue;
                txt = name;
            }
            if (ent.getStandardName() != null && (txt == null || txt.length() > ent.getStandardName().length())) {
                txt = ent.getStandardName();
            }
        }
        return txt;
    }

    public static String extractGeneSymbol(EntityHolder holder) {
        String s = null;
        if (holder.l3er != null) {
            s = BioPAXNode.extractGeneSymbol(holder.l3er);
        }
        if (s == null && holder.l3pe != null) {
            BioPAXNode.extractGeneSymbol(holder.l3pe);
        }
        return s;
    }

    public static String extractGeneSymbol(BioPAXElement ent) {
        HashSet<String> syms = new HashSet<String>();
        if (ent instanceof XReferrable) {
            String sym;
            HashSet<Xref> set = new HashSet<Xref>(((XReferrable)ent).getXref());
            if (ent instanceof SimplePhysicalEntity && ((SimplePhysicalEntity)ent).getEntityReference() != null) {
                set.addAll(((SimplePhysicalEntity)ent).getEntityReference().getXref());
            }
            for (Xref xref2 : set) {
                String id;
                if (xref2.getDb() == null || !xref2.getDb().toLowerCase().startsWith("hgnc") || (id = xref2.getId()) == null || (sym = HGNC.getSymbol(id)) == null) continue;
                syms.add(sym);
            }
            if (syms.isEmpty()) {
                for (Xref ref : set) {
                    String db = ref.getDb();
                    if (db == null || !db.equalsIgnoreCase("GENE_SYMBOL") && !db.equalsIgnoreCase("GENESYMBOL") && !db.equalsIgnoreCase("GENE SYMBOL") && !db.equalsIgnoreCase("HGNC SYMBOL") && !db.equalsIgnoreCase("GENE-SYMBOL") && !db.equalsIgnoreCase("SYMBOL")) continue;
                    sym = ref.getId();
                    syms.add(sym);
                }
            }
        }
        if (syms.size() == 1) {
            return (String)syms.iterator().next();
        }
        return null;
    }

    @Override
    public boolean fetchLocation(String pathwayRDFID) {
        return this.util.fetchLocation(pathwayRDFID);
    }

    @Override
    public void recordLocation() {
        this.util.recordLocation();
    }

    @Override
    public void eraseLocation() {
        this.util.eraseLocation();
    }

    @Override
    public String getIDHash() {
        return this.util.getIDHash();
    }

    @Override
    public boolean hasModelTag(String tag) {
        return this.util.hasModelTag(tag);
    }

    @Override
    public String fetchModelTag(String tag) {
        return this.util.fetchModelTag(tag);
    }

    @Override
    public Representable getRepresentableData(Object key) {
        return (Representable)this.getLabel(key);
    }

    @Override
    public ExperimentData getExperimentData(String type) {
        return (ExperimentData)this.getLabel(type);
    }

    @Override
    public void setExperimentData(ExperimentData data) {
        this.putLabel(data.getKey(), data);
    }

    @Override
    public boolean hasExperimentData(Object key) {
        return this.hasLabel(key);
    }

    @Override
    public boolean hasSignificantExperimentalChange(String type) {
        return this.hasExperimentData(type) && this.getExperimentData(type).isSignificant();
    }

    @Override
    public int getExperimentDataSign(String type) {
        return this.getExperimentData(type).getSign();
    }

    @Override
    public Collection<? extends Node> getParents() {
        CompoundModel p = this.getParentModel();
        ArrayList<BioPAXCompoundNode> col = new ArrayList<BioPAXCompoundNode>(1);
        if (p == null || p.isRoot()) {
            return col;
        }
        col.add((BioPAXCompoundNode)p);
        return col;
    }

    @Override
    public Collection<? extends Edge> getUpstream() {
        return this.getTargetConnections();
    }

    @Override
    public Collection<? extends Edge> getDownstream() {
        return this.getSourceConnections();
    }

    @Override
    public Collection<? extends Node> getChildren() {
        return new ArrayList(0);
    }

    @Override
    public boolean sameEntity(Node n) {
        return n.equals(this);
    }

    @Override
    public boolean isBreadthNode() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlight();
    }

    @Override
    public boolean isTranscriptionEvent() {
        return false;
    }

    @Override
    public Set<Node> getTabuNodes() {
        return Collections.emptySet();
    }

    @Override
    public Set<GraphObject> getRequisites() {
        HashSet<GraphObject> reqs = new HashSet<GraphObject>();
        if (this.getParentModel() instanceof Compartment) {
            reqs.add((GraphObject)((Object)this.getParentModel()));
        }
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        return list;
    }

    public Color getStringSpecificColor(String name) {
        int[] c;
        int id = Math.abs(name.hashCode());
        int number1 = Math.abs((name + name).hashCode() * 97) % 1000;
        int number2 = Math.abs((name + name).hashCode() * 59) % 1000;
        int t = 350;
        c = new int[]{number1 % Math.min(255, t), number2 % Math.min(255, t - c[0]), Math.min(254, t - c[0] - c[1])};
        int p = 255;
        int r = c[0] + id % (p - c[0]);
        int g = c[1] + id % p * 97 % (p - c[1]);
        int b = c[2] + id % p * 59 % (p - c[2]);
        return new Color(null, r, g, b);
    }

    public static String formatInString(Set<? extends ControlledVocabulary> set) {
        String s = "";
        for (ControlledVocabulary controlledVocabulary : set) {
            if (s.length() > 0) {
                s = s + ", ";
            }
            s = s + controlledVocabulary;
        }
        return s;
    }

    public static String classNameToString(String clsName) {
        clsName = clsName.substring(clsName.lastIndexOf(".") + 1, clsName.lastIndexOf("I"));
        clsName = clsName.substring(0, 1).toUpperCase() + clsName.substring(1);
        for (int i = 3; i < clsName.length(); ++i) {
            if (!Character.isLowerCase(clsName.charAt(i - 1)) || !Character.isUpperCase(clsName.charAt(i))) continue;
            clsName = clsName.substring(0, i) + " " + clsName.substring(i);
        }
        return clsName;
    }

    public static void addNamesAndTypeAndID(List<String[]> list, Named ent) {
        assert (ent != null);
        String type = BioPAXNode.classNameToString(ent.getClass().getName());
        list.add(new String[]{"Type", type});
        String s = ent.getDisplayName();
        if (s != null && s.length() > 0) {
            list.add(new String[]{"Disp. Name", s});
        }
        if ((s = ent.getStandardName()) != null && s.length() > 0) {
            list.add(new String[]{"St. Name", s});
        }
        for (String synon : ent.getName()) {
            if (synon == null || synon.length() <= 0) continue;
            list.add(new String[]{NAME_REF, synon});
        }
        list.add(new String[]{"ID", ID.get(ent)});
    }

    public static void addDataSourceAndXrefAndComments(List<String[]> list, Named ent) {
        BioSource src;
        EntityReference er;
        if (ent instanceof Entity) {
            for (Provenance ds : ((Entity)ent).getDataSource()) {
                if (ds.getName().isEmpty()) continue;
                list.add(new String[]{"Data Source", ds.toString()});
            }
        }
        for (Xref xr : ent.getXref()) {
            list.add(new String[]{"Reference", xr.toString()});
        }
        if (ent instanceof SimplePhysicalEntity && (er = ((SimplePhysicalEntity)ent).getEntityReference()) instanceof SequenceEntityReference && (src = ((SequenceEntityReference)er).getOrganism()) != null) {
            list.add(new String[]{"Organism", src.toString()});
        }
        for (String comment : ent.getComment()) {
            if (comment.contains("@Layout")) continue;
            boolean first = true;
            while (comment.length() > 5000) {
                int cutIndex = comment.lastIndexOf(" ", 5000);
                if (cutIndex < 0) {
                    cutIndex = 5000;
                }
                String c = comment.substring(0, cutIndex);
                comment = comment.substring(cutIndex).trim();
                String prop = first ? "Comment" : "";
                list.add(new String[]{prop, c});
                first = false;
            }
            if (comment.trim().length() <= 0) continue;
            String prop = first ? "Comment" : "";
            list.add(new String[]{prop, comment.trim()});
        }
    }

    protected void createControlOverInteraction(CompoundModel root, Interaction inter, NodeProvider prov) {
        for (Control con : inter.getControlledOf()) {
            if (!prov.needsToBeDisplayed(ID.get(con))) continue;
            if (ChbControl.controlNeedsToBeANode(con, prov)) {
                ChbControl ctrl = (ChbControl)prov.getNode(ID.get(con), root);
                new EffectorSecondHalf(ctrl, this, con);
                continue;
            }
            for (Controller ctrlr : con.getController()) {
                NodeModel source = prov.getNode(ID.get(ctrlr), root);
                if (source == null) continue;
                new NonModulatedEffector(source, this, con, inter);
            }
        }
    }

    public List<String[]> getCBioDataInspectable(ChisioMain main) {
        CBioPortalAccessor portalAccessor;
        ArrayList<String[]> list = new ArrayList<String[]>();
        String geneName = null;
        if (this instanceof EntityAssociated) {
            EntityHolder ent = ((EntityAssociated)((Object)this)).getEntity();
            if (ent.l3er != null) {
                Object xr;
                Iterator<Xref> iterator = ent.l3er.getXref().iterator();
                while (!(!iterator.hasNext() || (xr = iterator.next()) instanceof RelationshipXref && xr.getDb() != null && xr.getDb().toLowerCase().startsWith("hgnc") && (geneName = HGNC.getSymbol(xr.getId())) != null)) {
                }
            }
        }
        if (geneName == null) {
            geneName = HGNC.getSymbol(this.getText());
        }
        if ((portalAccessor = ChisioMain.cBioPortalAccessor) != null && !portalAccessor.getCurrentGeneticProfiles().isEmpty() && geneName != null) {
            list.add(new String[]{"Cancer study", portalAccessor.getCurrentCancerStudy().getName()});
            String profilesStr = "";
            for (GeneticProfile geneticProfile : portalAccessor.getCurrentGeneticProfiles()) {
                profilesStr = profilesStr + geneticProfile.getName() + "; ";
            }
            profilesStr = profilesStr.substring(0, profilesStr.length() - 2);
            list.add(new String[]{"Data profiles", profilesStr});
            list.add(new String[]{"Case set", portalAccessor.getCurrentCaseList().getDescription()});
            AlterationPack alterations = portalAccessor.getAlterations(geneName);
            int sampleSize = alterations.get(Alteration.ANY).length;
            list.add(new String[]{"Number of samples", sampleSize + ""});
            for (Alteration alt : Alteration.values()) {
                Change[] changes;
                if (alt.isSummary() && alt != Alteration.ANY || (changes = alterations.get(alt)) == null) continue;
                int noData = 0;
                int noChange = 0;
                int stayInactive = 0;
                int unknownChange = 0;
                int inhibiting = 0;
                int activating = 0;
                List<Integer> expIndices = main.getExperimentDataManager("cBio Portal Alteration Data").getFirstExpIndices();
                int i = 0;
                block11: for (Change change : changes) {
                    if (!expIndices.contains(i++)) continue;
                    switch (change) {
                        case INHIBITING: {
                            ++inhibiting;
                            continue block11;
                        }
                        case ACTIVATING: {
                            ++activating;
                            continue block11;
                        }
                        case UNKNOWN_CHANGE: {
                            ++unknownChange;
                            continue block11;
                        }
                        case NO_CHANGE: {
                            ++noChange;
                            continue block11;
                        }
                        case NO_DATA: {
                            ++noData;
                            continue block11;
                        }
                        case STAY_INACTIVE: {
                            ++stayInactive;
                        }
                    }
                }
                int totalChange = inhibiting + activating + unknownChange;
                if (totalChange == 0) continue;
                NumberFormat n = NumberFormat.getPercentInstance();
                n.setMaximumFractionDigits(1);
                list.add(new String[]{alt.getName() + " freq", n.format((double)totalChange / (double)sampleSize)});
                if (activating > 0) {
                    list.add(new String[]{" - Activating", activating + ""});
                }
                if (inhibiting > 0) {
                    list.add(new String[]{" - Inhibiting", inhibiting + ""});
                }
                if (unknownChange > 0) {
                    list.add(new String[]{" - Unknown change", unknownChange + ""});
                }
                if (noData <= 0) continue;
                list.add(new String[]{" - No data", noData + ""});
            }
        }
        return list;
    }
}

