/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.Compartment;
import org.gvt.model.biopaxl3.ComplexMember;
import org.gvt.model.biopaxl3.Product;
import org.gvt.model.biopaxl3.Substrate;
import org.gvt.model.biopaxl3.Template;
import org.gvt.util.ID;
import org.gvt.util.NodeProvider;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.Ranker;

public class ChbTempReac
extends BioPAXNode {
    private TemplateReaction tr;
    private Set<Node> tabu;
    private static final Color COLOR = new Color(null, 230, 230, 230);

    public ChbTempReac(CompoundModel root) {
        super(root);
        this.setColor(COLOR);
        this.setText("t");
        this.setSize(new Dimension(8, 12));
        this.setShape("Rectangle");
    }

    public ChbTempReac(CompoundModel root, TemplateReaction tr, NodeProvider prov) {
        this(root);
        this.tr = tr;
        this.configFromModel();
        this.buildConnections(root, tr, prov);
    }

    public ChbTempReac(ChbTempReac excised, CompoundModel root) {
        super(excised, root);
        this.tr = excised.getTemplateReaction();
        this.configFromModel();
    }

    @Override
    public void configFromModel() {
        this.extractReferences(this.tr);
        this.setTooltipText(this.tr.getDisplayName());
    }

    public TemplateReaction getTemplateReaction() {
        return this.tr;
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return Arrays.asList(this.tr);
    }

    private void buildConnections(CompoundModel root, TemplateReaction tr, NodeProvider prov) {
        NucleicAcid template = tr.getTemplate();
        if (template != null) {
            NodeModel tmp = prov.getNode(ID.get(template), root);
            new Template(tmp, this);
        }
        for (PhysicalEntity ent : tr.getProduct()) {
            NodeModel prd = prov.getNode(ID.get(ent), root);
            new Product(this, prd);
        }
        this.createControlOverInteraction(root, tr, prov);
    }

    private NodeModel mapLookup(PhysicalEntity pe, TemplateReaction tr, Map<String, NodeModel> map) {
        NodeModel nm = map.get(ID.get(pe));
        if (nm == null) {
            nm = map.get(ID.get(pe) + ID.get(tr));
        }
        return nm;
    }

    public static String getPossibleCompartmentName(TemplateReaction tr) {
        HashSet<String> names = new HashSet<String>();
        if (tr.getTemplate() != null) {
            ChbTempReac.getCompartmentName(names, tr.getTemplate());
        }
        for (PhysicalEntity ent : tr.getProduct()) {
            ChbTempReac.getCompartmentName(names, ent);
        }
        if (names.size() == 1) {
            return (String)names.iterator().next();
        }
        return null;
    }

    private static void getCompartmentName(Set<String> names, PhysicalEntity ent) {
        if (ent.getCellularLocation() != null && !ent.getCellularLocation().getTerm().isEmpty()) {
            names.add(ent.getCellularLocation().getTerm().iterator().next());
        }
    }

    public static List<String> getPossibleCompartmentNames(Conversion conv) {
        ArrayList<String> names = new ArrayList<String>();
        for (PhysicalEntity ent : conv.getLeft()) {
            if (ent.getCellularLocation() == null) continue;
            names.add(ent.getCellularLocation().getTerm().iterator().next());
        }
        for (PhysicalEntity ent : conv.getRight()) {
            if (ent.getCellularLocation() == null) continue;
            names.add(ent.getCellularLocation().getTerm().iterator().next());
        }
        return names;
    }

    public void selectBestCompartment() {
        CompoundModel comp;
        List<NodeModel> neighbors = this.getNeighborsList();
        Ranker<CompoundModel> r = new Ranker<CompoundModel>();
        for (NodeModel neigh : neighbors) {
            CompoundModel cm;
            if (neigh instanceof ComplexMember) {
                neigh = neigh.getParentModel();
            }
            if ((cm = neigh.getParentModel()) == null) continue;
            r.count(cm);
        }
        List list = r.getRankedList();
        if (list.isEmpty()) {
            return;
        }
        List firstGroup = list.get(0);
        if (firstGroup.size() == 1) {
            comp = (CompoundModel)firstGroup.get(0);
        } else {
            for (NodeModel neigh : neighbors) {
                CompoundModel cm;
                if (neigh instanceof ComplexMember) {
                    neigh = neigh.getParentModel();
                }
                if ((cm = neigh.getParentModel()) != null) {
                    cm = cm.getParentModel();
                }
                if (cm == null) continue;
                r.count(cm);
            }
            list = r.getRankedList();
            List secondGroup = list.get(0);
            assert (!secondGroup.isEmpty());
            if (secondGroup.size() == 1) {
                comp = (CompoundModel)secondGroup.get(0);
            } else {
                ArrayList copySec = new ArrayList(secondGroup);
                copySec.retainAll(firstGroup);
                if (!copySec.isEmpty()) {
                    secondGroup = copySec;
                }
                if (!((comp = (CompoundModel)secondGroup.get(0)) instanceof Compartment) && secondGroup.size() > 1) {
                    comp = (CompoundModel)secondGroup.get(1);
                }
            }
        }
        this.getParentModel().removeChild(this);
        comp.addChild(this);
        this.setParentModel(comp);
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    @Override
    public boolean isTranscriptionEvent() {
        return true;
    }

    @Override
    public Set<Node> getTabuNodes() {
        if (this.tabu == null) {
            this.tabu = new HashSet<Node>();
            for (Edge edge : this.getUpstream()) {
                if (!(edge instanceof Substrate)) continue;
                this.tabu.add(edge.getSourceNode());
            }
        }
        return new HashSet<Node>(this.tabu);
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getSourceConnections());
        reqs.addAll(this.getTargetConnections());
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        ChbTempReac.addNamesAndTypeAndID(list, this.tr);
        for (Evidence ev : this.tr.getEvidence()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        if (!this.tr.getInteractionType().isEmpty()) {
            String s = ChbTempReac.formatInString(this.tr.getInteractionType());
            list.add(new String[]{"Interaction Type", s});
        }
        ChbTempReac.addDataSourceAndXrefAndComments(list, this.tr);
        return list;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.tr);
    }
}

