/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.Map;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.Control;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXEdge;
import org.gvt.model.biopaxl3.ChbControl;
import org.gvt.model.biopaxl3.ChbConversion;
import org.gvt.model.biopaxl3.ChbPathway;
import org.gvt.model.biopaxl3.ChbTempReac;
import org.gvt.model.biopaxl3.Hub;
import org.gvt.model.biopaxl3.IBioPAXL3Node;
import org.gvt.util.ID;

public class EffectorSecondHalf
extends BioPAXEdge {
    Control cont;
    protected int sign;

    public EffectorSecondHalf(NodeModel source, NodeModel target, Control cont) {
        super(source, target);
        assert (source instanceof ChbControl);
        assert (target instanceof ChbConversion || target instanceof ChbControl || target instanceof Hub || target instanceof ChbTempReac || target instanceof ChbPathway);
        this.cont = cont;
        int n = this.sign = ChbControl.isActivation(cont) ? 1 : -1;
        this.setArrow(cont instanceof Catalysis ? "Catalysis" : (cont.getControlType() == null ? "Modulation" : (this.isPositive() ? "Stimulation" : "Inhibition")));
        this.setColor(this.isPositive() ? ChbControl.EDGE_COLOR_ACTIVATE : ChbControl.EDGE_COLOR_INHIBIT);
    }

    public EffectorSecondHalf(EffectorSecondHalf excised, Map<NodeModel, NodeModel> map) {
        super(excised, map);
        this.cont = excised.getControl();
        this.sign = excised.getSign();
    }

    @Override
    public int getSign() {
        return this.sign;
    }

    public Control getControl() {
        return this.cont;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.cont) + ((IBioPAXL3Node)this.getTargetNode()).getIDHash();
    }
}

