/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.MultiTouch;
import org.gvt.util.ID;
import org.gvt.util.NodeProvider;
import org.patika.mada.graph.GraphObject;

public class Hub
extends BioPAXNode {
    private Interaction inter;
    private static final Color COLOR = new Color(null, 100, 100, 100);

    public Hub(CompoundModel root) {
        super(root);
        this.setShape("Ellipse");
        this.setColor(COLOR);
        this.setText("");
        this.setSize(new Dimension(9, 9));
    }

    public Hub(CompoundModel root, Interaction inter, NodeProvider prov) {
        this(root);
        this.inter = inter;
        this.setTooltipText(inter.getStandardName());
        this.extractReferences(inter);
        this.buildConnections(root, prov);
    }

    public Hub(Hub excised, CompoundModel root) {
        super(excised, root);
        this.inter = excised.getInteraction();
    }

    public Interaction getInteraction() {
        return this.inter;
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return Arrays.asList(this.inter);
    }

    private void buildConnections(CompoundModel root, NodeProvider prov) {
        for (Entity ent : this.inter.getParticipant()) {
            NodeModel node = prov.getNode(ID.get(ent), root);
            if (node == null) continue;
            new MultiTouch(node, this);
        }
        this.createControlOverInteraction(root, this.inter, prov);
    }

    public static String getPossibleCompartmentName(Interaction inter) {
        HashSet<String> names = new HashSet<String>();
        for (Entity ent : inter.getParticipant()) {
            Iterator<String> iterator;
            PhysicalEntity pe;
            if (!(ent instanceof PhysicalEntity) || (pe = (PhysicalEntity)ent).getCellularLocation() == null || !(iterator = pe.getCellularLocation().getTerm().iterator()).hasNext()) continue;
            String loc = iterator.next();
            names.add(loc);
        }
        if (names.size() == 1) {
            return (String)names.iterator().next();
        }
        return null;
    }

    public static boolean needsToRepresentedWithANode(MolecularInteraction mi, NodeProvider prov) {
        for (Control control2 : mi.getControlledOf()) {
            if (!prov.needsToBeDisplayed(ID.get(control2))) continue;
            return true;
        }
        int cnt = 0;
        for (Entity entity2 : mi.getParticipant()) {
            if (!prov.needsToBeDisplayed(ID.get(entity2))) continue;
            ++cnt;
        }
        return cnt != 2;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getSourceConnections());
        reqs.addAll(this.getTargetConnections());
        return reqs;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.inter);
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        Hub.addNamesAndTypeAndID(list, this.inter);
        for (Evidence ev : this.inter.getEvidence()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        Hub.addDataSourceAndXrefAndComments(list, this.inter);
        return list;
    }
}

