/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.custom;

import java.util.Map;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.gvt.command.CreateCommand;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.custom.CustomGraph;

public class CustomNode
extends NodeModel
implements Cloneable {
    boolean duplicate;
    public static final String HIGHLIGHT = "highlight";
    public static final String HIGHLIGHT_COLOR = "highlightcolor";

    public CustomNode(CompoundModel root, Map<String, String> map) {
        CreateCommand command = new CreateCommand(root, this);
        command.execute();
        if (map.containsKey("TEXT")) {
            this.setText(map.get("TEXT"));
        } else {
            this.setText("node");
        }
        if (map.containsKey("TOOLTIP")) {
            this.setTooltipText(map.get("TOOLTIP"));
        }
        if (map.containsKey("BGCOLOR")) {
            this.setColor(CustomGraph.textToColor(map.get("BGCOLOR")));
        } else {
            this.setColor(CustomGraph.COLOR_WHITE);
        }
        if (map.containsKey("BORDERCOLOR")) {
            this.setBorderColor(CustomGraph.textToColor(map.get("BORDERCOLOR")));
        } else {
            this.setBorderColor(CustomGraph.COLOR_BLACK);
        }
        if (map.containsKey("TEXTCOLOR")) {
            this.setTextColor(CustomGraph.textToColor(map.get("TEXTCOLOR")));
        }
        int width = map.containsKey("WIDTH") ? Integer.parseInt(map.get("WIDTH")) : this.suggestWidth();
        int height = map.containsKey("HEIGHT") ? Integer.parseInt(map.get("HEIGHT")) : 20;
        this.setSize(new Dimension(width, height));
        if (map.containsKey("SHAPE")) {
            this.setShape(map.get("SHAPE"));
        } else {
            this.setShape("RoundRect");
        }
        if (map.containsKey(HIGHLIGHT)) {
            this.setHighlight(map.get(HIGHLIGHT).equals("on"));
        }
        if (map.containsKey(HIGHLIGHT_COLOR)) {
            this.setHighlightColor(CustomGraph.textToColor(map.get(HIGHLIGHT_COLOR)));
        }
    }

    public CustomNode(CompoundModel root, CustomNode copyFrom) {
        CreateCommand command = new CreateCommand(root, this);
        command.execute();
        this.setText(copyFrom.getText());
        this.setTooltipText(copyFrom.getTooltipText());
        this.setColor(copyFrom.getColor());
        this.setBorderColor(copyFrom.getBorderColor());
        this.setTextColor(copyFrom.getTextColor());
        this.setSize(copyFrom.getSize());
        this.setShape(copyFrom.getShape());
    }

    protected int suggestWidth() {
        Dimension dim = TextUtilities.INSTANCE.getStringExtents(this.getText(), this.getTextFont());
        return Math.max(Math.min(dim.width + 4, 100), 20);
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }
}

