/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Direction;
import org.biopax.paxtools.model.level2.InteractionParticipant;
import org.biopax.paxtools.model.level2.SpontaneousType;
import org.biopax.paxtools.model.level2.catalysis;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.smallMolecule;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.Actor;
import org.gvt.model.biopaxl2.BioPAXL2Graph;
import org.gvt.model.biopaxl2.Compartment;
import org.gvt.model.biopaxl2.Complex;
import org.gvt.model.biopaxl2.ComplexMember;
import org.gvt.model.biopaxl2.Conversion;
import org.gvt.model.biopaxl2.Hub;
import org.gvt.model.biopaxl2.MultiTouch;
import org.gvt.model.biopaxl2.Pairing;
import org.gvt.util.CompartmentManager;
import org.gvt.util.ID;

public class BioPAXL2Reader {
    public static boolean nestCompartments = true;

    public void createGraph(BioPAXL2Graph root) {
        CompoundModel compart;
        Collection<List<physicalEntityParticipant>> coll;
        HashMap<String, NodeModel> map = new HashMap<String, NodeModel>();
        pathway pathway2 = root.getPathway().l2p;
        Set<BioPAXElement> eles = this.collectRelatedElements(pathway2);
        if (nestCompartments) {
            this.createAndNestCompartments(eles, map, root);
        }
        for (BioPAXElement ele : eles) {
            physicalEntity pe;
            if (!(ele instanceof physicalEntity) || (pe = (physicalEntity)ele) instanceof complex || pe.isPHYSICAL_ENTITYof().isEmpty()) continue;
            coll = this.groupParticipants(pe, eles);
            for (List<physicalEntityParticipant> list : coll) {
                compart = this.getCompartment(list.get(0), map, (CompoundModel)root);
                Actor actor = new Actor(compart, pe, list);
                for (physicalEntityParticipant par : list) {
                    map.put(ID.get(par), actor);
                }
            }
        }
        for (BioPAXElement ele : eles) {
            complex cmp;
            if (!(ele instanceof complex) || (cmp = (complex)ele).isPHYSICAL_ENTITYof().isEmpty()) continue;
            coll = this.groupParticipants(cmp, eles);
            for (List<physicalEntityParticipant> list : coll) {
                Object nd;
                String nm;
                compart = this.getCompartment(list.get(0), map, (CompoundModel)root);
                if (compart == root && (nm = Complex.suggestCompartmentNameUsingMembers(cmp.getCOMPONENTS())) != null) {
                    if (nestCompartments) {
                        nm = CompartmentManager.getUnifiedName(nm);
                    }
                    compart = this.getCompartment(nm, map, (CompoundModel)root);
                }
                if (cmp.getCOMPONENTS().isEmpty()) {
                    nd = new Actor(compart, cmp, list);
                } else {
                    Complex c = new Complex(compart, cmp, list);
                    this.createComplexContent(c, cmp, list);
                    nd = c;
                }
                for (physicalEntityParticipant par : list) {
                    map.put(ID.get(par), (NodeModel)nd);
                }
            }
        }
        for (BioPAXElement ele : eles) {
            if (!(ele instanceof conversion)) continue;
            conversion conv = (conversion)ele;
            String compName = Conversion.getPossibleCompartmentName(conv);
            if (compName != null && nestCompartments) {
                compName = CompartmentManager.getUnifiedName(compName);
            }
            BioPAXL2Graph compart2 = compName == null ? root : (CompoundModel)map.get(compName);
            Conversion forwd = null;
            Conversion rever = null;
            if (this.evidenceExists(conv, true)) {
                forwd = new Conversion(compart2, conv, true, map);
                forwd.selectBestCompartment();
            }
            if (this.evidenceExists(conv, false)) {
                rever = new Conversion(compart2, conv, false, map);
                rever.selectBestCompartment();
            }
            if (forwd != null || rever != null) continue;
            forwd = new Conversion(compart2, conv, true, map);
            forwd.selectBestCompartment();
        }
        for (BioPAXElement ele : eles) {
            if (!(ele instanceof interaction)) continue;
            interaction inter = (interaction)ele;
            boolean drawPPI = true;
            if (!drawPPI) break;
            if (inter instanceof conversion || inter instanceof control) continue;
            Set<InteractionParticipant> interPartic = inter.getPARTICIPANTS();
            HashSet<physicalEntityParticipant> peps = new HashSet<physicalEntityParticipant>();
            boolean hasControl = !inter.isCONTROLLEDOf().isEmpty();
            for (InteractionParticipant partic : interPartic) {
                if (!(partic instanceof physicalEntityParticipant)) continue;
                peps.add((physicalEntityParticipant)partic);
            }
            if (hasControl || peps.size() != 2) {
                String compName = Hub.getPossibleCompartmentName(peps);
                if (nestCompartments) {
                    compName = CompartmentManager.getUnifiedName(compName);
                }
                BioPAXL2Graph compart3 = compName == null ? root : (CompoundModel)map.get(compName);
                Hub hub = new Hub(compart3, inter, new ArrayList<physicalEntityParticipant>(peps), map);
                for (physicalEntityParticipant pep : peps) {
                    NodeModel node = (NodeModel)map.get(ID.get(pep));
                    if (node == null) {
                        System.err.println("PEP without PE");
                        continue;
                    }
                    assert (node != null);
                    new MultiTouch(node, hub, pep);
                }
                continue;
            }
            NodeModel[] ends = new NodeModel[2];
            int i = 0;
            for (physicalEntityParticipant pep : peps) {
                ends[i++] = (NodeModel)map.get(ID.get(pep));
            }
            if (ends[0] == null || ends[1] == null) {
                System.err.println("PEP without PE");
                continue;
            }
            assert (ends[0] != null) : "Source of a Pairing is null";
            assert (ends[1] != null) : "Target of a Pairing is null";
            new Pairing(inter, (physicalEntityParticipant)peps.iterator().next(), ends[0], ends[1]);
        }
    }

    private CompoundModel getCompartment(physicalEntityParticipant par, Map<String, NodeModel> map, CompoundModel root) {
        if (par.getCELLULAR_LOCATION() != null && !par.getCELLULAR_LOCATION().getTERM().isEmpty()) {
            Compartment comp;
            String compName = par.getCELLULAR_LOCATION().getTERM().iterator().next();
            if (nestCompartments) {
                compName = CompartmentManager.getUnifiedName(compName);
            }
            if ((comp = (Compartment)map.get(compName)) == null) {
                comp = new Compartment(root, compName);
                map.put(compName, comp);
            }
            return comp;
        }
        return root;
    }

    private CompoundModel getCompartment(String compName, Map<String, NodeModel> map, CompoundModel root) {
        Compartment comp;
        if (nestCompartments) {
            compName = CompartmentManager.getUnifiedName(compName);
        }
        if ((comp = (Compartment)map.get(compName)) == null) {
            comp = new Compartment(root, compName);
            map.put(compName, comp);
        }
        return comp;
    }

    private void createAndNestCompartments(Set<BioPAXElement> eles, Map<String, NodeModel> map, CompoundModel root) {
        assert (nestCompartments);
        HashMap<String, CompoundModel> compMap = new HashMap<String, CompoundModel>();
        for (BioPAXElement ele : eles) {
            physicalEntityParticipant par;
            if (!(ele instanceof physicalEntityParticipant) || (par = (physicalEntityParticipant)ele).getCELLULAR_LOCATION() == null || par.getCELLULAR_LOCATION().getTERM().isEmpty()) continue;
            String compName = par.getCELLULAR_LOCATION().getTERM().iterator().next();
            Compartment comp = (Compartment)map.get(compName = CompartmentManager.getUnifiedName(compName));
            if (comp != null) continue;
            comp = new Compartment(root, compName);
            map.put(compName, comp);
            compMap.put(compName, comp);
        }
        CompartmentManager.nestCompartments(compMap);
    }

    private void createComplexContent(Complex c, complex cmp, List<physicalEntityParticipant> upper) {
        for (physicalEntityParticipant par : cmp.getCOMPONENTS()) {
            assert (par.getPHYSICAL_ENTITY() != null) : "physicalEntity of PEP is null";
            upper.add(0, par);
            physicalEntity pe = par.getPHYSICAL_ENTITY();
            if (pe instanceof complex && !((complex)pe).getCOMPONENTS().isEmpty()) {
                this.createComplexContent(c, (complex)pe, upper);
            } else {
                new ComplexMember(c, pe, new ArrayList<physicalEntityParticipant>(upper));
            }
            upper.remove(0);
        }
    }

    private boolean evidenceExists(conversion conv, boolean direction) {
        boolean evident;
        for (control cont : conv.isCONTROLLEDOf()) {
            Direction dir;
            if (!(cont instanceof catalysis) || (dir = ((catalysis)cont).getDIRECTION()) == null) continue;
            if (dir == Direction.REVERSIBLE) {
                return true;
            }
            if (!(direction ? dir == Direction.IRREVERSIBLE_LEFT_TO_RIGHT || dir == Direction.PHYSIOL_LEFT_TO_RIGHT : dir == Direction.IRREVERSIBLE_RIGHT_TO_LEFT || dir == Direction.PHYSIOL_RIGHT_TO_LEFT)) continue;
            return true;
        }
        SpontaneousType spon = conv.getSPONTANEOUS();
        boolean bl = evident = spon != null && spon != SpontaneousType.NOT_SPONTANEOUS && (direction && spon == SpontaneousType.L_R || !direction && spon == SpontaneousType.R_L);
        if (!evident) {
            evident = conv.getCOMMENT().contains("reversible");
        }
        return evident;
    }

    private Collection<List<physicalEntityParticipant>> groupParticipants(physicalEntity pe, Set<BioPAXElement> eles) {
        ArrayList<List<physicalEntityParticipant>> set = new ArrayList<List<physicalEntityParticipant>>();
        for (physicalEntityParticipant par : pe.isPHYSICAL_ENTITYof()) {
            if (par.isCOMPONENTof() != null || !eles.contains(par)) continue;
            List<physicalEntityParticipant> parts = null;
            for (List list : set) {
                if (!((physicalEntityParticipant)list.get(0)).isInEquivalentState(par)) continue;
                parts = list;
            }
            if (this.isUbique(pe) || parts == null) {
                parts = new ArrayList<physicalEntityParticipant>();
                set.add(parts);
            }
            parts.add(par);
        }
        return set;
    }

    private boolean isUbique(physicalEntity pe) {
        return pe instanceof smallMolecule && Actor.isUbiqueName(pe.getNAME());
    }

    private Set<BioPAXElement> collectRelatedElements(pathway pathway2) {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        set.addAll(pathway2.getPATHWAY_COMPONENTS());
        HashSet<BioPAXElement> processed = new HashSet<BioPAXElement>();
        do {
            this.enrich(set, processed);
        } while (set.size() > processed.size());
        return set;
    }

    private void enrich(Set<BioPAXElement> set, Set<BioPAXElement> processed) {
        HashSet<BioPAXElement> temp = new HashSet<BioPAXElement>(set);
        temp.removeAll(processed);
        for (BioPAXElement ele : temp) {
            processed.add(ele);
            if (ele instanceof interaction) {
                set.addAll(((interaction)ele).getPARTICIPANTS());
                set.addAll(((interaction)ele).isCONTROLLEDOf());
                continue;
            }
            if (ele instanceof physicalEntityParticipant) {
                set.add(((physicalEntityParticipant)ele).getPHYSICAL_ENTITY());
                continue;
            }
            if (!(ele instanceof complex)) continue;
            set.addAll(((complex)ele).getCOMPONENTS());
        }
    }

    private void PEPCheck(Model model) {
        HashMap<String, physicalEntity> rdfToPE = new HashMap<String, physicalEntity>();
        for (physicalEntity pe : model.getObjects(physicalEntity.class)) {
            rdfToPE.put(ID.get(pe), pe);
        }
        Set<physicalEntityParticipant> peps = model.getObjects(physicalEntityParticipant.class);
        for (physicalEntityParticipant pep : peps) {
            physicalEntity pe = pep.getPHYSICAL_ENTITY();
            if (pe == null) {
                System.err.println("PE of PEP is null. PEP id: " + ID.get(pep));
                continue;
            }
            if (rdfToPE.containsKey(ID.get(pe)) && rdfToPE.get(ID.get(pe)) == pe) continue;
            System.err.println("PE of PEP is not in model.\nPEP id: " + ID.get(pep) + "\nPE id: " + ID.get(pe));
        }
    }
}

