/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;

public class ChsTransform {
    private double lworldOrgX;
    private double lworldOrgY;
    private double lworldExtX;
    private double lworldExtY;
    private double ldeviceOrgX;
    private double ldeviceOrgY;
    private double ldeviceExtX;
    private double ldeviceExtY;

    public ChsTransform() {
        this.init();
    }

    void init() {
        this.lworldOrgX = 0.0;
        this.lworldOrgY = 0.0;
        this.ldeviceOrgX = 0.0;
        this.ldeviceOrgY = 0.0;
        this.lworldExtX = 1.0;
        this.lworldExtY = 1.0;
        this.ldeviceExtX = 1.0;
        this.ldeviceExtY = 1.0;
    }

    public double getWorldOrgX() {
        return this.lworldOrgX;
    }

    public void setWorldOrgX(double wox) {
        this.lworldOrgX = wox;
    }

    public double getWorldOrgY() {
        return this.lworldOrgY;
    }

    public void setWorldOrgY(double woy) {
        this.lworldOrgY = woy;
    }

    public double getWorldExtX() {
        return this.lworldExtX;
    }

    public void setWorldExtX(double wex) {
        this.lworldExtX = wex;
    }

    public double getWorldExtY() {
        return this.lworldExtY;
    }

    public void setWorldExtY(double wey) {
        this.lworldExtY = wey;
    }

    public double getDeviceOrgX() {
        return this.ldeviceOrgX;
    }

    public void setDeviceOrgX(double dox) {
        this.ldeviceOrgX = dox;
    }

    public double getDeviceOrgY() {
        return this.ldeviceOrgY;
    }

    public void setDeviceOrgY(double doy) {
        this.ldeviceOrgY = doy;
    }

    public double getDeviceExtX() {
        return this.ldeviceExtX;
    }

    public void setDeviceExtX(double dex) {
        this.ldeviceExtX = dex;
    }

    public double getDeviceExtY() {
        return this.ldeviceExtY;
    }

    public void setDeviceExtY(double dey) {
        this.ldeviceExtY = dey;
    }

    public double transformX(double x) {
        double worldExtX = this.lworldExtX;
        double xDevice = worldExtX != 0.0 ? this.ldeviceOrgX + (x - this.lworldOrgX) * this.ldeviceExtX / worldExtX : 0.0;
        return xDevice;
    }

    public double transformY(double y) {
        double worldExtY = this.lworldExtY;
        double yDevice = worldExtY != 0.0 ? this.ldeviceOrgY + (y - this.lworldOrgY) * this.ldeviceExtY / worldExtY : 0.0;
        return yDevice;
    }

    public double inverseTransformX(double x) {
        double deviceExtX = this.ldeviceExtX;
        double xWorld = deviceExtX != 0.0 ? this.lworldOrgX + (x - this.ldeviceOrgX) * this.lworldExtX / deviceExtX : 0.0;
        return xWorld;
    }

    public double inverseTransformY(double y) {
        double deviceExtY = this.ldeviceExtY;
        double yWorld = deviceExtY != 0.0 ? this.lworldOrgY + (y - this.ldeviceOrgY) * this.lworldExtY / deviceExtY : 0.0;
        return yWorld;
    }

    public PrecisionPoint transformPoint(PrecisionPoint inPoint) {
        PrecisionPoint outPoint = new PrecisionPoint(this.transformX(inPoint.preciseX), this.transformY(inPoint.preciseY));
        return outPoint;
    }

    public PrecisionDimension transformDimension(PrecisionDimension inDimension) {
        PrecisionDimension outDimension = new PrecisionDimension(this.transformX(inDimension.preciseWidth) - this.transformX(0.0), this.transformY(inDimension.preciseHeight) - this.transformY(0.0));
        return outDimension;
    }

    public PrecisionRectangle transformRect(PrecisionRectangle inRect) {
        PrecisionRectangle outRect = new PrecisionRectangle();
        PrecisionDimension inRectDim = new PrecisionDimension(inRect.preciseWidth, inRect.preciseHeight);
        PrecisionDimension outRectDim = this.transformDimension(inRectDim);
        outRect.setWidth(outRectDim.preciseWidth);
        outRect.setHeight(outRectDim.preciseHeight);
        outRect.setX(this.transformX(inRect.preciseX));
        outRect.setY(this.transformY(inRect.preciseY));
        return outRect;
    }

    public PrecisionPoint inverseTransformPoint(PrecisionPoint inPoint) {
        PrecisionPoint outPoint = new PrecisionPoint(this.inverseTransformX(inPoint.preciseX), this.inverseTransformY(inPoint.preciseY));
        return outPoint;
    }

    public PrecisionDimension inverseTransformDimension(PrecisionDimension inDimension) {
        PrecisionDimension outDimension = new PrecisionDimension(this.inverseTransformX(inDimension.preciseWidth - this.inverseTransformX(0.0)), this.inverseTransformY(inDimension.preciseHeight - this.inverseTransformY(0.0)));
        return outDimension;
    }

    public PrecisionRectangle inverseTransformRect(PrecisionRectangle inRect) {
        PrecisionRectangle outRect = new PrecisionRectangle();
        PrecisionDimension inRectDim = new PrecisionDimension(inRect.preciseWidth, inRect.preciseHeight);
        PrecisionDimension outRectDim = this.inverseTransformDimension(inRectDim);
        outRect.setWidth(outRectDim.preciseWidth);
        outRect.setHeight(outRectDim.preciseHeight);
        outRect.setX(this.inverseTransformX(inRect.preciseX));
        outRect.setY(this.inverseTransformY(inRect.preciseY));
        return outRect;
    }

    public void adjustExtToPreserveAspectRatio() {
        double deviceExtX = this.ldeviceExtX;
        double deviceExtY = this.ldeviceExtY;
        if (deviceExtY != 0.0 && deviceExtX != 0.0) {
            double worldExtX = this.lworldExtX;
            double worldExtY = this.lworldExtY;
            if (deviceExtY * worldExtX < deviceExtX * worldExtY) {
                this.setWorldExtX(deviceExtY > 0.0 ? deviceExtX * worldExtY / deviceExtY : 0.0);
            } else {
                this.setWorldExtY(deviceExtX > 0.0 ? deviceExtY * worldExtX / deviceExtX : 0.0);
            }
        }
    }

    public static void main(String[] args) {
        ChsTransform trans = new ChsTransform();
        trans.setWorldOrgX(0.0);
        trans.setWorldOrgY(0.0);
        trans.setWorldExtX(100.0);
        trans.setWorldExtY(50.0);
        trans.setDeviceOrgX(10.0);
        trans.setDeviceOrgY(20.0);
        trans.setDeviceExtX(50.0);
        trans.setDeviceExtY(-100.0);
        PrecisionRectangle rectWorld = new PrecisionRectangle();
        rectWorld.preciseX = 12.0;
        rectWorld.preciseY = -25.0;
        rectWorld.preciseWidth = 150.0;
        rectWorld.preciseHeight = 150.0;
        PrecisionPoint pointWorld = new PrecisionPoint(rectWorld.preciseX, rectWorld.preciseY);
        PrecisionDimension dimWorld = new PrecisionDimension(rectWorld.preciseWidth, rectWorld.preciseHeight);
        PrecisionPoint pointDevice = trans.transformPoint(pointWorld);
        PrecisionDimension dimDevice = trans.transformDimension(dimWorld);
        PrecisionRectangle rectDevice = trans.transformRect(rectWorld);
    }
}

