/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.custom.CustomEdge;
import org.gvt.model.custom.CustomGraph;
import org.gvt.model.custom.CustomGroup;
import org.gvt.model.custom.CustomNode;

public class CustomReader {
    protected Map<String, NodeModel> nodeMap = new HashMap<String, NodeModel>();
    protected Map<String, CustomEdge> edgeMap = new HashMap<String, CustomEdge>();
    protected Map<String, CustomGroup> compoundMap;

    public CompoundModel readFile(File file) {
        Map<String, List<Map<String, String>>> map = this.readIntoMaps(file);
        CustomGraph graph = new CustomGraph(map.containsKey("GRAPH") ? map.get("GRAPH").iterator().next() : null);
        if (map.containsKey("NODE")) {
            for (Map<String, String> nodeProps : map.get("NODE")) {
                if (this.nodeMap.containsKey(nodeProps.get("ID"))) continue;
                CustomNode node = new CustomNode((CompoundModel)graph, nodeProps);
                this.nodeMap.put(nodeProps.get("ID"), node);
            }
        }
        if (map.containsKey("EDGE")) {
            for (Map<String, String> edgeProps : map.get("EDGE")) {
                if (this.edgeMap.containsKey(edgeProps.get("ID"))) continue;
                assert (edgeProps.containsKey("SOURCE"));
                assert (edgeProps.containsKey("TARGET"));
                assert (this.nodeMap.containsKey(edgeProps.get("SOURCE")));
                assert (this.nodeMap.containsKey(edgeProps.get("TARGET"))) : "Target node does not exist: " + edgeProps.get("TARGET");
                CustomEdge edge = new CustomEdge(this.nodeMap.get(edgeProps.get("SOURCE")), this.nodeMap.get(edgeProps.get("TARGET")), edgeProps);
                this.edgeMap.put(edgeProps.get("ID"), edge);
            }
        }
        if (map.containsKey("COMPOUND")) {
            for (Map<String, String> compoundProps : map.get("COMPOUND")) {
                assert (compoundProps.containsKey("ID"));
                CustomGroup group = new CustomGroup(graph, compoundProps, this.nodeMap);
                this.nodeMap.put(compoundProps.get("ID"), group);
            }
        }
        return graph;
    }

    protected Map<String, List<Map<String, String>>> readIntoMaps(File file) {
        try {
            HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null && !(line = line.trim()).equals("ENDOFFILE")) {
                if (line.length() != 0 && !line.startsWith("#")) {
                    HashMap<String, String> eleMap = new HashMap<String, String>();
                    for (String token : line.split("\t")) {
                        int ind = token.indexOf(":");
                        if (ind < 0) continue;
                        eleMap.put(token.substring(0, ind).trim().toUpperCase(), token.substring(ind + 1).trim());
                    }
                    String type = (String)eleMap.get("TYPE");
                    if (type != null) {
                        if (!map.containsKey(type = type.toUpperCase())) {
                            map.put(type, new ArrayList());
                        }
                        ((List)map.get(type)).add(eleMap);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

