/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.gvt.model.CompoundModel;
import org.gvt.model.basicsif.BasicSIFEdge;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.basicsif.BasicSIFNode;
import org.gvt.model.basicsif.BasicSIFPathway;
import org.gvt.model.sifl3.SIFEdge;
import org.gvt.util.Conf;

public class SIFReader {
    private List<? extends SIFType> enumTypes;
    private Set<String> types;
    private Map<String, BasicSIFNode> nodeMap = new HashMap<String, BasicSIFNode>();
    private Set<String> relationsSet = new HashSet<String>();
    private BasicSIFGraph root;
    private String delim;
    private boolean useGroups = true;
    private boolean duplicatesExist;
    private boolean groupsExist = false;

    public SIFReader() {
    }

    public SIFReader(List<? extends SIFType> enumTypes) {
        this();
        this.enumTypes = enumTypes;
    }

    public void setUseGroups(boolean useGroups) {
        this.useGroups = useGroups;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompoundModel readXMLFile(File sifFile) {
        boolean bl;
        if (this.enumTypes != null) {
            this.types = new HashSet<String>();
            for (SIFType sIFType : this.enumTypes) {
                this.types.add(sIFType.getTag());
            }
        }
        try {
            this.duplicatesExist = false;
            this.root = new BasicSIFGraph();
            String filename = sifFile.getName();
            this.root.setName(filename.substring(0, filename.indexOf(".sif")));
            this.root.setAsRoot();
            this.delim = this.fileContainsTab(sifFile) ? "\t|\n|\r|\f" : " |\n|\r|\f";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(sifFile));
            String line = bufferedReader.readLine();
            while (line != null) {
                if (line.trim().length() > 0) {
                    this.processLine(line);
                }
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (!this.duplicatesExist) {
                // empty if block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageBox messageBox = new MessageBox(new Shell(), 42);
            messageBox.setMessage("File cannot be loaded!");
            messageBox.setText("Chisio BioPAX Editor");
            messageBox.open();
            return null;
        }
        System.out.println("SIF view contains " + this.root.getNodes().size() + " nodes and " + this.root.getEdges().size() + " edges.");
        String formatFile = sifFile.getPath().substring(0, sifFile.getPath().lastIndexOf(".")) + ".format";
        boolean bl2 = this.useGroups;
        if (new File(formatFile).exists()) {
            boolean bl3 = bl = this.formatView(formatFile) && this.useGroups;
        }
        if (bl && Conf.getBoolean("USE_SIF_GROUPING") && !this.groupsExist) {
            this.root.groupSimilarNodes();
        }
        return this.root;
    }

    private void processLine(String line) {
        String[] t = line.split(this.delim);
        String first = t[0];
        if (t[0].equals("$group$")) {
            new BasicSIFPathway(this.root, this.getNodes(t[2].split(" ")), t[1], t[3]);
            this.groupsExist = true;
        } else if (t.length > 2) {
            BasicSIFEdge edge;
            String meds;
            String relation = t[1];
            String second = t[2];
            String string = meds = t.length > 3 ? t[3] : null;
            if ((this.types == null || this.types.contains(relation)) && (edge = this.createUnit(first, relation, second, meds)) != null && t.length > 4) {
                String phs = t[4];
                phs = phs.replaceAll(";", "\n");
                edge.setTooltipText(phs);
            }
        } else {
            this.getNode(first);
        }
    }

    private BasicSIFEdge createUnit(String first, String relation, String second, String medIDs) {
        if (!SIFEdge.typeMap.containsKey(relation)) {
            return null;
        }
        String relStr = first + "\t" + relation + "\t" + second;
        String revStr = second + "\t" + relation + "\t" + first;
        if (this.relationsSet.contains(relStr) || !SIFEdge.typeMap.get(relation).isDirected() && this.relationsSet.contains(revStr)) {
            this.duplicatesExist = true;
            return null;
        }
        this.relationsSet.add(relStr);
        BasicSIFNode node1 = this.getNode(first);
        BasicSIFNode node2 = this.getNode(second);
        return new BasicSIFEdge(node1, node2, relation, medIDs);
    }

    private BasicSIFNode getNode(String id) {
        if (!this.nodeMap.containsKey(id)) {
            BasicSIFNode node = new BasicSIFNode(this.root, id, id);
            this.nodeMap.put(id, node);
        }
        return this.nodeMap.get(id);
    }

    private Set<BasicSIFNode> getNodes(String[] ids) {
        HashSet<BasicSIFNode> set = new HashSet<BasicSIFNode>();
        for (String id : ids) {
            set.add(this.getNode(id));
        }
        return set;
    }

    private boolean fileContainsTab(File filename) throws IOException {
        int i;
        boolean contains = false;
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        while ((i = reader.read()) != -1) {
            if (i != 9) continue;
            contains = true;
        }
        reader.close();
        return contains;
    }

    private boolean formatView(String formatFile) {
        boolean group = this.useGroups;
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(formatFile));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("graph\tgrouping")) {
                    this.useGroups = line.endsWith("\ton");
                } else {
                    lines.add(line);
                }
                line = reader.readLine();
            }
            reader.close();
            this.root.format(lines);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return group;
    }
}

