/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.patika.mada.algorithm.BFS;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class LocalPoIQuery {
    private Set<Node> sourceSet;
    private Set<Node> targetSet;
    private boolean limitType;
    private int stopDistance;
    private boolean strict;
    public static final boolean SHORTEST_PLUS_K = false;
    public static final boolean NORMAL_LIMIT = true;

    public LocalPoIQuery(Set<Node> sourceSet, Set<Node> targetSet, boolean limitType, int stopDistance, boolean strict) {
        this.sourceSet = sourceSet;
        this.targetSet = targetSet;
        this.limitType = limitType;
        this.stopDistance = stopDistance;
        this.strict = strict;
    }

    public Set<GraphObject> run() {
        HashSet<GraphObject> result;
        block11: {
            BFS bfsRev;
            BFS bfsFwd;
            HashMap<GraphObject, Integer> candidate;
            block10: {
                candidate = new HashMap<GraphObject, Integer>();
                result = new HashSet<GraphObject>();
                bfsFwd = null;
                bfsRev = null;
                if (this.limitType && !this.strict) {
                    bfsFwd = new BFS(this.sourceSet, null, true, this.stopDistance);
                    bfsRev = new BFS(this.targetSet, null, false, this.stopDistance);
                } else if (this.limitType && this.strict) {
                    bfsFwd = new BFS(this.sourceSet, this.targetSet, true, this.stopDistance);
                    bfsRev = new BFS(this.targetSet, this.sourceSet, false, this.stopDistance);
                } else if (!this.limitType && !this.strict) {
                    bfsFwd = new BFS(this.sourceSet, null, true, 25);
                    bfsRev = new BFS(this.targetSet, null, false, 25);
                } else if (!this.limitType && this.strict) {
                    bfsFwd = new BFS(this.sourceSet, this.targetSet, true, 25);
                    bfsRev = new BFS(this.targetSet, this.sourceSet, false, 25);
                }
                candidate.putAll(bfsFwd.run());
                candidate.putAll(bfsRev.run());
                if (!this.limitType) break block10;
                for (GraphObject go : candidate.keySet()) {
                    if (bfsFwd.getLabel(go) + bfsRev.getLabel(go) > this.stopDistance) continue;
                    result.add(go);
                }
                break block11;
            }
            int shortestPath = Integer.MAX_VALUE;
            for (GraphObject go : candidate.keySet()) {
                if (bfsFwd.getLabel(go) + bfsRev.getLabel(go) > shortestPath) continue;
                shortestPath = bfsFwd.getLabel(go) + bfsRev.getLabel(go);
            }
            if (shortestPath >= 0x3FFFFFFF) break block11;
            for (GraphObject go : candidate.keySet()) {
                if (bfsFwd.getLabel(go) + bfsRev.getLabel(go) > shortestPath + this.stopDistance) continue;
                result.add(go);
            }
        }
        return result;
    }
}

