/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class PathsBetweenSIF {
    private Set<Node> sourceSeed;
    private Set<Node> targetSeed;
    private boolean directed;
    private int limit;
    private boolean useShortestPlusK = false;
    private boolean ignoreSelfLoops = true;
    private boolean considerAllPairs = false;
    private boolean shortestAnyDir = true;
    private Map<Node, Map<Node, Integer>> shortestPairLengths;
    private Map<Node, Integer> shortestSingleLengths;
    private int k = 0;
    Set<GraphObject> goi;
    private Map<GraphObject, Map<Integer, Set<Node>>> fwdLabel;
    private Map<GraphObject, Map<Integer, Set<Node>>> bkwLabel;
    private Map<GraphObject, Map<Integer, Set<Node>>> labelMap;
    private Set<GraphObject> visitedGlobal;
    private Set<GraphObject> visitedStep;
    public static final String DIST = "DIST";
    public static final String DIST_FORWARD = "DIST_FORWARD";
    public static final String DIST_BACKWARD = "DIST_BACKWARD";
    public static final boolean FORWARD = true;
    public static final boolean BACKWARD = false;
    public static final boolean UPSTREAM = true;
    public static final boolean DOWNSTREAM = false;

    public PathsBetweenSIF(Set<Node> seed, boolean directed, int limit) {
        this.sourceSeed = seed;
        this.targetSeed = seed;
        this.directed = directed;
        this.limit = limit;
    }

    public PathsBetweenSIF(Set<Node> sourceSeed, Set<Node> targetSeed, boolean directed, int limit) {
        this.sourceSeed = sourceSeed;
        this.targetSeed = targetSeed;
        this.directed = directed;
        this.limit = limit;
    }

    public void setUseShortestPlusK(boolean useShortestPlusK) {
        this.useShortestPlusK = useShortestPlusK;
    }

    public void setIgnoreSelfLoops(boolean ignoreSelfLoops) {
        this.ignoreSelfLoops = ignoreSelfLoops;
    }

    public void setConsiderAllPairs(boolean considerAllPairs) {
        this.considerAllPairs = considerAllPairs;
    }

    public void setShortestAnyDir(boolean shortestAnyDir) {
        this.shortestAnyDir = shortestAnyDir;
    }

    public void setShortestPairLengths(Map<Node, Map<Node, Integer>> shortestPairLengths) {
        this.shortestPairLengths = shortestPairLengths;
    }

    public void setK(int k) {
        this.k = k;
    }

    public Set<GraphObject> run() {
        this.goi = new HashSet<GraphObject>();
        this.visitedGlobal = new HashSet<GraphObject>();
        this.visitedStep = new HashSet<GraphObject>();
        if (this.directed) {
            this.fwdLabel = new HashMap<GraphObject, Map<Integer, Set<Node>>>();
            this.bkwLabel = new HashMap<GraphObject, Map<Integer, Set<Node>>>();
        } else {
            this.labelMap = new HashMap<GraphObject, Map<Integer, Set<Node>>>();
        }
        for (Node node : this.sourceSeed) {
            this.initSeed(node);
            if (this.directed) {
                this.runBFS_directed(node, true);
            } else {
                this.runBFS_undirected(node);
            }
            this.recordDistances(node);
            this.clearLabels();
        }
        for (Node node : this.targetSeed) {
            if (!this.directed && this.sourceSeed.contains(node)) continue;
            this.initSeed(node);
            if (this.directed) {
                this.runBFS_directed(node, false);
            } else {
                this.runBFS_undirected(node);
            }
            this.recordDistances(node);
            this.clearLabels();
        }
        if (this.useShortestPlusK) {
            this.findShortestPaths();
        }
        if (this.directed) {
            this.mergeLabels(this.fwdLabel);
            this.mergeLabels(this.bkwLabel);
        } else {
            this.mergeLabels(this.labelMap);
        }
        this.selectSatisfyingElements();
        this.pruneResult();
        assert (this.checkEdgeSanity());
        return this.goi;
    }

    private void runBFS_directed(Node seed, boolean direction) {
        assert (this.directed);
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(seed);
        this.visitedStep.add(seed);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.poll();
            this.BFS_directed(node, direction, queue);
        }
    }

    private void runBFS_undirected(Node seed) {
        assert (!this.directed);
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(seed);
        this.visitedStep.add(seed);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.poll();
            this.BFS_undirected(node, queue);
        }
    }

    private void BFS_directed(Node node, boolean forward, LinkedList<Node> queue) {
        assert (this.directed);
        if (forward) {
            this.BFStep(node, false, DIST_FORWARD, queue);
        } else {
            this.BFStep(node, true, DIST_BACKWARD, queue);
        }
    }

    private void BFStep(Node node, boolean upstr, String label, LinkedList<Node> queue) {
        int d = this.getLabel(node, label);
        if (d < this.limit) {
            for (Edge edge : upstr ? node.getUpstream() : node.getDownstream()) {
                if (this.visitedStep.contains(edge)) continue;
                this.setLabel(edge, label, !upstr && label.equals(DIST_FORWARD) ? d + 1 : d);
                Node n = upstr ? edge.getSourceNode() : edge.getTargetNode();
                int d_n = this.getLabel(n, label);
                if (d_n <= d + 1) continue;
                if (!(d + 1 >= this.limit || this.visitedStep.contains(n) || queue.contains(n) || this.ignoreSelfLoops && (this.sourceSeed.contains(n) || this.targetSeed.contains(n)))) {
                    queue.add(n);
                }
                this.setLabel(n, label, d + 1);
            }
        }
    }

    private void BFS_undirected(Node node, LinkedList<Node> queue) {
        assert (!this.directed);
        this.BFStep(node, true, DIST, queue);
        this.BFStep(node, false, DIST, queue);
    }

    private void initSeed(GraphObject obj) {
        if (this.directed) {
            this.setLabel(obj, DIST_FORWARD, 0);
            this.setLabel(obj, DIST_BACKWARD, 0);
        } else {
            this.setLabel(obj, DIST, 0);
        }
    }

    private void selectSatisfyingElements() {
        for (GraphObject go : this.visitedGlobal) {
            if (!this.distanceSatisfies(go)) continue;
            this.goi.add(go);
        }
        HashSet<Edge> extra = new HashSet<Edge>();
        for (GraphObject go : this.goi) {
            Edge edge;
            if (!(go instanceof Edge) || this.goi.contains((edge = (Edge)go).getSourceNode()) && this.goi.contains(edge.getTargetNode())) continue;
            extra.add(edge);
        }
        this.goi.removeAll(extra);
    }

    private boolean distanceSatisfies(GraphObject go) {
        if (this.directed) {
            return this.distanceSatisfies(go, this.fwdLabel, this.bkwLabel);
        }
        return this.distanceSatisfies(go, this.labelMap, this.labelMap);
    }

    private boolean distanceSatisfies(GraphObject go, Map<GraphObject, Map<Integer, Set<Node>>> fwdLabel, Map<GraphObject, Map<Integer, Set<Node>>> bkwLabel) {
        if (!fwdLabel.containsKey(go) || !bkwLabel.containsKey(go)) {
            return false;
        }
        for (Integer i : fwdLabel.get(go).keySet()) {
            for (Integer j : bkwLabel.get(go).keySet()) {
                int dist = i + j;
                if (!this.directed && go instanceof Edge) {
                    ++dist;
                }
                if (dist > this.limit || !this.setsSatisfy(fwdLabel.get(go).get(i), bkwLabel.get(go).get(j), dist)) continue;
                return true;
            }
        }
        return false;
    }

    private void pruneResult() {
        for (GraphObject go : new HashSet<GraphObject>(this.goi)) {
            if (!(go instanceof Node)) continue;
            this.prune((Node)go);
        }
    }

    private void prune(Node node) {
        if (this.goi.contains(node) && !this.sourceSeed.contains(node) && !this.targetSeed.contains(node) && this.getNeighborsInResult(node).size() <= 1) {
            this.goi.remove(node);
            this.goi.removeAll(node.getUpstream());
            this.goi.removeAll(node.getDownstream());
            for (Node n : this.getNeighborsOverResultEdges(node)) {
                this.prune(n);
            }
        }
    }

    private Set<Node> getNeighborsOverResultEdges(Node node) {
        HashSet<Node> set = new HashSet<Node>();
        for (Edge edge : node.getUpstream()) {
            if (!this.goi.contains(edge)) continue;
            set.add(edge.getSourceNode());
        }
        for (Edge edge : node.getDownstream()) {
            if (!this.goi.contains(edge)) continue;
            set.add(edge.getTargetNode());
        }
        set.remove(node);
        return set;
    }

    private Set<Node> getNeighborsInResult(Node node) {
        Set<Node> set = this.getNeighborsOverResultEdges(node);
        set.retainAll(this.goi);
        return set;
    }

    private void clearLabels() {
        for (GraphObject go : this.visitedStep) {
            if (this.directed) {
                go.removeLabel(DIST_FORWARD);
                go.removeLabel(DIST_BACKWARD);
                continue;
            }
            go.removeLabel(DIST);
        }
        this.visitedStep.clear();
    }

    private boolean checkEdgeSanity() {
        for (GraphObject go : this.goi) {
            if (!(go instanceof Edge)) continue;
            Edge edge = (Edge)go;
            assert (this.goi.contains(edge.getSourceNode()));
            assert (this.goi.contains(edge.getTargetNode()));
        }
        return true;
    }

    private int getLabel(GraphObject go, String label) {
        if (go.hasLabel(label)) {
            return (Integer)go.getLabel(label);
        }
        return 0x3FFFFFFF;
    }

    private void setLabel(GraphObject go, String label, Integer value) {
        go.putLabel(label, value);
        this.visitedStep.add(go);
        this.visitedGlobal.add(go);
    }

    private void recordDistances(Node seed) {
        for (GraphObject go : this.visitedGlobal) {
            if (this.directed) {
                this.recordDistance(go, seed, DIST_FORWARD, this.fwdLabel);
                this.recordDistance(go, seed, DIST_BACKWARD, this.bkwLabel);
                continue;
            }
            this.recordDistance(go, seed, DIST, this.labelMap);
        }
    }

    private void recordDistance(GraphObject go, Node seed, String label, Map<GraphObject, Map<Integer, Set<Node>>> map) {
        int d = this.getLabel(go, label);
        if (d > this.limit) {
            return;
        }
        if (!map.containsKey(go)) {
            map.put(go, new HashMap());
        }
        if (!map.get(go).containsKey(d)) {
            map.get(go).put(d, new HashSet());
        }
        map.get(go).get(d).add(seed);
    }

    private void mergeLabels(Map<GraphObject, Map<Integer, Set<Node>>> map) {
        for (GraphObject go : map.keySet()) {
            for (int i = 0; i < this.limit; ++i) {
                if (!map.get(go).containsKey(i)) continue;
                for (int j = i + 1; j <= this.limit; ++j) {
                    if (!map.get(go).containsKey(j)) continue;
                    map.get(go).get(j).addAll((Collection<Node>)map.get(go).get(i));
                }
            }
        }
    }

    private boolean setsSatisfy(Set<Node> set1, Set<Node> set2, int length) {
        assert (!set1.isEmpty());
        assert (!set2.isEmpty());
        if (this.useShortestPlusK) {
            for (Node source : set1) {
                for (Node target : set2) {
                    int limit;
                    if (this.ignoreSelfLoops && source.equals(target) || !this.sourceSeed.contains(source) || !this.targetSeed.contains(target) || (!this.considerAllPairs || !this.shortestPairLengths.containsKey(source) || !this.shortestPairLengths.get(source).containsKey(target)) && (this.considerAllPairs || !this.shortestSingleLengths.containsKey(source) || !this.shortestSingleLengths.containsKey(target))) continue;
                    if (this.considerAllPairs) {
                        limit = this.shortestPairLengths.get(source).get(target);
                        if (this.shortestAnyDir && this.shortestPairLengths.containsKey(target) && this.shortestPairLengths.get(target).containsKey(source)) {
                            limit = Math.min(limit, this.shortestPairLengths.get(target).get(source));
                        }
                    } else {
                        limit = Math.max(this.shortestSingleLengths.get(source), this.shortestSingleLengths.get(target));
                    }
                    if ((limit = Math.min(limit + this.k, this.limit)) < length) continue;
                    return true;
                }
            }
            return false;
        }
        for (Node source : set1) {
            for (Node target : set2) {
                if (this.ignoreSelfLoops && source.equals(target) || !this.sourceSeed.contains(source) || !this.targetSeed.contains(target)) continue;
                return true;
            }
        }
        return false;
    }

    private void findShortestPaths() {
        if (this.directed) {
            this.findShortestPaths(this.fwdLabel, this.bkwLabel);
        } else {
            this.findShortestPaths(this.labelMap, this.labelMap);
        }
    }

    private void findShortestPaths(Map<GraphObject, Map<Integer, Set<Node>>> fwdLabel, Map<GraphObject, Map<Integer, Set<Node>>> bkwLabel) {
        if (this.considerAllPairs) {
            this.shortestPairLengths = new HashMap<Node, Map<Node, Integer>>();
        } else {
            this.shortestSingleLengths = new HashMap<Node, Integer>();
        }
        for (GraphObject go : fwdLabel.keySet()) {
            if (go instanceof Edge) continue;
            Map<Integer, Set<Node>> fwMap = fwdLabel.get(go);
            Map<Integer, Set<Node>> bwMap = bkwLabel.get(go);
            if (fwMap == null || bwMap == null) continue;
            for (Integer d1 : fwMap.keySet()) {
                for (Node source : fwMap.get(d1)) {
                    for (Integer d2 : bwMap.keySet()) {
                        if (d1 + d2 > this.limit) continue;
                        for (Node target : bwMap.get(d2)) {
                            if (this.ignoreSelfLoops && source.equals(target)) continue;
                            if (this.considerAllPairs) {
                                if (!this.shortestPairLengths.containsKey(source)) {
                                    this.shortestPairLengths.put(source, new HashMap());
                                }
                                if (this.shortestPairLengths.get(source).containsKey(target) && this.shortestPairLengths.get(source).get(target) <= d1 + d2) continue;
                                this.shortestPairLengths.get(source).put(target, d1 + d2);
                                continue;
                            }
                            if (!this.shortestSingleLengths.containsKey(source) || this.shortestSingleLengths.get(source) > d1 + d2) {
                                this.shortestSingleLengths.put(source, d1 + d2);
                            }
                            if (this.shortestSingleLengths.containsKey(target) && this.shortestSingleLengths.get(target) <= d1 + d2) continue;
                            this.shortestSingleLengths.put(target, d1 + d2);
                        }
                    }
                }
            }
        }
    }
}

