/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;
import org.gvt.action.GetNeighborhoodOfSelectedEntityAction;
import org.gvt.action.QueryNeighborsAction;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.EntityHolder;
import org.patika.mada.dataXML.Reference;
import org.patika.mada.dataXML.Row;
import org.patika.mada.gui.ExperimentValuesTableModel;
import org.patika.mada.util.ExperimentDataManager;
import org.patika.mada.util.XRef;

public class ExperimentDataVisualizationDialog
extends Dialog
implements SelectionListener {
    Shell shell;
    ChisioMain main;
    ExperimentDataManager man;
    List<Row> display;
    List<Row> page;
    List<String> data;
    Map<String, Row> dataToRow;
    int pageSize;
    int pageNo;
    Table table;
    ScrolledComposite tableScroll;
    ExperimentValuesTableModel model;
    Text filterField;
    Button filterButton;
    Button nextButton;
    Button backButton;
    Label pageLabel;
    Button queryButton;
    Combo queryTypeBox;
    Combo pageSizeComboBox;
    Button sortCheckBox;

    public ExperimentDataVisualizationDialog(ChisioMain main, ExperimentDataManager man) {
        super(main.getShell(), 0);
        this.main = main;
        this.man = man;
    }

    public void open() {
        this.createContents();
        this.shell.open();
        this.shell.pack();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText("Values");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        int width = Math.max(620, 100 + this.man.getExperimentSize() * 60);
        width = Math.min(width, 1200);
        this.shell.setSize(width, 600);
        this.shell.setLayout(new GridLayout(1, false));
        Composite upperPanel = new Composite(this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.fill = true;
        rowLayout.justify = true;
        upperPanel.setLayout(rowLayout);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        upperPanel.setLayoutData(data);
        Group filterPanel = new Group(upperPanel, 0);
        filterPanel.setText("Filter rows");
        filterPanel.setLayout(new RowLayout());
        this.filterField = new Text(filterPanel, 2048);
        this.filterField.setTextLimit(30);
        this.filterField.setLayoutData(new RowData(80, 17));
        this.filterButton = new Button(filterPanel, 8);
        this.filterButton.setText("Filter");
        this.filterButton.addSelectionListener(this);
        Group pageSizePanel = new Group(upperPanel, 0);
        pageSizePanel.setText("Page size");
        pageSizePanel.setLayout(new RowLayout());
        this.pageSizeComboBox = new Combo(pageSizePanel, 0);
        this.pageSizeComboBox.setItems(new String[]{"20", "40", "60", "100", "All"});
        this.pageSizeComboBox.setText(this.pageSizeComboBox.getItem(1));
        this.pageSize = 40;
        this.pageSizeComboBox.addSelectionListener(this);
        Group sortPanel = new Group(upperPanel, 0);
        sortPanel.setText("Sort");
        sortPanel.setLayout(new GridLayout(1, false));
        this.sortCheckBox = new Button(sortPanel, 32);
        this.sortCheckBox.setText("Show values sorted in page");
        this.sortCheckBox.addSelectionListener(this);
        data = new GridData();
        data.horizontalIndent = 5;
        this.sortCheckBox.setLayoutData(data);
        Group valuesPanel = new Group(this.shell, 0);
        valuesPanel.setText("Values");
        data = new GridData(1808);
        valuesPanel.setLayoutData(data);
        valuesPanel.setLayout(new GridLayout(2, false));
        Composite navigationPanel = new Composite(valuesPanel, 0);
        navigationPanel.setLayout(new GridLayout(3, false));
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        navigationPanel.setLayoutData(data);
        this.backButton = new Button(navigationPanel, 0);
        this.backButton.setText("<< prev");
        this.pageLabel = new Label(navigationPanel, 0);
        data = new GridData(64, 4, false, false, 1, 1);
        data.minimumWidth = 95;
        this.pageLabel.setLayoutData(data);
        this.nextButton = new Button(navigationPanel, 0);
        this.nextButton.setText("next >>");
        this.backButton.addSelectionListener(this);
        this.nextButton.addSelectionListener(this);
        Composite queryPanel = new Composite(valuesPanel, 0);
        queryPanel.setLayout(new RowLayout());
        this.queryButton = new Button(queryPanel, 0);
        this.queryButton.setText("Retrieve");
        this.queryButton.setToolTipText("Retrieve selected to graph");
        this.queryButton.addSelectionListener(this);
        this.queryTypeBox = new Combo(queryPanel, 0);
        this.queryTypeBox.setItems(new String[]{"Neighbors in File", "Neighbors in Database"});
        this.tableScroll = new ScrolledComposite(valuesPanel, 0);
        this.model = new ExperimentValuesTableModel(this.man);
        this.tableScroll.setExpandHorizontal(true);
        this.tableScroll.setExpandVertical(true);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.tableScroll.setLayoutData(data);
        this.tableScroll.setLayout(new GridLayout(1, true));
        this.initRowData();
        this.filter();
    }

    private void initRowData() {
        this.data = new ArrayList<String>();
        this.dataToRow = new HashMap<String, Row>();
        for (Object o : this.man.getCed().getRow()) {
            Row row = (Row)o;
            String d = "";
            for (Object ref : row.getRef()) {
                d = d + new XRef((Reference)ref).toString() + " ";
            }
            d = d.trim();
            d = d.toLowerCase();
            this.data.add(d);
            this.dataToRow.put(d, row);
        }
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.filterButton) {
            this.filter();
        } else if (source == this.pageSizeComboBox) {
            this.updatePageSize();
        } else if (source == this.sortCheckBox) {
            this.updatePage();
        } else if (source == this.backButton) {
            --this.pageNo;
            this.updatePage();
        } else if (source == this.nextButton) {
            ++this.pageNo;
            this.updatePage();
        } else if (source == this.queryButton) {
            List<XRef> refs = this.model.getSelectedReferences(this.table.getSelectionIndices());
            if (!refs.isEmpty()) {
                int selection = this.queryTypeBox.getSelectionIndex();
                switch (selection) {
                    case 0: {
                        if (this.main.getBioPAXModel() != null) {
                            Set<EntityHolder> entities = BioPAXUtil.getRelatedEntities(this.main.getBioPAXModel(), refs);
                            if (entities.isEmpty()) {
                                MessageDialog.openInformation(this.main.getShell(), "Not found", "Selected entities are not found in the current model.");
                                break;
                            }
                            new GetNeighborhoodOfSelectedEntityAction(this.main, entities).run();
                            break;
                        }
                        MessageDialog.openInformation(this.main.getShell(), "No BioPAX model", "There is no current loaded BioPAX model.");
                        break;
                    }
                    case 1: {
                        new QueryNeighborsAction(this.main, refs).run();
                    }
                }
            } else {
                MessageDialog.openError(this.shell, "Error!", "You must select one CPATH or UNIPROT reference.");
            }
        }
    }

    private void updatePageSize() {
        String pageSizeString = this.pageSizeComboBox.getText();
        int newSize = pageSizeString.equals("All") ? -1 : Integer.parseInt(pageSizeString);
        this.pageNo = newSize > 0 && this.pageSize > 0 ? this.pageSize * this.pageNo / newSize : 0;
        this.pageSize = newSize;
        this.updatePage();
    }

    private void filter() {
        if (this.display == null) {
            this.display = new ArrayList<Row>();
        } else {
            this.display.clear();
        }
        List<String> params = this.getFilterParams();
        if (params.isEmpty()) {
            this.display.addAll(this.man.getCed().getRow());
        } else {
            block0: for (String d : this.data) {
                for (String p : params) {
                    if (d.indexOf(p) < 0) continue;
                    Row row = this.dataToRow.get(d);
                    this.display.add(row);
                    continue block0;
                }
            }
        }
        this.pageNo = 0;
        this.updatePage();
    }

    private void updatePage() {
        int totalPages;
        if (this.page == null) {
            this.page = new ArrayList<Row>();
        } else {
            this.page.clear();
        }
        if (this.pageSize < 0) {
            this.page.addAll(this.display);
            totalPages = 1;
            this.pageNo = 0;
        } else {
            int size = this.display.size();
            int start = this.pageSize * this.pageNo;
            int end = start + this.pageSize - 1;
            if (size != 0) {
                assert (start < size);
                int i = 0;
                for (Row row : this.display) {
                    if (i >= start && i <= end) {
                        this.page.add(row);
                    }
                    ++i;
                }
            }
            totalPages = (int)Math.ceil((double)size / (double)this.pageSize);
        }
        this.model.updateRows(this.page);
        if (this.sortCheckBox.getSelection()) {
            this.model.sort(this.model.getValueIndex());
        }
        this.updatePageLabel(this.pageNo + 1, totalPages);
        this.backButton.setEnabled(this.pageNo > 0);
        this.nextButton.setEnabled(this.pageNo < totalPages - 1);
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        this.createTable(this.tableScroll);
        this.tableScroll.setContent(this.table);
        this.shell.pack();
    }

    private void updatePageLabel(int pageNo, int totalPages) {
        if (totalPages < 2) {
            this.pageLabel.setText("");
        } else {
            String lbl = "page " + pageNo + " of " + totalPages;
            if (totalPages >= 1000 && pageNo < 1000) {
                lbl = " " + lbl + " ";
            }
            if (totalPages >= 100 && pageNo < 100) {
                lbl = " " + lbl + " ";
            }
            if (totalPages >= 10 && pageNo < 10) {
                lbl = " " + lbl + " ";
            }
            this.pageLabel.setText(lbl);
        }
    }

    private List<String> getFilterParams() {
        String t = this.filterField.getText();
        t = t.toLowerCase();
        String[] array = t.split(" or ");
        ArrayList<String> params = new ArrayList<String>();
        for (String s : array) {
            if ((s = s.trim()).length() <= 1) continue;
            params.add(s);
        }
        return params;
    }

    public void createTable(Composite c) {
        this.table = new Table(c, 68354);
        GridData data = new GridData(1810);
        this.table.setLayoutData(data);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener(this);
        this.createColumns();
        this.createViewer();
        this.colorColumns();
    }

    private void createColumns() {
        String[] columnNames = this.model.getColumnNames();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableColumn column = new TableColumn(this.table, 16384, i);
            column.setText(columnNames[i]);
            column.setWidth(i == 0 ? 150 : 55);
        }
    }

    private void createViewer() {
        TableViewer viewer = new TableViewer(this.table);
        viewer.setUseHashlookup(true);
        String[] columnNames = this.model.getColumnNames();
        viewer.setColumnProperties(columnNames);
        CellEditor[] editors = new CellEditor[columnNames.length];
        for (int i = 0; i < editors.length; ++i) {
            TextCellEditor textEditor = new TextCellEditor(this.table);
            editors[i] = textEditor;
        }
        viewer.setCellEditors(editors);
        viewer.setCellModifier(new CellModifier());
        viewer.setContentProvider(new ContentProvider());
        viewer.setLabelProvider(new LabelProvider());
        viewer.setInput(this.model.getDisplayArray());
    }

    private void colorColumns() {
        for (TableItem item : this.table.getItems()) {
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                item.setBackground(i, this.model.getColumnColor(i));
            }
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        @Override
        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isLabelProperty(Object o, String s) {
            return false;
        }

        @Override
        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }

        @Override
        public Image getColumnImage(Object o, int i) {
            return null;
        }

        @Override
        public String getColumnText(Object o, int i) {
            return ExperimentDataVisualizationDialog.this.model.getValueAt(ExperimentDataVisualizationDialog.this.model.getRowIndex((Row)o), i).toString();
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object o, Object o1) {
        }

        @Override
        public Object[] getElements(Object o) {
            return ExperimentDataVisualizationDialog.this.model.getDisplayArray();
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        @Override
        public boolean canModify(Object o, String s) {
            return false;
        }

        @Override
        public Object getValue(Object o, String s) {
            return null;
        }

        @Override
        public void modify(Object o, String s, Object o1) {
        }
    }
}

