/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cbio.causality.util.Download;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.util.Conf;

public class FetchFromGEODialog
extends Dialog {
    ChisioMain main;
    Shell shell;
    private Label seriesIDLabel;
    private Text seriesIDText;
    private Label savedSeriesLabel;
    private org.eclipse.swt.widgets.List savedSeriesList;
    private Button fetchButton;
    private Button cancelButton;
    private boolean fetchPressed;
    public static File directory = new File(Conf.getExperimentsDir());
    private File seriesDirectory;
    private String selectedSeries;
    private File cedFile;
    private boolean cedPresent;
    private File seriesMatrixFile;
    private File platformFile;
    private String[] savedSeriesNames = directory.list();

    public FetchFromGEODialog(ChisioMain main) {
        super(main.getShell(), 0);
        this.main = main;
        this.fetchPressed = false;
    }

    public void open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText("Fetch from GEO");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout(gridLayout);
        this.seriesIDLabel = new Label(this.shell, 0);
        this.seriesIDLabel.setText("Enter GEO Series ID (GSExxx)");
        GridData gridData = new GridData(2, 2, false, false);
        gridData.horizontalSpan = 2;
        this.seriesIDLabel.setLayoutData(gridData);
        this.seriesIDText = new Text(this.shell, 2048);
        gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        this.seriesIDText.setLayoutData(gridData);
        this.savedSeriesLabel = new Label(this.shell, 0);
        this.savedSeriesLabel.setText("Or select from previous");
        gridData = new GridData(2, 2, false, false);
        gridData.horizontalSpan = 2;
        this.savedSeriesLabel.setLayoutData(gridData);
        this.savedSeriesList = new org.eclipse.swt.widgets.List(this.shell, 2560);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 75;
        this.savedSeriesList.setLayoutData(gridData);
        ArrayList<String> savedNames = new ArrayList<String>();
        for (String name : this.savedSeriesNames) {
            if (!name.startsWith("GSE")) continue;
            savedNames.add(name);
        }
        this.savedSeriesList.setItems(savedNames.toArray(new String[savedNames.size()]));
        this.savedSeriesList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (FetchFromGEODialog.this.savedSeriesList.getSelection().length > 0) {
                    FetchFromGEODialog.this.seriesIDText.setText(FetchFromGEODialog.this.savedSeriesList.getSelection()[0]);
                }
            }
        });
        this.fetchButton = new Button(this.shell, 0);
        this.fetchButton.setText("Fetch");
        gridData = new GridData(3, 2, true, false);
        this.fetchButton.setLayoutData(gridData);
        this.fetchButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (FetchFromGEODialog.this.main.getBioPAXModel() == null) {
                    MessageDialog.openError(FetchFromGEODialog.this.main.getShell(), "Error!", "No BioPAX model loaded.");
                    return;
                }
                if (!FetchFromGEODialog.this.seriesIDText.getText().startsWith("GSE")) {
                    MessageDialog.openWarning(FetchFromGEODialog.this.main.getShell(), "Invalid input!", "Enter a valid series ID!");
                    return;
                }
                FetchFromGEODialog.this.selectedSeries = FetchFromGEODialog.this.seriesIDText.getText();
                if (FetchFromGEODialog.this.fetchAction()) {
                    FetchFromGEODialog.this.shell.close();
                }
            }
        });
        this.cancelButton = new Button(this.shell, 0);
        this.cancelButton.setText("Cancel");
        gridData = new GridData(1, 2, true, false);
        this.cancelButton.setLayoutData(gridData);
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                FetchFromGEODialog.this.shell.close();
            }
        });
    }

    private boolean fetchAction() {
        File[] fileList;
        assert (this.selectedSeries != null);
        if (!this.createDataDirectory(this.selectedSeries)) {
            return false;
        }
        for (File file : fileList = this.seriesDirectory.listFiles()) {
            if (!file.getName().endsWith(".ced")) continue;
            this.cedFile = file;
            this.cedPresent = true;
            this.fetchPressed = true;
            return true;
        }
        this.seriesMatrixFile = new File(this.seriesDirectory, this.selectedSeries);
        if (!this.seriesMatrixFile.exists()) {
            this.main.lockWithMessage("Downloading series matrix file ...");
            if (!this.findSeriesMatrixFile(this.selectedSeries)) {
                return false;
            }
            this.main.unlock();
        }
        if (this.seriesMatrixFile.exists()) {
            this.main.lockWithMessage("Downloading platform file ...");
            this.platformFile = this.findPlatformFile();
            if (this.platformFile.exists()) {
                this.fetchPressed = true;
            }
            this.main.unlock();
        }
        return true;
    }

    public boolean isFetchPressed() {
        return this.fetchPressed;
    }

    public boolean isCedPresent() {
        return this.cedPresent;
    }

    public String getSelectedSeries() {
        return this.selectedSeries;
    }

    public File getSeriesMatrixFile() {
        return this.seriesMatrixFile;
    }

    public File getPlatformFile() {
        return this.platformFile;
    }

    public File getCedFile() {
        return this.cedFile;
    }

    private boolean createDataDirectory(String selectedSeries) {
        List<String> plat;
        File seriesDirectory = new File(directory, selectedSeries);
        File dataFile = new File(seriesDirectory, selectedSeries);
        if (dataFile.exists()) {
            this.seriesDirectory = seriesDirectory;
            this.selectedSeries = selectedSeries;
            return true;
        }
        String givenPlat = null;
        if (selectedSeries.contains("-")) {
            String series = selectedSeries.substring(0, selectedSeries.indexOf("-"));
            givenPlat = selectedSeries.substring(selectedSeries.indexOf("-") + 1);
            seriesDirectory = new File(directory, series);
            dataFile = new File(seriesDirectory, series);
            if (dataFile.exists()) {
                this.seriesDirectory = seriesDirectory;
                this.selectedSeries = series;
                return true;
            }
        }
        if ((plat = this.getMultiplePlatforms(selectedSeries)).size() < 2) {
            String series = selectedSeries.contains("-") ? selectedSeries.substring(0, selectedSeries.indexOf("-")) : selectedSeries;
            this.seriesDirectory = new File(directory, series);
            this.seriesDirectory.mkdir();
            this.selectedSeries = series;
            return true;
        }
        String platform = this.selectPlatform(plat, givenPlat != null && !plat.contains(givenPlat) ? givenPlat : null);
        if (platform == null) {
            return false;
        }
        String series = selectedSeries.contains("-") ? selectedSeries.substring(0, selectedSeries.indexOf("-")) : selectedSeries;
        series = series + "-" + platform;
        this.seriesDirectory = new File(directory, series);
        this.seriesDirectory.mkdir();
        this.selectedSeries = series;
        return true;
    }

    private boolean findSeriesMatrixFile(String selectedSeries) {
        String ftpPrefix = "ftp://ftp.ncbi.nih.gov/pub/geo/DATA/SeriesMatrix/";
        String platName = null;
        if (selectedSeries.contains("-")) {
            platName = selectedSeries.substring(selectedSeries.indexOf("-") + 1);
            selectedSeries = selectedSeries.substring(0, selectedSeries.indexOf("-"));
        }
        if (platName != null) {
            this.platformFile = new File(directory, platName);
        }
        try {
            String url = platName == null ? ftpPrefix + selectedSeries + "/" + selectedSeries + "_series_matrix.txt.gz" : ftpPrefix + selectedSeries + "/" + selectedSeries + "-" + platName + "_series_matrix.txt.gz";
            if (!Download.downloadAndUncompress(url, this.seriesMatrixFile.getPath())) {
                String u;
                url = url.substring(0, url.lastIndexOf("ix") + 2);
                int i = 0;
                while (Download.downloadAndUncompress(u = url + "-" + ++i + ".txt.gz", this.seriesMatrixFile.getPath() + "-" + i)) {
                }
                this.uniteSeriesFiles(i - 1);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openWarning(this.main.getShell(), "Download failed!", "ChiBE could not download the file. Check your parameters.");
            return false;
        }
    }

    private void uniteSeriesFiles(int count) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.seriesMatrixFile.getPath()));
            BufferedReader rdr = new BufferedReader(new FileReader(this.seriesMatrixFile.getPath() + "-1"));
            String line = rdr.readLine();
            while (line != null && line.startsWith("!Series")) {
                writer.write(line + "\n");
                line = rdr.readLine();
            }
            rdr.close();
            BufferedReader[] reader = new BufferedReader[count];
            for (int i = 0; i < count; ++i) {
                reader[i] = new BufferedReader(new FileReader(this.seriesMatrixFile.getPath() + "-" + (i + 1)));
            }
            Object line2 = reader[0].readLine();
            while (line2 != null) {
                if (!((String)line2).contains("\t")) {
                    writer.write((String)line2 + "\n");
                    for (int j = 1; j < reader.length; ++j) {
                        reader[j].readLine();
                    }
                } else {
                    String id = ((String)line2).substring(0, ((String)line2).indexOf("\t"));
                    writer.write((String)line2);
                    for (int j = 1; j < reader.length; ++j) {
                        line2 = reader[j].readLine();
                        assert (id.equals(((String)line2).substring(0, ((String)line2).indexOf("\t"))));
                        writer.write(((String)line2).substring(((String)line2).indexOf("\t")));
                    }
                    writer.write("\n");
                }
                line2 = reader[0].readLine();
            }
            for (BufferedReader r : reader) {
                r.close();
            }
            writer.close();
            for (int i = 0; i < count; ++i) {
                new File(this.seriesMatrixFile.getPath() + "-" + (i + 1)).delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> getMultiplePlatforms(String series) {
        if (series.contains("-")) {
            series = series.substring(0, series.indexOf("-"));
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            String[] files = Download.listFtpFiles("ftp://ftp.ncbi.nih.gov/pub/geo/DATA/SeriesMatrix/" + series + "/");
            if (files.length > 1) {
                for (String file : files) {
                    String pl;
                    String id = file.substring(0, file.indexOf("_s"));
                    if (!file.contains("-") || list.contains(pl = id.substring(id.indexOf("-") + 1))) continue;
                    list.add(pl);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private String selectPlatform(List<String> platforms) {
        return this.selectPlatform(platforms, null);
    }

    private String selectPlatform(List<String> platforms, String wrongPlat) {
        String message = "Series contain more than one platform." + (wrongPlat == null ? "" : "\nAnd " + wrongPlat + " is not an option.") + "\nPlease select one below.";
        ItemSelectionDialog d = new ItemSelectionDialog(this.shell, 200, "Select platform", message, platforms, null, false, true, null);
        Object selected = d.open();
        if (selected != null) {
            return selected.toString();
        }
        return null;
    }

    public File findPlatformFile() {
        try {
            if (this.platformFile == null) {
                String currentLine;
                BufferedReader br = new BufferedReader(new FileReader(this.seriesMatrixFile));
                String platformName = "";
                while ((currentLine = br.readLine()) != null) {
                    if (!currentLine.contains("!Series_platform_id")) continue;
                    platformName = currentLine.substring(currentLine.indexOf("G"), currentLine.lastIndexOf("\""));
                    break;
                }
                this.platformFile = new File(directory, platformName);
            }
            if (!this.platformFile.exists()) {
                String URLname = "http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?targ=self&form=text&view=data&acc=" + this.platformFile.getName();
                Download.downlaodTextFile(URLname, this.platformFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openWarning(this.main.getShell(), "Download failed!", "ChiBE could not download the file. Check your parameters.");
        }
        return this.platformFile;
    }

    static {
        if (!directory.exists()) {
            directory.mkdir();
        }
    }
}

