/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.patika.mada.gui.ExperimentDataConvertionWizard;
import org.patika.mada.gui.FileTable;
import org.patika.mada.gui.KeyValueSpecificationPage;
import org.patika.mada.gui.NonePlatformMappingPage;
import org.patika.mada.gui.PatikaWizardPage;

public class MultipleDataFileLoadPage
extends PatikaWizardPage
implements ActionListener {
    ExperimentDataConvertionWizard mdcw;
    private ArrayList loadedFiles;
    private TitledBorder mainTitledBorder;
    private JPanel filePanel;
    private FileTable fileTable;
    JScrollPane scrollPane;
    private JPanel buttonsPanel;
    private JButton addButton;
    private JButton removeButton;

    public MultipleDataFileLoadPage(ExperimentDataConvertionWizard mdcw) {
        super(mdcw);
        this.mdcw = mdcw;
        this.loadedFiles = new ArrayList();
        this.setSize(new Dimension(489, 260));
        this.setLayout(new BorderLayout(10, 10));
        this.mainTitledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Multiple data file loading ");
        this.setBorder(this.mainTitledBorder);
        this.filePanel = new JPanel();
        this.filePanel.setLayout(new BorderLayout());
        this.filePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Loaded files "));
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("Remove Selected(s)");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        this.buttonsPanel.add(this.addButton);
        this.buttonsPanel.add(this.removeButton);
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.buttonsPanel, "North");
        this.add((Component)this.filePanel, "Center");
    }

    @Override
    void reset() {
    }

    @Override
    void update() {
    }

    @Override
    public boolean canNext() {
        if (this.fileTable == null) {
            return false;
        }
        return this.fileTable.getRowCount() >= 1;
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    public ArrayList getLoadedFiles() {
        return this.loadedFiles;
    }

    public FileTable getFileTable() {
        return this.fileTable;
    }

    public Vector<String> getColumns(File dataFile) {
        Vector<String> columns = new Vector<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(dataFile));
            while ((line = br.readLine()) != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line)) {
            }
            StringTokenizer tokenizer = new StringTokenizer(line, "\t");
            while (tokenizer.hasMoreTokens()) {
                columns.add(tokenizer.nextToken());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public ArrayList<String> getColumnList() {
        return new ArrayList<String>(this.getColumns((File)this.loadedFiles.get(0)));
    }

    private boolean validateFiles() {
        int i;
        boolean areValid = true;
        ArrayList<Vector<String>> columnOfFiles = new ArrayList<Vector<String>>();
        for (i = 0; i < this.loadedFiles.size(); ++i) {
            columnOfFiles.add(this.getColumns((File)this.loadedFiles.get(i)));
        }
        for (i = 0; i < this.getLoadedFiles().size() - 1 && areValid; areValid &= ((Vector)columnOfFiles.get(i)).size() == ((Vector)columnOfFiles.get(i + 1)).size(), ++i) {
        }
        return areValid;
    }

    private boolean isFileAdded(File newFile) {
        boolean result = false;
        for (File f : this.loadedFiles) {
            if (!f.getAbsolutePath().equals(newFile.getAbsolutePath())) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isFileValid(File f) {
        BufferedReader br;
        String line = "";
        try {
            FileReader fr = new FileReader(f);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        do {
            try {
                line = br.readLine();
                for (int i = 0; line != null && i < line.length(); ++i) {
                    if (line.charAt(i) <= '\u007f') continue;
                    throw new IOException();
                }
            }
            catch (IOException e) {
                return false;
            }
        } while (line != null);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal = 1;
        ArrayList<File> alreadyAddedFiles = new ArrayList<File>();
        ArrayList<File> invalidFiles = new ArrayList<File>();
        ArrayList<File> filesTobeAdded = new ArrayList<File>();
        if (e.getSource().equals(this.addButton)) {
            JFileChooser chooser = new JFileChooser();
            if (ExperimentDataConvertionWizard.recentDir != null) {
                chooser.setCurrentDirectory(ExperimentDataConvertionWizard.recentDir);
            }
            chooser.setMultiSelectionEnabled(true);
            returnVal = chooser.showOpenDialog(this.mdcw);
            if (returnVal == 0) {
                int i;
                File[] files = chooser.getSelectedFiles();
                ExperimentDataConvertionWizard.recentDir = files[0].getParentFile();
                for (i = 0; i < files.length; ++i) {
                    if (!this.isFileAdded(files[i])) {
                        if (this.isFileValid(files[i])) {
                            this.loadedFiles.add(files[i]);
                            filesTobeAdded.add(files[i]);
                            continue;
                        }
                        invalidFiles.add(files[i]);
                        continue;
                    }
                    alreadyAddedFiles.add(files[i]);
                }
                if (!this.validateFiles()) {
                    JOptionPane.showMessageDialog(this.mdcw, "Loaded files are invalid, they must contain the same number of column(s)! ", "Invalid Selection", 0);
                    for (i = 0; i < files.length; ++i) {
                        this.loadedFiles.remove(files[i]);
                    }
                } else {
                    String massage = "The below file(s) contain non-ASCII characters and are not loaded: \n";
                    Iterator invalidFileIter = invalidFiles.iterator();
                    while (invalidFileIter.hasNext()) {
                        massage = massage + ((File)invalidFileIter.next()).getName() + "\n";
                    }
                    if (invalidFiles.size() != 0) {
                        JOptionPane.showMessageDialog(this.mdcw, massage, null, 0);
                    }
                    massage = "The below file(s) are already loaded: \n";
                    Iterator alreadyAddedIter = alreadyAddedFiles.iterator();
                    while (alreadyAddedIter.hasNext()) {
                        massage = massage + ((File)alreadyAddedIter.next()).getName() + "\n";
                    }
                    if (alreadyAddedFiles.size() != 0) {
                        JOptionPane.showMessageDialog(this.mdcw, massage, null, 0);
                    }
                    if (filesTobeAdded.size() > 0) {
                        if (this.fileTable == null) {
                            this.fileTable = new FileTable((File)filesTobeAdded.get(0));
                            this.scrollPane = new JScrollPane(this.fileTable);
                            for (int i2 = 1; i2 < filesTobeAdded.size(); ++i2) {
                                this.fileTable.addRow((File)filesTobeAdded.get(i2));
                            }
                            this.filePanel.add(this.scrollPane);
                            this.filePanel.validate();
                            this.validate();
                        } else {
                            for (int i3 = 0; i3 < filesTobeAdded.size(); ++i3) {
                                this.fileTable.addRow((File)filesTobeAdded.get(i3));
                            }
                            this.filePanel.validate();
                            this.validate();
                        }
                    }
                    this.removeButton.setEnabled(true);
                }
            }
        } else {
            int i = 0;
            while (i < this.fileTable.getRowCount()) {
                if (((Boolean)this.fileTable.getValueAt(i, 2)).booleanValue()) {
                    this.fileTable.removeRow(i);
                    this.loadedFiles.remove(i);
                    i = 0;
                    continue;
                }
                ++i;
            }
            this.fileTable.revalidate();
            this.revalidate();
            for (i = 0; i < this.fileTable.getRowCount(); ++i) {
                this.fileTable.setValueAt(new Integer(i + 1), i, 0);
            }
            if (this.fileTable.getRowCount() == 0) {
                this.removeButton.setEnabled(false);
                this.repaint();
            }
        }
        if (this.fileTable != null && returnVal == 0 && this.fileTable.getRowCount() >= 1) {
            if (this.mdcw.hasPlatformFile()) {
                ((KeyValueSpecificationPage)this.mdcw.pages[3]).init();
            } else {
                ((NonePlatformMappingPage)this.mdcw.pages[2]).init();
            }
        }
        this.mdcw.checkButtons();
    }
}

