/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.level2.xref;
import org.biopax.paxtools.model.level3.Xref;
import org.patika.mada.dataXML.Reference;

public class XRef {
    private String db;
    private String ref;
    private static Set<String> dbSet = new HashSet<String>();
    public static final String SEPARATOR = ":";
    public static final String CPATH = "CPATH";
    public static final String UNIPROT = "UNIPROT";
    public static final String ENTREZ_GENE = "ENTREZ_GENE";

    public XRef(String db, String ref) {
        this.db = db;
        this.ref = ref;
        XRef.registerDB(db);
    }

    public XRef(xref r) {
        this(r.getDB(), r.getID());
    }

    public XRef(Xref r) {
        this(r.getDb(), r.getId());
    }

    public XRef(Reference r) {
        this.db = r.getDb();
        this.ref = r.getValue();
    }

    public XRef(String s) {
        int sepLoc = s.indexOf(SEPARATOR);
        assert (sepLoc > 0 && sepLoc < s.length() - 1) : "s: " + s;
        this.db = s.substring(0, sepLoc);
        this.ref = s.substring(sepLoc + 1);
    }

    public String getDb() {
        return this.db;
    }

    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XRef) {
            XRef x = (XRef)obj;
            return this.toString().equals(x.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.db + SEPARATOR + this.ref;
    }

    public static Set<String> getDBSet() {
        return dbSet;
    }

    public static void clearDBSet() {
        dbSet.clear();
    }

    public static void registerDB(String db) {
        dbSet.add(db);
    }

    public static XRef getFirstRef(Collection<XRef> refs, String db) {
        for (XRef ref : refs) {
            if (db != null && !ref.getDb().equalsIgnoreCase(db)) continue;
            return ref;
        }
        return null;
    }

    public static XRef getFirstRef(Collection<XRef> refs, String[] db_priority) {
        for (String db : db_priority) {
            XRef ref = XRef.getFirstRef(refs, db);
            if (ref == null) continue;
            return ref;
        }
        return null;
    }
}

