/*
 * Decompiled with CFR 0.152.
 */
package cpath.client;

import cpath.client.util.BioPAXHttpMessageConverter;
import cpath.client.util.CPathException;
import cpath.client.util.ServiceResponseHttpMessageConverter;
import cpath.query.CPathGetQuery;
import cpath.query.CPathGraphQuery;
import cpath.query.CPathSearchQuery;
import cpath.query.CPathTopPathwaysQuery;
import cpath.query.CPathTraverseQuery;
import cpath.service.jaxb.Help;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class CPathClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPathClient.class);
    public static final String JVM_PROPERTY_ENDPOINT_URL = "cPath2Url";
    public static final String DEFAULT_ENDPOINT_URL = "http://www.pathwaycommons.org/pc2/";
    private RestTemplate restTemplate;
    private String endPointURL;
    private String name;

    private CPathClient() {
    }

    public static CPathClient newInstance() {
        return CPathClient.newInstance(null);
    }

    public static CPathClient newInstance(String url) {
        CPathClient client = new CPathClient();
        client.restTemplate = new RestTemplate();
        client.restTemplate.getMessageConverters().add(0, new ServiceResponseHttpMessageConverter());
        client.restTemplate.getMessageConverters().add(1, new BioPAXHttpMessageConverter(new SimpleIOHandler()));
        client.endPointURL = url == null || url.isEmpty() ? System.getProperty(JVM_PROPERTY_ENDPOINT_URL, DEFAULT_ENDPOINT_URL) : url;
        return client;
    }

    public <T> T post(String requestPath, MultiValueMap<String, String> requestParams, Class<T> responseType) throws CPathException {
        String url = this.endPointURL + requestPath;
        if (this.name != null && requestParams != null) {
            requestParams.put("client", (String)((Object)Collections.singletonList(this.name)));
        }
        try {
            return this.restTemplate.postForObject(url, requestParams, responseType, new Object[0]);
        }
        catch (RestClientException e) {
            throw new CPathException(url + " and " + requestParams, e);
        }
    }

    public <T> T get(String requestPath, MultiValueMap<String, String> requestParams, Class<T> responseType) throws CPathException {
        StringBuilder sb = new StringBuilder(this.endPointURL);
        sb.append(requestPath);
        if (requestParams != null) {
            sb.append("?");
            for (Map.Entry entry : requestParams.entrySet()) {
                String params = this.join((String)entry.getKey() + "=", (Collection)entry.getValue(), "&");
                sb.append(params).append("&");
            }
            if (this.name != null) {
                sb.append("client=").append(this.name);
            }
        }
        String url = sb.toString();
        try {
            return this.restTemplate.getForObject(url, responseType, new Object[0]);
        }
        catch (UnknownHttpStatusCodeException e) {
            if (e.getRawStatusCode() == 460) {
                return null;
            }
            throw new CPathException(url, e);
        }
        catch (RestClientException e) {
            throw new CPathException(url, e);
        }
    }

    public Help executeHelp(String hpath) throws CPathException {
        return this.get("help/" + (hpath != null ? hpath : ""), null, Help.class);
    }

    private String join(String prefix, Collection<String> strings, String delimiter) {
        ArrayList<String> prefixed = new ArrayList<String>();
        for (String s : strings) {
            prefixed.add(prefix + s);
        }
        return StringUtils.join(prefixed, delimiter);
    }

    public String getEndPointURL() {
        return this.endPointURL;
    }

    public String getActualEndPointURL() {
        return this.endPointURL;
    }

    public void setEndPointUrlAndRedirect(String url) {
        this.endPointURL = url;
    }

    public CPathSearchQuery createSearchQuery() {
        return new CPathSearchQuery(this);
    }

    public CPathTraverseQuery createTraverseQuery() {
        return new CPathTraverseQuery(this);
    }

    public CPathGraphQuery createGraphQuery() {
        return new CPathGraphQuery(this);
    }

    public CPathGetQuery createGetQuery() {
        return new CPathGetQuery(this);
    }

    public CPathTopPathwaysQuery createTopPathwaysQuery() {
        return new CPathTopPathwaysQuery(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    public static enum Direction {
        UPSTREAM,
        DOWNSTREAM,
        BOTHSTREAM,
        UNDIRECTED;

    }
}

