/*
 * Decompiled with CFR 0.152.
 */
package cpath.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;

public class PathwayCommonsIOHandler {
    private final BioPAXIOHandler ioHandler;
    Merger merger;
    public static final String default_prefix = "http://www.pathwaycommons.org/pc/webservice.do?";
    public static final String default_output_format = "biopax";
    public static final String version = "version=";
    public static final String command = "cmd=";
    public static final String input_id_type = "input_id_type=";
    public static final String output_id_type = "output_id_type=";
    public static final String data_source = "data_source=";
    public static final String output = "output=";
    public static final String default_version = "2.0";
    private String prefix = "http://www.pathwaycommons.org/pc/webservice.do?";
    private final String output_format = "biopax";
    private final String versionID = "2.0";
    private ID_TYPE inputIdType = ID_TYPE.DEFAULT;
    private ID_TYPE outputIdType = ID_TYPE.DEFAULT;
    private DATA_SRC dataSource = DATA_SRC.DEFAULT;

    public PathwayCommonsIOHandler(BioPAXIOHandler ioHandler) {
        this.ioHandler = ioHandler;
    }

    public PathwayCommonsIOHandler() {
        this(new SimpleIOHandler());
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setInputIdType(ID_TYPE newInputIdType) {
        this.inputIdType = newInputIdType;
    }

    public void setOutputIdType(ID_TYPE newOutputIdType) {
        this.outputIdType = newOutputIdType;
    }

    public void setDataSource(DATA_SRC newDataSource) {
        this.dataSource = newDataSource;
    }

    private InputStream openURL(String urlName) throws IOException {
        URL url = new URL(urlName);
        URLConnection urlConnection = url.openConnection();
        return urlConnection.getInputStream();
    }

    private Model readBioPAXfromURL(String urlName) throws IOException {
        return this.ioHandler.convertFromOWL(this.openURL(urlName));
    }

    public Model retrieveByID(String id) throws IOException {
        String urlName = this.prefix + command + "get_record_by_cpath_id&" + version + default_version + "&q=" + id + "&" + output + default_output_format;
        return this.readBioPAXfromURL(urlName);
    }

    public List<List<String>> getPathways(String id) throws IOException {
        String oneLine;
        String urlName = this.prefix + command + "get_pathways&" + version + default_version + "&q=" + id + "&" + output + default_output_format + "&" + input_id_type + this.inputIdType.getTag() + "&" + data_source + this.dataSource.getTag();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.openURL(urlName)));
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        while ((oneLine = reader.readLine()) != null) {
            ArrayList<String> lineArray = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(oneLine, "\t");
            while (tokenizer.hasMoreTokens()) {
                lineArray.add(tokenizer.nextToken());
            }
            if (lineArray.isEmpty()) continue;
            allLines.add(lineArray);
        }
        return allLines;
    }

    public Model getNeighbors(String id) throws IOException {
        String urlName = this.prefix + command + "get_neighbors&" + version + default_version + "&q=" + id + "&" + output + default_output_format + "&" + input_id_type + this.inputIdType.getTag() + "&" + output_id_type + this.outputIdType.getTag() + "&" + data_source + this.dataSource.getTag();
        return this.readBioPAXfromURL(urlName);
    }

    public static enum DATA_SRC {
        DEFAULT(""),
        CELL_MAP("CELL_MAP"),
        HUMANCYC("HUMANCYC"),
        NCI_NATURE("NCI_NATURE"),
        BIOGRID("BIOGRID"),
        HPRD("HPRD"),
        IMID("IMID"),
        INTACT("INTACT"),
        MINT("MINT"),
        REACTOME("REACTOME");

        private final String tag;

        private DATA_SRC(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static enum ID_TYPE {
        DEFAULT("CPATH_ID"),
        UNIPROT("UNIPROT"),
        CPATH_ID("CPATH_ID"),
        ENTREZ_GENE("ENTREZ_GENE"),
        GENE_SYMBOL("GENE_SYMBOL");

        private final String tag;

        private ID_TYPE(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

