/*
 * Decompiled with CFR 0.152.
 */
package cpath.query;

import cpath.client.CPathClient;
import cpath.client.util.CPathException;
import cpath.query.BaseCPathQuery;
import cpath.query.CPathQuery;
import cpath.service.Cmd;
import cpath.service.CmdArgs;
import cpath.service.OutputFormat;
import cpath.service.jaxb.SearchHit;
import cpath.service.jaxb.SearchResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class CPathTopPathwaysQuery
extends BaseCPathQuery<SearchResponse>
implements CPathQuery<SearchResponse> {
    private String[] organism;
    private String[] datasource;
    private String queryString;

    @Override
    protected MultiValueMap<String, String> getRequestParams() {
        LinkedMultiValueMap<String, String> request = new LinkedMultiValueMap<String, String>();
        if (this.queryString != null && !this.queryString.isEmpty()) {
            request.add(CmdArgs.q.name(), this.queryString);
        }
        if (this.organism != null) {
            request.put(CmdArgs.organism.name(), (String)((Object)Arrays.asList(this.organism)));
        }
        if (this.datasource != null) {
            request.put(CmdArgs.datasource.name(), (String)((Object)Arrays.asList(this.datasource)));
        }
        return request;
    }

    public CPathTopPathwaysQuery(CPathClient client) {
        this.client = client;
        this.command = Cmd.TOP_PATHWAYS.toString();
    }

    public CPathTopPathwaysQuery queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public CPathTopPathwaysQuery organismFilter(String[] organisms) {
        this.organism = organisms;
        return this;
    }

    public CPathTopPathwaysQuery datasourceFilter(String[] datasources) {
        this.datasource = datasources;
        return this;
    }

    public CPathTopPathwaysQuery organismFilter(Collection<String> organisms) {
        this.organism = organisms.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    public CPathTopPathwaysQuery datasourceFilter(Collection<String> datasources) {
        this.datasource = datasources.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    @Override
    public String stringResult(OutputFormat outputFormat) throws CPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResponse result() throws CPathException {
        SearchResponse resp = this.client.post(this.command, this.getRequestParams(), SearchResponse.class);
        if (resp != null) {
            Collections.sort(resp.getSearchHit(), new Comparator<SearchHit>(){

                @Override
                public int compare(SearchHit h1, SearchHit h2) {
                    return h1.toString().compareTo(h2.toString());
                }
            });
        }
        return resp;
    }
}

