/*
 * Decompiled with CFR 0.152.
 */
package cpath.query;

import cpath.client.CPathClient;
import cpath.client.util.CPathException;
import cpath.query.BaseCPathQuery;
import cpath.query.CPathQuery;
import cpath.service.Cmd;
import cpath.service.CmdArgs;
import cpath.service.OutputFormat;
import cpath.service.jaxb.TraverseResponse;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class CPathTraverseQuery
extends BaseCPathQuery<TraverseResponse>
implements CPathQuery<TraverseResponse> {
    private String path;
    private String[] source;

    @Override
    protected MultiValueMap<String, String> getRequestParams() {
        LinkedMultiValueMap<String, String> request = new LinkedMultiValueMap<String, String>();
        if (this.source == null || this.source.length == 0) {
            throw new IllegalArgumentException("Required 'source' (URIs) parameter cannot be null or empty.");
        }
        request.put(CmdArgs.uri.name(), (String)((Object)Arrays.asList(this.source)));
        if (this.path == null || this.path.isEmpty()) {
            throw new IllegalArgumentException("Property 'path' is null or empty.");
        }
        request.add(CmdArgs.path.name(), this.path);
        return request;
    }

    public CPathTraverseQuery(CPathClient client) {
        this.client = client;
    }

    public CPathTraverseQuery sources(String[] source) {
        this.source = source;
        return this;
    }

    public CPathTraverseQuery sources(Collection<String> sources) {
        this.source = sources.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    public CPathTraverseQuery propertyPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public String stringResult(OutputFormat outputFormat) throws CPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TraverseResponse result() throws CPathException {
        return this.client.post(Cmd.TRAVERSE.toString(), this.getRequestParams(), TraverseResponse.class);
    }
}

