/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern;

import java.util.Collection;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;

public class MappedConst
implements Constraint {
    private Constraint constr;
    private int[] inds;

    public MappedConst(Constraint constr, int ... inds) {
        this.constr = constr;
        this.inds = inds;
    }

    public Constraint getConstr() {
        return this.constr;
    }

    public int[] getInds() {
        return this.inds;
    }

    public int getMaxInd() {
        int max = -1;
        for (int ind : this.inds) {
            if (ind <= max) continue;
            max = ind;
        }
        return max;
    }

    protected int[] translate(int[] outer) {
        int[] t = new int[this.inds.length];
        for (int i = 0; i < t.length; ++i) {
            t[i] = outer[this.inds[i]];
        }
        return t;
    }

    @Override
    public boolean canGenerate() {
        return this.constr.canGenerate();
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... outer) {
        return this.constr.generate(match, this.translate(outer));
    }

    @Override
    public boolean satisfies(Match match, int ... outer) {
        return this.constr.satisfies(match, this.translate(outer));
    }

    @Override
    public int getVariableSize() {
        return this.constr.getVariableSize();
    }
}

