/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class BlacklistGenerator3 {
    private Map<String, RelType> knownNames = new HashMap<String, RelType>();

    public BlacklistGenerator3(InputStream knownNamesIS) {
        Scanner sc = new Scanner(knownNamesIS);
        while (sc.hasNextLine()) {
            String[] token = sc.nextLine().split("\t");
            RelType type = token.length < 2 ? null : (token[1].equals("I") ? RelType.INPUT : RelType.OUTPUT);
            this.knownNames.put(token[0], type);
        }
    }

    public BlacklistGenerator3() {
        this(BlacklistGenerator3.class.getResourceAsStream("blacklist-names.txt"));
    }

    public Blacklist generateBlacklist(Model model) {
        Blacklist blacklist = new Blacklist();
        for (SmallMoleculeReference smr : model.getObjects(SmallMoleculeReference.class)) {
            String name = smr.getDisplayName();
            if (name == null || !this.knownNames.containsKey(name = name.toLowerCase())) continue;
            blacklist.addEntry(smr.getUri(), 1, this.knownNames.get(name));
            for (SimplePhysicalEntity spe : smr.getEntityReferenceOf()) {
                blacklist.addEntry(spe.getUri(), 1, this.knownNames.get(name));
            }
        }
        return blacklist;
    }
}

