/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.pattern.miner.CSCOBothControllerAndParticipantMiner;
import org.biopax.paxtools.pattern.miner.CSCOButIsParticipantMiner;
import org.biopax.paxtools.pattern.miner.CSCOThroughBindingSmallMoleculeMiner;
import org.biopax.paxtools.pattern.miner.CSCOThroughControllingSmallMoleculeMiner;
import org.biopax.paxtools.pattern.miner.CSCOThroughDegradationMiner;
import org.biopax.paxtools.pattern.miner.CatalysisPrecedesMiner;
import org.biopax.paxtools.pattern.miner.ChemicalAffectsThroughBindingMiner;
import org.biopax.paxtools.pattern.miner.ChemicalAffectsThroughControlMiner;
import org.biopax.paxtools.pattern.miner.CommonIDFetcher;
import org.biopax.paxtools.pattern.miner.ConsumptionControlledByMiner;
import org.biopax.paxtools.pattern.miner.ControlsDegradationIndirectMiner;
import org.biopax.paxtools.pattern.miner.ControlsExpressionMiner;
import org.biopax.paxtools.pattern.miner.ControlsExpressionWithConvMiner;
import org.biopax.paxtools.pattern.miner.ControlsPhosphorylationMiner;
import org.biopax.paxtools.pattern.miner.ControlsProductionOfMiner;
import org.biopax.paxtools.pattern.miner.ControlsStateChangeDetailedMiner;
import org.biopax.paxtools.pattern.miner.ControlsStateChangeOfMiner;
import org.biopax.paxtools.pattern.miner.ControlsTransportMiner;
import org.biopax.paxtools.pattern.miner.ControlsTransportOfChemicalMiner;
import org.biopax.paxtools.pattern.miner.DirectedRelationMiner;
import org.biopax.paxtools.pattern.miner.InComplexWithMiner;
import org.biopax.paxtools.pattern.miner.InteractsWithMiner;
import org.biopax.paxtools.pattern.miner.Miner;
import org.biopax.paxtools.pattern.miner.MinerAdapter;
import org.biopax.paxtools.pattern.miner.NeighborOfMiner;
import org.biopax.paxtools.pattern.miner.ReactsWithMiner;
import org.biopax.paxtools.pattern.miner.RelatedGenesOfInteractionsMiner;
import org.biopax.paxtools.pattern.miner.UbiquitousIDMiner;
import org.biopax.paxtools.pattern.miner.UsedToProduceMiner;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.ProgressWatcher;

public class Dialog
extends JFrame
implements ActionListener,
KeyListener {
    private Miner[] miners;
    private JRadioButton pcRadio;
    private JRadioButton customFileRadio;
    private JRadioButton customURLRadio;
    private JTextField modelField;
    private JTextField urlField;
    private JButton loadButton;
    private JComboBox pcCombo;
    private JComboBox patternCombo;
    private JTextArea descArea;
    private JTextField outputField;
    private JButton runButton;
    private JLabel prgLabel;
    private JProgressBar prgBar;
    private static final String PC_DATA_URL_PREFIX = "http://www.pathwaycommons.org/pc2/downloads/Pathway%20Commons.4.";
    private static final String PC_DATA_URL_SUFFIX = ".BIOPAX.owl.gz";
    private static final Color BACKGROUND = Color.WHITE;
    private static final Object[] PC_RES_NAMES = new Object[]{"All-Data", "Reactome", "NCI-PID", "HumanCyc", "PhosphoSitePlus", "PANTHER"};
    private static final String[] PC_RES_URL = new String[]{"All", "Reactome", "NCI_Nature", "HumanCyc", "PhosphoSitePlus", "PANTHER%20Pathway"};
    private static final String UBIQUE_FILE = "blacklist.txt";
    private static final String UBIQUE_URL = "http://www.pathwaycommons.org/pc2/downloads/blacklist.txt";
    private static Blacklist blacklist;

    public static void main(String[] args) {
        Dialog d = new Dialog(new Miner[0]);
        d.setVisible(true);
    }

    public Dialog(Miner ... miners) throws HeadlessException {
        super("Pattern Miner");
        this.miners = miners;
        this.setDefaultCloseOperation(3);
        this.init();
    }

    private void init() {
        this.setSize(600, 400);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(BACKGROUND);
        JPanel modelPanel = new JPanel(new GridBagLayout());
        this.pcRadio = new JRadioButton("Use Pathway Commons");
        this.pcRadio.addActionListener(this);
        this.pcRadio.setBackground(BACKGROUND);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.anchor = 21;
        modelPanel.add((Component)this.pcRadio, con);
        this.pcCombo = new JComboBox<Object>(PC_RES_NAMES);
        this.pcCombo.setBackground(BACKGROUND);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 0;
        con.anchor = 10;
        con.ipadx = 5;
        modelPanel.add((Component)this.pcCombo, con);
        this.customFileRadio = new JRadioButton("Use custom file");
        this.customFileRadio.addActionListener(this);
        this.customFileRadio.setBackground(BACKGROUND);
        con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 1;
        con.anchor = 21;
        modelPanel.add((Component)this.customFileRadio, con);
        JPanel modelChooserPanel = new JPanel(new FlowLayout());
        this.modelField = new JTextField(15);
        this.modelField.addKeyListener(this);
        this.modelField.setEnabled(false);
        modelChooserPanel.add(this.modelField);
        this.loadButton = new JButton("Load");
        this.loadButton.addActionListener(this);
        this.loadButton.setEnabled(false);
        modelChooserPanel.add(this.loadButton);
        modelChooserPanel.setBackground(BACKGROUND);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 1;
        con.anchor = 10;
        modelPanel.add((Component)modelChooserPanel, con);
        this.customURLRadio = new JRadioButton("Use the owl at URL");
        this.customURLRadio.addActionListener(this);
        this.customURLRadio.setBackground(BACKGROUND);
        con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 2;
        con.anchor = 21;
        modelPanel.add((Component)this.customURLRadio, con);
        this.urlField = new JTextField(15);
        this.urlField.addKeyListener(this);
        this.urlField.setEnabled(false);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.gridy = 2;
        con.anchor = 21;
        modelPanel.add((Component)this.urlField, con);
        ButtonGroup group = new ButtonGroup();
        group.add(this.pcRadio);
        group.add(this.customFileRadio);
        group.add(this.customURLRadio);
        group.setSelected(this.pcRadio.getModel(), true);
        modelPanel.setBorder(BorderFactory.createTitledBorder("Source model"));
        modelPanel.setBackground(BACKGROUND);
        this.getContentPane().add((Component)modelPanel, "North");
        JPanel minerPanel = new JPanel(new BorderLayout());
        minerPanel.setBackground(BACKGROUND);
        minerPanel.setBorder(BorderFactory.createTitledBorder("Pattern to search"));
        JPanel comboPanel = new JPanel(new FlowLayout());
        comboPanel.setBackground(BACKGROUND);
        JLabel patternLabel = new JLabel("Pattern: ");
        this.patternCombo = new JComboBox<Object>(this.getAvailablePatterns());
        this.patternCombo.addActionListener(this);
        this.patternCombo.setBackground(BACKGROUND);
        comboPanel.add(patternLabel);
        comboPanel.add(this.patternCombo);
        minerPanel.add((Component)comboPanel, "North");
        this.descArea = new JTextArea(30, 3);
        this.descArea.setEditable(false);
        this.descArea.setBorder(BorderFactory.createTitledBorder("Description"));
        this.descArea.setText(((Miner)this.patternCombo.getSelectedItem()).getDescription());
        this.descArea.setLineWrap(true);
        this.descArea.setWrapStyleWord(true);
        minerPanel.add((Component)this.descArea, "Center");
        JPanel progressPanel = new JPanel(new GridBagLayout());
        progressPanel.setBackground(BACKGROUND);
        this.prgLabel = new JLabel("                       ");
        this.prgBar = new JProgressBar();
        this.prgBar.setStringPainted(true);
        this.prgBar.setVisible(false);
        con = new GridBagConstraints();
        con.gridx = 0;
        con.anchor = 10;
        con.ipady = 12;
        con.ipadx = 10;
        progressPanel.add((Component)this.prgLabel, con);
        con = new GridBagConstraints();
        con.gridx = 1;
        con.anchor = 22;
        progressPanel.add((Component)this.prgBar, con);
        minerPanel.add((Component)progressPanel, "South");
        this.getContentPane().add((Component)minerPanel, "Center");
        JPanel finishPanel = new JPanel(new BorderLayout());
        JPanel lowerPanel = new JPanel(new FlowLayout());
        lowerPanel.setBackground(BACKGROUND);
        this.outputField = new JTextField(20);
        this.outputField.setBorder(BorderFactory.createTitledBorder("Output file"));
        this.outputField.addActionListener(this);
        this.outputField.addKeyListener(this);
        this.outputField.setText(((Miner)this.patternCombo.getSelectedItem()).getName() + ".txt");
        finishPanel.add((Component)this.outputField, "West");
        this.runButton = new JButton("Run");
        this.runButton.addActionListener(this);
        finishPanel.add((Component)this.runButton, "East");
        JPanel bufferPanel = new JPanel(new FlowLayout());
        bufferPanel.setMinimumSize(new Dimension(300, 10));
        bufferPanel.setBackground(BACKGROUND);
        bufferPanel.add(new JLabel("    "));
        finishPanel.add((Component)bufferPanel, "Center");
        finishPanel.setBackground(BACKGROUND);
        lowerPanel.add(finishPanel);
        this.getContentPane().add((Component)lowerPanel, "South");
    }

    private int getMaxMemory() {
        int total = 0;
        for (MemoryPoolMXBean mpBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (mpBean.getType() != MemoryType.HEAP) continue;
            total = (int)((long)total + (mpBean.getUsage().getMax() >> 20));
        }
        return total;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pcRadio || e.getSource() == this.customFileRadio || e.getSource() == this.customURLRadio) {
            this.pcCombo.setEnabled(this.pcRadio.isSelected());
            this.modelField.setEnabled(this.customFileRadio.isSelected());
            this.loadButton.setEnabled(this.customFileRadio.isSelected());
            this.urlField.setEnabled(this.customURLRadio.isSelected());
        } else if (e.getSource() == this.loadButton) {
            String current = this.modelField.getText();
            String initial = current.trim().length() > 0 ? current : ".";
            JFileChooser fc = new JFileChooser(initial);
            fc.setFileFilter(new FileNameExtensionFilter("BioPAX file (*.owl)", "owl"));
            if (fc.showOpenDialog(this) == 0) {
                File file = fc.getSelectedFile();
                this.modelField.setText(file.getPath());
            }
        } else if (e.getSource() == this.patternCombo) {
            Miner m = (Miner)this.patternCombo.getSelectedItem();
            this.descArea.setText(m.getDescription());
            String text = this.outputField.getText();
            text = text.contains("/") ? text.substring(0, text.lastIndexOf("/") + 1) : "";
            text = text + m.getName() + ".txt";
            this.outputField.setText(text);
        } else if (e.getSource() == this.runButton) {
            this.run();
        }
        this.checkRunButton();
    }

    private void checkRunButton() {
        this.runButton.setEnabled((this.pcRadio.isSelected() || this.customFileRadio.isSelected() && !this.modelField.getText().trim().isEmpty() || this.customURLRadio.isSelected() && !this.urlField.getText().trim().isEmpty()) && !this.outputField.getText().trim().isEmpty());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.checkRunButton();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private Object[] getAvailablePatterns() {
        ArrayList<Miner> minerList = new ArrayList<Miner>();
        if (this.miners != null && this.miners.length > 0) {
            minerList.addAll(Arrays.asList(this.miners));
        } else {
            minerList.add(new DirectedRelationMiner());
            minerList.add(new ControlsStateChangeOfMiner());
            minerList.add(new CSCOButIsParticipantMiner());
            minerList.add(new CSCOBothControllerAndParticipantMiner());
            minerList.add(new CSCOThroughControllingSmallMoleculeMiner());
            minerList.add(new CSCOThroughBindingSmallMoleculeMiner());
            minerList.add(new ControlsStateChangeDetailedMiner());
            minerList.add(new ControlsPhosphorylationMiner());
            minerList.add(new ControlsTransportMiner());
            minerList.add(new ControlsExpressionMiner());
            minerList.add(new ControlsExpressionWithConvMiner());
            minerList.add(new CSCOThroughDegradationMiner());
            minerList.add(new ControlsDegradationIndirectMiner());
            minerList.add(new ConsumptionControlledByMiner());
            minerList.add(new ControlsProductionOfMiner());
            minerList.add(new CatalysisPrecedesMiner());
            minerList.add(new ChemicalAffectsThroughBindingMiner());
            minerList.add(new ChemicalAffectsThroughControlMiner());
            minerList.add(new ControlsTransportOfChemicalMiner());
            minerList.add(new InComplexWithMiner());
            minerList.add(new InteractsWithMiner());
            minerList.add(new NeighborOfMiner());
            minerList.add(new ReactsWithMiner());
            minerList.add(new UsedToProduceMiner());
            minerList.add(new RelatedGenesOfInteractionsMiner());
            minerList.add(new UbiquitousIDMiner());
        }
        for (Miner miner : minerList) {
            if (!(miner instanceof MinerAdapter)) continue;
            ((MinerAdapter)miner).setBlacklist(blacklist);
        }
        return minerList.toArray(new Object[minerList.size()]);
    }

    private void run() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Dialog.this.mine();
            }
        });
        t.start();
    }

    private void mine() {
        Model model;
        File modFile;
        Miner miner = (Miner)this.patternCombo.getSelectedItem();
        if (miner instanceof MinerAdapter) {
            ((MinerAdapter)miner).setIDFetcher(new CommonIDFetcher());
        }
        ((Miner)this.patternCombo.getSelectedItem()).getPattern();
        ProgressWatcher prg = new ProgressWatcher(){

            @Override
            public synchronized void setTotalTicks(int total) {
                Dialog.this.prgBar.setMaximum(total);
            }

            @Override
            public synchronized void tick(int times) {
                Dialog.this.prgBar.setValue(Dialog.this.prgBar.getValue() + times);
            }
        };
        this.prgBar.setVisible(true);
        if (this.pcRadio.isSelected()) {
            if (this.getMaxMemory() < 4000) {
                JOptionPane.showMessageDialog(this, "Maximum memory not large enough for handling\nPathway Commons data. But will try anyway.\nPlease consider running this application with the\nvirtual machine parameter \"-Xmx5G\".");
            }
            if (!(modFile = new File(this.getPCFilename())).exists()) {
                this.prgLabel.setText("Downloading model");
                if (!this.downloadPC(prg)) {
                    this.eraseProgressBar();
                    JOptionPane.showMessageDialog(this, "Cannot download Pathway Commons data for some reason. Sorry.");
                    return;
                }
                assert (modFile.exists());
            }
        } else if (this.customFileRadio.isSelected()) {
            modFile = new File(this.modelField.getText());
        } else if (this.customURLRadio.isSelected()) {
            String url = this.urlField.getText().trim();
            this.prgLabel.setText("Downloading model");
            if (url.endsWith(".gz")) {
                this.downloadCompressed(prg, url, "temp.owl", true);
            } else if (url.endsWith(".zip")) {
                this.downloadCompressed(prg, url, "temp.owl", false);
            } else {
                Dialog.downloadPlain(url, "temp.owl");
            }
            modFile = new File("temp.owl");
            if (!modFile.exists()) {
                JOptionPane.showMessageDialog(this, "Cannot download the model at the given URL.");
                this.eraseProgressBar();
                return;
            }
        } else {
            throw new RuntimeException("Code should not be able to reach here!");
        }
        File outFile = new File(this.outputField.getText());
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
            writer.write("x");
            writer.close();
            outFile.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.eraseProgressBar();
            JOptionPane.showMessageDialog(this, "Cannot write to file: " + outFile.getPath());
            return;
        }
        this.prgLabel.setText("Loading the model");
        this.prgBar.setIndeterminate(true);
        this.prgBar.setStringPainted(false);
        SimpleIOHandler io = new SimpleIOHandler();
        try {
            model = io.convertFromOWL(new FileInputStream(modFile));
            this.prgBar.setIndeterminate(false);
            this.prgBar.setStringPainted(true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.eraseProgressBar();
            JOptionPane.showMessageDialog(this, "File not found: " + modFile.getPath());
            return;
        }
        Miner min = (Miner)this.patternCombo.getSelectedItem();
        Pattern p = min.getPattern();
        this.prgLabel.setText("Searching the pattern");
        this.prgBar.setValue(0);
        Map<BioPAXElement, List<Match>> matches = Searcher.search(model, p, prg);
        if (matches.isEmpty()) {
            this.prgLabel.setText("No results found!");
        } else {
            try {
                this.prgLabel.setText("Writing result");
                this.prgBar.setValue(0);
                this.prgBar.setStringPainted(false);
                this.prgBar.setIndeterminate(true);
                FileOutputStream os = new FileOutputStream(outFile);
                min.writeResult(matches, os);
                os.close();
                this.prgBar.setIndeterminate(false);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.eraseProgressBar();
                JOptionPane.showMessageDialog(this, "Error occurred while writing the results");
                return;
            }
            this.prgLabel.setText("Success!    ");
            System.out.println("Success!");
            this.dispose();
        }
    }

    private void eraseProgressBar() {
        this.prgLabel.setText("             ");
        this.prgBar.setVisible(false);
    }

    private String getPCDataURL() {
        return PC_DATA_URL_PREFIX + PC_RES_URL[this.pcCombo.getSelectedIndex()] + PC_DATA_URL_SUFFIX;
    }

    private String getPCFilename() {
        return PC_RES_NAMES[this.pcCombo.getSelectedIndex()].toString() + ".owl";
    }

    private boolean downloadPC(ProgressWatcher prg) {
        return this.downloadCompressed(prg, this.getPCDataURL(), this.getPCFilename(), true);
    }

    private boolean downloadCompressed(ProgressWatcher prg, String urlString, String filename, boolean gz) {
        try {
            int len;
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            InflaterInputStream in = gz ? new GZIPInputStream(con.getInputStream()) : new ZipInputStream(con.getInputStream());
            prg.setTotalTicks(con.getContentLength() * 8);
            FileOutputStream out = new FileOutputStream(filename);
            byte[] buf = new byte[1024];
            int lines = 0;
            while ((len = ((InputStream)in).read(buf)) > 0) {
                prg.tick(len);
                ((OutputStream)out).write(buf, 0, len);
                ++lines;
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return lines > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean downloadUbiques() {
        return Dialog.downloadPlain(UBIQUE_URL, UBIQUE_FILE);
    }

    private static boolean downloadPlain(String urlString, String file) {
        try {
            int len;
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            InputStream in = con.getInputStream();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int lines = 0;
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                ++lines;
            }
            in.close();
            ((OutputStream)out).close();
            return lines > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        File f = new File(UBIQUE_FILE);
        if (!f.exists()) {
            Dialog.downloadUbiques();
        } else if (f.exists()) {
            blacklist = new Blacklist(f.getAbsolutePath());
        } else {
            System.out.println("Warning: Cannot load blacklist.");
        }
    }
}

