/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.query.model.AbstractGraph;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3.ControlWrapper;
import org.biopax.paxtools.query.wrapperL3.ConversionWrapper;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.paxtools.query.wrapperL3.PhysicalEntityWrapper;
import org.biopax.paxtools.query.wrapperL3.TemplateReactionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphL3
extends AbstractGraph {
    protected Model model;
    protected List<Filter> filters;
    protected final Logger log = LoggerFactory.getLogger(GraphL3.class);

    public GraphL3(Model model, Filter ... filters) {
        assert (model.getLevel() == BioPAXLevel.L3);
        this.model = model;
        if (filters.length > 0) {
            this.filters = Arrays.asList(filters);
        }
    }

    private boolean passesFilters(Level3Element ele) {
        if (this.filters == null) {
            return true;
        }
        for (Filter filter : this.filters) {
            if (filter.okToTraverse(ele)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node wrap(Object obj) {
        if (!(obj instanceof Level3Element)) {
            throw new IllegalArgumentException("An object other than a Level3Element is trying to be wrapped: " + obj);
        }
        if (!this.passesFilters((Level3Element)obj)) {
            return null;
        }
        if (obj instanceof PhysicalEntity) {
            return new PhysicalEntityWrapper((PhysicalEntity)obj, this);
        }
        if (obj instanceof Conversion) {
            return new ConversionWrapper((Conversion)obj, this);
        }
        if (obj instanceof TemplateReaction) {
            return new TemplateReactionWrapper((TemplateReaction)obj, this);
        }
        if (obj instanceof Control) {
            return new ControlWrapper((Control)obj, this);
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid BioPAX object to wrap as node. Ignoring: " + obj);
        }
        return null;
    }

    @Override
    public String getKey(Object wrapped) {
        if (wrapped instanceof BioPAXElement) {
            return ((BioPAXElement)wrapped).getUri();
        }
        throw new IllegalArgumentException("Object cannot be wrapped: " + wrapped);
    }

    @Override
    public Set<Node> getWrapperSet(Set<?> objects) {
        HashSet<Node> wrapped = new HashSet<Node>();
        for (Object object : objects) {
            Node node = (Node)this.getGraphObject(object);
            if (node == null) continue;
            wrapped.add(node);
        }
        return wrapped;
    }

    @Override
    public Map<Object, Node> getWrapperMap(Set<?> objects) {
        HashMap<Object, Node> map = new HashMap<Object, Node>();
        for (Object object : objects) {
            Node node = (Node)this.getGraphObject(object);
            if (node == null) continue;
            map.put(object, node);
        }
        return map;
    }

    @Override
    public Set<Object> getWrappedSet(Set<? extends GraphObject> wrappers) {
        HashSet<Object> objects = new HashSet<Object>();
        for (GraphObject graphObject : wrappers) {
            if (graphObject instanceof PhysicalEntityWrapper) {
                objects.add(((PhysicalEntityWrapper)graphObject).getPhysicalEntity());
                continue;
            }
            if (graphObject instanceof ConversionWrapper) {
                objects.add(((ConversionWrapper)graphObject).getConversion());
                continue;
            }
            if (graphObject instanceof TemplateReactionWrapper) {
                objects.add(((TemplateReactionWrapper)graphObject).getTempReac());
                continue;
            }
            if (!(graphObject instanceof ControlWrapper)) continue;
            objects.add(((ControlWrapper)graphObject).getControl());
        }
        return objects;
    }

    public Model getModel() {
        return this.model;
    }
}

