/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.pattern.constraint.ConBox;
import org.biopax.paxtools.pattern.constraint.ConversionSide;
import org.biopax.paxtools.pattern.constraint.Empty;
import org.biopax.paxtools.pattern.constraint.Equality;
import org.biopax.paxtools.pattern.constraint.LinkedPE;
import org.biopax.paxtools.pattern.constraint.ParticipatesInConv;
import org.biopax.paxtools.pattern.constraint.Size;
import org.biopax.paxtools.pattern.util.RelType;

public class ActivityRecognizer {
    private Map<ProteinReference, Set<PhysicalEntity>> effectingMap = new HashMap<ProteinReference, Set<PhysicalEntity>>();
    private Map<ProteinReference, Set<PhysicalEntity>> activeMap = new HashMap<ProteinReference, Set<PhysicalEntity>>();
    private Map<ProteinReference, Set<PhysicalEntity>> inactiveMap = new HashMap<ProteinReference, Set<PhysicalEntity>>();
    private Map<ProteinReference, Set<String>> activatingLocMap = new HashMap<ProteinReference, Set<String>>();
    private Map<ProteinReference, Set<String>> inactivatingLocMap = new HashMap<ProteinReference, Set<String>>();
    private Map<ProteinReference, Set<EntityReference>> activatingBindingMap = new HashMap<ProteinReference, Set<EntityReference>>();
    private Map<ProteinReference, Set<EntityReference>> inactivatingBindingMap = new HashMap<ProteinReference, Set<EntityReference>>();
    private Map<ProteinReference, Set<Conversion>> activatingConv = new HashMap<ProteinReference, Set<Conversion>>();
    private Map<ProteinReference, Set<Conversion>> inactivatingConv = new HashMap<ProteinReference, Set<Conversion>>();
    private static final Random rand = new Random();
    Model model;
    private static final PathAccessor MODIF_TERMS = new PathAccessor("PhysicalEntity/feature:ModificationFeature/modificationType/term");
    private static final PathAccessor MODIF = new PathAccessor("PhysicalEntity/feature:ModificationFeature");
    private static final PathAccessor LOCATION = new PathAccessor("PhysicalEntity/cellularLocation/term");
    private static final PathAccessor MODIF_2_TERM = new PathAccessor("ModificationFeature/modificationType/term");
    private Pattern inOutFromPRPattern = this.prepareInOutFromPRPattern();
    private Pattern linkedPEToComplexPattern = this.prepareLinkedPEToComplexPattern();
    private Pattern linkedPEToMemberPattern = this.prepareLinkedPEToMemberPattern();
    private Pattern linkedPEToMemberERPattern = this.prepareLinkedPEToMemberERPattern();
    private Pattern producingConvPattern = this.prepareProducingConvPattern();
    private Pattern transcriptionConvPattern = this.prepareTranscriptionConvPattern();
    private Pattern degradingConvPattern = this.prepareDegradingConvPattern();
    private Pattern associationPattern = this.prepareAssociationPattern();
    private Pattern dissociationPattern = this.prepareDissociationPattern();
    private String[] generalTerms = new String[]{"phospho", "ubiqutin", "acetyl", "myristoyl", "palmitoyl", "glucosyl"};

    public ActivityRecognizer(Model model) {
        this.model = model;
    }

    private void initMaps() {
        for (ProteinReference pr : this.model.getObjects(ProteinReference.class)) {
            if (!this.isHuman(pr)) continue;
            this.effectingMap.put(pr, new HashSet());
            this.activeMap.put(pr, new HashSet());
            this.inactiveMap.put(pr, new HashSet());
            this.activatingLocMap.put(pr, new HashSet());
            this.inactivatingLocMap.put(pr, new HashSet());
            this.activatingBindingMap.put(pr, new HashSet());
            this.inactivatingBindingMap.put(pr, new HashSet());
            this.activatingConv.put(pr, new HashSet());
            this.inactivatingConv.put(pr, new HashSet());
        }
    }

    private boolean contains(ProteinReference pr, Map map1, Map map2, Object obj) {
        Set set1 = (Set)map1.get(pr);
        Set set2 = (Set)map2.get(pr);
        return set1.contains(obj) || set2.contains(obj);
    }

    public void run() {
        this.initMaps();
        this.initEffecting();
        System.out.println("inited effecting");
        this.initWithNCIActivityLabels();
        System.out.println("inited nci labels");
        this.processHiddenTranscriptions();
        System.out.println("processed hidden transcriptions");
        this.processDegradingReactions();
        System.out.println("processed degrading");
        boolean loop = true;
        while (loop) {
            this.extractAffectingLocAndBinding();
            System.out.println("extracted effective loc and binding");
            loop = this.assesConversions();
            System.out.println("assessed conversion");
            loop = this.decideToTheTypeOfTheEffecting() || loop;
            System.out.println("categorized effecting");
        }
        this.categorizeRemainingEffectorAsActive();
        System.out.println("made remaining effectors active");
        this.sanityCheck();
        this.embedRecognitionsInModel();
    }

    private void initWithNCIActivityLabels() {
        for (ProteinReference er : this.effectingMap.keySet()) {
            for (PhysicalEntity pe : Searcher.searchAndCollect(er.getEntityReferenceOf(), this.linkedPEToComplexPattern, 1, PhysicalEntity.class)) {
                if (this.hasNCIActiveLabel(pe) || this.activeInName(pe) || this.hasActiveMember(pe) && !this.hasInactiveMember(pe)) {
                    this.activeMap.get(er).add(pe);
                    if (!this.inactiveMap.get(er).contains(pe)) continue;
                    System.err.println("Inactive map already contains this pe: " + pe.getDisplayName());
                    continue;
                }
                if (!this.hasNCIInactiveLabel(pe) && !this.inactiveInName(pe) && !this.hasInactiveMember(pe)) continue;
                this.inactiveMap.get(er).add(pe);
                if (!this.activeMap.get(er).contains(pe)) continue;
                System.err.println("Active map already contains this pe: " + pe.getDisplayName());
            }
        }
    }

    private void processHiddenTranscriptions() {
        for (ProteinReference pr : this.effectingMap.keySet()) {
            for (Conversion cnv : Searcher.searchAndCollect(pr.getEntityReferenceOf(), this.transcriptionConvPattern, 1, Conversion.class)) {
                if (this.activatingConv.get(pr).contains(cnv)) continue;
                this.activatingConv.get(pr).add(cnv);
                cnv.addComment("Is Transcipription");
            }
        }
    }

    private void processDegradingReactions() {
        for (ProteinReference pr : this.effectingMap.keySet()) {
            for (Conversion cnv : Searcher.searchAndCollect(pr.getEntityReferenceOf(), this.degradingConvPattern, 1, Conversion.class)) {
                this.inactivatingConv.get(pr).add(cnv);
                PhysicalEntity pe = cnv.getLeft().iterator().next();
                if (this.activeMap.get(pr).contains(pe) || !pe.getControllerOf().isEmpty()) continue;
                this.inactiveMap.get(pr).add(pe);
            }
        }
    }

    private void initEffecting() {
        for (ProteinReference pr : this.effectingMap.keySet()) {
            for (SimplePhysicalEntity spe : pr.getEntityReferenceOf()) {
                for (PhysicalEntity pe : Searcher.searchAndCollect(spe, this.linkedPEToComplexPattern, 1, PhysicalEntity.class)) {
                    if (pe.getControllerOf().isEmpty()) continue;
                    this.effectingMap.get(pr).add(pe);
                }
            }
        }
    }

    private void extractAffectingLocAndBinding() {
        for (ProteinReference pr : this.effectingMap.keySet()) {
            Set actLoc = LOCATION.getValueFromBeans((Collection<? extends BioPAXElement>)this.activeMap.get(pr));
            Set inactLoc = LOCATION.getValueFromBeans((Collection<? extends BioPAXElement>)this.inactiveMap.get(pr));
            this.removeCommon(actLoc, inactLoc);
            this.activatingLocMap.put(pr, actLoc);
            this.inactivatingLocMap.put(pr, inactLoc);
            HashSet<EntityReference> actBinding = new HashSet<EntityReference>();
            HashSet<EntityReference> inactBinding = new HashSet<EntityReference>();
            for (EntityReference er : Searcher.searchAndCollect((Collection<? extends BioPAXElement>)this.activeMap.get(pr), this.linkedPEToMemberERPattern, 2, EntityReference.class)) {
                actBinding.add(er);
            }
            for (EntityReference er : Searcher.searchAndCollect((Collection<? extends BioPAXElement>)this.inactiveMap.get(pr), this.linkedPEToMemberERPattern, 2, EntityReference.class)) {
                inactBinding.add(er);
            }
            this.removeCommon(actBinding, inactBinding);
            this.activatingBindingMap.put(pr, actBinding);
            this.inactivatingBindingMap.put(pr, inactBinding);
        }
    }

    private boolean assesConversions() {
        boolean predictedNew = false;
        for (ProteinReference pr : this.effectingMap.keySet()) {
            if (this.hasCommon(this.activeMap.get(pr), this.inactiveMap.get(pr))) {
                System.err.println("Active and inactive states overlap. PR = " + pr.getDisplayName());
            }
            for (Conversion cnv : Searcher.searchAndCollect((Collection<? extends BioPAXElement>)this.activeMap.get(pr), this.producingConvPattern, 1, Conversion.class)) {
                if (this.contains(pr, this.activatingConv, this.inactivatingConv, cnv)) continue;
                this.activatingConv.get(pr).add(cnv);
                predictedNew = true;
            }
            for (Conversion cnv : Searcher.searchAndCollect((Collection<? extends BioPAXElement>)this.inactiveMap.get(pr), this.producingConvPattern, 1, Conversion.class)) {
                if (this.contains(pr, this.activatingConv, this.inactivatingConv, cnv)) continue;
                this.inactivatingConv.get(pr).add(cnv);
                predictedNew = true;
            }
            for (Match match : Searcher.search(pr, this.inOutFromPRPattern)) {
                PhysicalEntity inPE = (PhysicalEntity)match.get(1);
                PhysicalEntity outPE = (PhysicalEntity)match.get(5);
                Conversion conv = (Conversion)match.get(3);
                if (this.contains(pr, this.activatingConv, this.inactivatingConv, conv)) continue;
                if (inPE != outPE) {
                    Set<ModificationFeature> gained = this.getFeatures(outPE);
                    Set<ModificationFeature> lost = this.getFeatures(inPE);
                    this.removeCommon(gained, lost);
                    int pred = this.predictByFeature(pr, gained, lost);
                    if (pred == 1) {
                        this.activatingConv.get(pr).add(conv);
                    } else if (pred == -1) {
                        this.inactivatingConv.get(pr).add(conv);
                    }
                    if (pred != 0) {
                        predictedNew = true;
                        continue;
                    }
                }
                PhysicalEntity inCmp = (PhysicalEntity)match.get(2);
                PhysicalEntity outCmp = (PhysicalEntity)match.get(4);
                Set<EntityReference> gained = Searcher.searchAndCollect(outCmp, this.linkedPEToMemberERPattern, 2, EntityReference.class);
                Set<EntityReference> lost = Searcher.searchAndCollect(inCmp, this.linkedPEToMemberERPattern, 2, EntityReference.class);
                this.removeCommon(gained, lost);
                int pred = this.predictByBinding(pr, gained, lost);
                if (pred == 1) {
                    this.activatingConv.get(pr).add(conv);
                } else if (pred == -1) {
                    this.inactivatingConv.get(pr).add(conv);
                }
                if (pred != 0) {
                    predictedNew = true;
                    continue;
                }
                Set gainLoc = LOCATION.getValueFromBean(outPE);
                gainLoc.addAll(LOCATION.getValueFromBean(outCmp));
                Set lostLoc = LOCATION.getValueFromBean(inPE);
                lostLoc.addAll(LOCATION.getValueFromBean(inCmp));
                pred = this.predictByLocation(pr, gainLoc, lostLoc);
                if (pred == 1) {
                    this.activatingConv.get(pr).add(conv);
                } else if (pred == -1) {
                    this.inactivatingConv.get(pr).add(conv);
                }
                if (pred == 0) continue;
                predictedNew = true;
            }
        }
        return predictedNew;
    }

    private int predictByFeature(ProteinReference pr, Set<ModificationFeature> gained, Set<ModificationFeature> lost) {
        Set activFeats = MODIF.getValueFromBeans((Collection<? extends BioPAXElement>)this.activeMap.get(pr));
        Set inactivFeats = MODIF.getValueFromBeans((Collection<? extends BioPAXElement>)this.inactiveMap.get(pr));
        this.removeCommon(activFeats, inactivFeats);
        boolean activated = false;
        boolean inactivated = false;
        for (ModificationFeature mf : gained) {
            if (activFeats.contains(mf)) {
                activated = true;
                continue;
            }
            if (!inactivFeats.contains(mf)) continue;
            inactivated = true;
        }
        for (ModificationFeature mf : lost) {
            if (inactivFeats.contains(mf)) {
                activated = true;
                continue;
            }
            if (!activFeats.contains(mf)) continue;
            inactivated = true;
        }
        if (activated && inactivated) {
            return 0;
        }
        if (activated) {
            return 1;
        }
        if (inactivated) {
            return -1;
        }
        Set<String> activTerms = this.extractTerms(activFeats);
        Set<String> inactivTerms = this.extractTerms(inactivFeats);
        this.removeCommon(activTerms, inactivTerms);
        Set<String> gainedTerms = this.extractTerms(gained);
        Set<String> lostTerms = this.extractTerms(lost);
        this.removeCommon(gainedTerms, lostTerms);
        for (String term : gainedTerms) {
            if (activTerms.contains(term)) {
                activated = true;
                continue;
            }
            if (!inactivTerms.contains(term)) continue;
            inactivated = true;
        }
        for (String term : lostTerms) {
            if (inactivTerms.contains(term)) {
                activated = true;
                continue;
            }
            if (!activTerms.contains(term)) continue;
            inactivated = true;
        }
        if (activated && inactivated) {
            return 0;
        }
        if (activated) {
            return 1;
        }
        if (inactivated) {
            return -1;
        }
        Set<String> generalActiv = this.getGeneralWords(activTerms);
        Set<String> generalInactiv = this.getGeneralWords(inactivTerms);
        this.removeCommon(generalActiv, generalInactiv);
        Set<String> generalGained = this.getGeneralWords(gainedTerms);
        Set<String> generalLost = this.getGeneralWords(lostTerms);
        this.removeCommon(generalGained, generalLost);
        for (String term : generalGained) {
            if (generalActiv.contains(term)) {
                activated = true;
                continue;
            }
            if (!generalInactiv.contains(term)) continue;
            inactivated = true;
        }
        for (String term : generalLost) {
            if (generalInactiv.contains(term)) {
                activated = true;
                continue;
            }
            if (!generalActiv.contains(term)) continue;
            inactivated = true;
        }
        if (activated && inactivated) {
            return 0;
        }
        if (activated) {
            return 1;
        }
        if (inactivated) {
            return -1;
        }
        return 0;
    }

    private int predictByBinding(ProteinReference pr, Set<EntityReference> gained, Set<EntityReference> lost) {
        boolean inactivating;
        boolean activating = this.hasCommon(gained, this.activatingBindingMap.get(pr)) || this.hasCommon(lost, this.inactivatingBindingMap.get(pr));
        boolean bl = inactivating = this.hasCommon(gained, this.inactivatingBindingMap.get(pr)) || this.hasCommon(lost, this.activatingBindingMap.get(pr));
        if (activating && inactivating) {
            return 0;
        }
        if (activating) {
            return 1;
        }
        if (inactivating) {
            return -1;
        }
        return 0;
    }

    private int predictByLocation(ProteinReference pr, Set<String> gained, Set<String> lost) {
        boolean inactivating;
        boolean activating = this.hasCommon(gained, this.activatingLocMap.get(pr)) || this.hasCommon(lost, this.inactivatingLocMap.get(pr));
        boolean bl = inactivating = this.hasCommon(gained, this.inactivatingLocMap.get(pr)) || this.hasCommon(lost, this.activatingLocMap.get(pr));
        if (activating && inactivating) {
            return 0;
        }
        if (activating) {
            return 1;
        }
        if (inactivating) {
            return -1;
        }
        return 0;
    }

    private boolean decideToTheTypeOfTheEffecting() {
        boolean predictedNew = false;
        for (ProteinReference pr : this.effectingMap.keySet()) {
            for (PhysicalEntity pe : this.effectingMap.get(pr)) {
                if (this.contains(pr, this.activeMap, this.inactiveMap, pe)) continue;
                boolean inactive = false;
                boolean active = false;
                for (Conversion cnv : Searcher.searchAndCollect(pe, this.producingConvPattern, 1, Conversion.class)) {
                    if (this.inactivatingConv.get(pr).contains(cnv)) {
                        inactive = true;
                    }
                    if (!this.activatingConv.get(pr).contains(cnv)) continue;
                    active = true;
                }
                if (!inactive && !active) {
                    Set<EntityReference> friends = Searcher.searchAndCollect(pe, this.linkedPEToMemberERPattern, 2, EntityReference.class);
                    if (this.hasCommon(friends, this.inactiveMap.get(pr))) {
                        inactive = true;
                    }
                    if (this.hasCommon(friends, this.activeMap.get(pr))) {
                        active = true;
                    }
                }
                if (inactive && !active) {
                    this.inactiveMap.get(pr).add(pe);
                } else if (active && !inactive) {
                    this.activeMap.get(pr).add(pe);
                }
                if (!active && !inactive || active && inactive) continue;
                predictedNew = true;
            }
        }
        return predictedNew;
    }

    private void categorizeRemainingEffectorAsActive() {
        for (ProteinReference pr : this.effectingMap.keySet()) {
            for (PhysicalEntity pe : this.effectingMap.get(pr)) {
                if (this.contains(pr, this.activeMap, this.inactiveMap, pe)) continue;
                this.activeMap.get(pr).add(pe);
            }
        }
    }

    private void sanityCheck() {
        for (ProteinReference pr : this.effectingMap.keySet()) {
            if (!this.hasCommon(this.activeMap.get(pr), this.inactiveMap.get(pr))) continue;
            System.err.println("Active and inactive sets overlap: " + pr.getDisplayName());
        }
        for (ProteinReference pr : this.effectingMap.keySet()) {
            if (!this.hasCommon(this.activatingConv.get(pr), this.inactivatingConv.get(pr))) continue;
            System.err.println("Activating and inactivating conversions overlap: " + pr.getDisplayName());
        }
    }

    private void embedRecognitionsInModel() {
        for (ProteinReference pr : this.effectingMap.keySet()) {
            for (PhysicalEntity pe : this.effectingMap.get(pr)) {
                if (this.activeMap.get(pr).contains(pe)) {
                    pr.addComment("Active state " + pe.getUri());
                    pe.addComment("Active state " + pr.getUri());
                    continue;
                }
                if (!this.inactiveMap.get(pr).contains(pe)) continue;
                pr.addComment("Inactive state " + pe.getUri());
                pe.addComment("Inactive state " + pr.getUri());
            }
        }
        for (ProteinReference pr : this.activatingConv.keySet()) {
            for (Conversion cnv : this.activatingConv.get(pr)) {
                pr.addComment("Activating conv " + cnv.getUri());
                cnv.addComment("Activating conv " + pr.getUri());
            }
        }
        for (ProteinReference pr : this.inactivatingConv.keySet()) {
            for (Conversion cnv : this.inactivatingConv.get(pr)) {
                pr.addComment("Inactivating conv " + cnv.getUri());
                cnv.addComment("Inactivating conv " + pr.getUri());
            }
        }
        this.embedInhibitoryBinding();
    }

    private void embedInhibitoryBinding() {
        for (ProteinReference pr : this.effectingMap.keySet()) {
            Control ctrl;
            PhysicalEntity pe;
            EntityReference er;
            Conversion cnv;
            for (Match match : Searcher.search(pr, this.associationPattern)) {
                cnv = (Conversion)match.get(3);
                er = (EntityReference)match.getLast();
                if (!this.inactivatingConv.get(pr).contains(cnv) || !this.inactivatingBindingMap.get(pr).contains(er)) continue;
                pe = (PhysicalEntity)match.get(8);
                ctrl = this.model.addNew(Control.class, this.generateID());
                ctrl.addController(pe);
                ctrl.addControlled(cnv);
                ctrl.setControlType(ControlType.ACTIVATION);
            }
            for (Match match : Searcher.search(pr, this.dissociationPattern)) {
                cnv = (Conversion)match.get(3);
                er = (EntityReference)match.getLast();
                if (!this.inactivatingConv.get(pr).contains(cnv) || !this.inactivatingBindingMap.get(pr).contains(er)) continue;
                pe = (PhysicalEntity)match.get(10);
                ctrl = this.model.addNew(Control.class, this.generateID());
                ctrl.addController(pe);
                ctrl.addControlled(cnv);
                ctrl.setControlType(ControlType.INHIBITION);
            }
        }
    }

    private Set<ModificationFeature> getFeatures(PhysicalEntity pe) {
        return MODIF.getValueFromBean(pe);
    }

    private boolean hasNCIActiveLabel(PhysicalEntity pe) {
        return MODIF_TERMS.getValueFromBean(pe).contains("residue modification, active");
    }

    private boolean hasNCIInactiveLabel(PhysicalEntity pe) {
        return MODIF_TERMS.getValueFromBean(pe).contains("residue modification, inactive");
    }

    private boolean isHuman(ProteinReference pr) {
        return pr.getOrganism() != null && pr.getOrganism().getDisplayName().equals("Homo sapiens");
    }

    private boolean activeInString(String s) {
        return s.toLowerCase().contains("activ") && !s.toLowerCase().contains("inactiv");
    }

    private boolean inactiveInString(String s) {
        return s.toLowerCase().contains("inactiv");
    }

    private boolean activeInName(Named nd) {
        for (String name : nd.getName()) {
            if (!this.activeInString(name)) continue;
            return true;
        }
        return false;
    }

    private boolean inactiveInName(Named nd) {
        for (String name : nd.getName()) {
            if (!this.inactiveInString(name)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInactiveMember(PhysicalEntity pe) {
        for (PhysicalEntity pe2 : Searcher.searchAndCollect(pe, this.linkedPEToMemberPattern, 1, PhysicalEntity.class)) {
            if (!this.hasNCIInactiveLabel(pe2) && !this.inactiveInName(pe2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasActiveMember(PhysicalEntity pe) {
        for (PhysicalEntity pe2 : Searcher.searchAndCollect(pe, this.linkedPEToMemberPattern, 1, PhysicalEntity.class)) {
            if (!this.hasNCIActiveLabel(pe2) && !this.activeInName(pe2)) continue;
            return true;
        }
        return false;
    }

    private Set<String> extractTerms(Set<ModificationFeature> mods) {
        return new HashSet<String>(MODIF_2_TERM.getValueFromBeans((Collection<? extends BioPAXElement>)mods));
    }

    private Set<String> getGeneralWords(Set<String> terms) {
        HashSet<String> set = new HashSet<String>();
        for (String term : terms) {
            term = term.toLowerCase();
            for (String gen : this.generalTerms) {
                if (!term.contains(gen)) continue;
                set.add(gen);
            }
        }
        return set;
    }

    private void removeCommon(Set s1, Set s2) {
        HashSet common = new HashSet(s1);
        common.retainAll(s2);
        s1.removeAll(common);
        s2.removeAll(common);
    }

    private boolean hasCommon(Set s1, Set s2) {
        for (Object o : s1) {
            if (!s2.contains(o)) continue;
            return true;
        }
        return false;
    }

    private String generateID() {
        return "ActivityRecognizer" + System.currentTimeMillis() + rand.nextDouble();
    }

    private Pattern prepareInOutFromPRPattern() {
        Pattern p = new Pattern(ProteinReference.class, "PR");
        p.add(ConBox.erToPE(), "PR", "SPE input");
        p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_GENERAL), "SPE input", "PE input");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "PE input", "Conv");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE input", "Conv", "PE output");
        p.add((Constraint)new Equality(false), "PE input", "PE output");
        p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_SPECIFIC), "PE output", "SPE output");
        p.add(ConBox.peToER(), "SPE output", "PR");
        return p;
    }

    private Pattern prepareLinkedPEToComplexPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_GENERAL), "PE", "com PE");
        return p;
    }

    private Pattern prepareLinkedPEToMemberPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_SPECIFIC), "PE", "mem PE");
        return p;
    }

    private Pattern prepareLinkedPEToMemberERPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_SPECIFIC), "PE", "SPE");
        p.add(ConBox.peToER(), "SPE", "ER");
        return p;
    }

    private Pattern prepareProducingConvPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new ParticipatesInConv(RelType.OUTPUT), "PE", "Conv");
        return p;
    }

    private Pattern prepareTranscriptionConvPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new ParticipatesInConv(RelType.OUTPUT), "PE", "Conv");
        p.add((Constraint)new Empty(ConBox.left()), "Conv");
        p.add((Constraint)new Size(ConBox.right(), 1, Size.Type.EQUAL), "Conv");
        return p;
    }

    private Pattern prepareDegradingConvPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "PE", "Conv");
        p.add((Constraint)new Empty(ConBox.right()), "Conv");
        p.add((Constraint)new Size(ConBox.left(), 1, Size.Type.EQUAL), "Conv");
        return p;
    }

    private Pattern prepareAssociationPattern() {
        Pattern p = new Pattern(ProteinReference.class, "PR 1");
        p.add(ConBox.erToPE(), "PR 1", "SPE in1");
        p.add(ConBox.linkToComplex(), "SPE in1", "PE in1");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "PE in1", "Conv");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE in1", "Conv", "PE out");
        p.add(ConBox.linkToSpecific(), "PE out", "SPE out");
        p.add(ConBox.peToER(), "SPE out", "PR1");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE out", "Conv", "PE in2");
        p.add((Constraint)new Equality(false), "PE in", "PE in2");
        p.add(ConBox.linkToSpecific(), "PE in2", "SPE in2");
        p.add(ConBox.peToER(), "SPE in2", "PR 2");
        p.add((Constraint)new Equality(false), "PR 1", "PR 2");
        p.add(ConBox.linkToSpecific(), "PE out", "SPE out1");
        p.add(ConBox.peToER(), "SPE out1", "PR 1");
        p.add(ConBox.linkToSpecific(), "PE out", "SPE out2");
        p.add(ConBox.peToER(), "SPE out2", "PR 2");
        return p;
    }

    private Pattern prepareDissociationPattern() {
        Pattern p = new Pattern(ProteinReference.class, "PR 1");
        p.add(ConBox.erToPE(), "PR 1", "SPE in1");
        p.add(ConBox.linkToComplex(), "SPE in1", "PE in");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "PE in", "Conv");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE in", "Conv", "PE out1");
        p.add(ConBox.linkToSpecific(), "PE out1", "SPE out1");
        p.add(ConBox.peToER(), "SPE out1", "PR 1");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE in", "Conv", "PE out2");
        p.add((Constraint)new Equality(false), "PE out1", "PE out2");
        p.add(ConBox.linkToSpecific(), "PE out2", "SPE out2");
        p.add(ConBox.peToER(), "SPE out2", "PR 2");
        p.add(ConBox.type(ProteinReference.class), "PR 2");
        p.add((Constraint)new Equality(false), "PR 1", "PR 2");
        p.add(ConBox.linkToSpecific(), "PE in", "SPE in2");
        p.add(ConBox.peToER(), "SPE in2", "PR 2");
        return p;
    }

    public static void main(String[] args) throws FileNotFoundException {
        ActivityRecognizer ar = new ActivityRecognizer(null);
        Searcher.searchInFile(ar.transcriptionConvPattern, "/home/ozgun/Desktop/cpath2.owl", "/home/ozgun/Desktop/pattern-matches/transcriptionConvPattern.owl", 100, 1);
    }
}

