/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.model.GraphObject;
import org.cbio.causality.analysis.BFS;
import org.cbio.causality.analysis.CausativePathSearch;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.AlterationProvider;
import org.cbio.causality.model.Change;
import org.cbio.causality.model.Node;
import org.cbio.causality.model.Path;
import org.cbio.causality.util.Binomial;
import org.cbio.causality.util.Histogram;
import org.cbio.causality.util.Summary;
import org.cbio.causality.wrapper.ComplexMember;
import org.cbio.causality.wrapper.Graph;
import org.cbio.causality.wrapper.PhysicalEntityWrapper;

public class CausalityExecuter {
    public static List<Path> findCausativePaths(Model model, AlterationProvider ap, int limit, double alterationThr, Set<String> ubiqueIDs) {
        ArrayList<Path> result = new ArrayList<Path>();
        Graph graph = ubiqueIDs == null ? new Graph(model) : new Graph(model, ubiqueIDs);
        graph.setAlterationProvider(ap);
        CausativePathSearch cps = new CausativePathSearch();
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            for (SimplePhysicalEntity pe : er.getEntityReferenceOf()) {
                for (Node node : graph.getAllWrappers(pe)) {
                    AlterationPack pack = ap.getAlterations(node);
                    if (pack == null || !(pack.getAlteredRatio() >= alterationThr)) continue;
                    result.addAll(cps.search(node, limit, alterationThr));
                }
            }
        }
        return result;
    }

    public static Map<PhysicalEntity, Map<Integer, Integer>[]> labelGraph(Model model, AlterationProvider ap, int limit, double alterationThr, Set<String> ubiqueIDs) {
        HashMap<PhysicalEntity, Map<Integer, Integer>[]> label = new HashMap<PhysicalEntity, Map<Integer, Integer>[]>();
        Graph graph = ubiqueIDs == null ? new Graph(model) : new Graph(model, ubiqueIDs);
        graph.setAlterationProvider(ap);
        CausativePathSearch cps = new CausativePathSearch();
        Map<Node, Map<Integer, Integer>[]> nodeMap = cps.labelGraph(graph, limit, alterationThr);
        for (Node node : nodeMap.keySet()) {
            if (!(node instanceof PhysicalEntityWrapper) || node instanceof ComplexMember) continue;
            PhysicalEntity pe = ((PhysicalEntityWrapper)node).getPhysicalEntity();
            label.put(pe, nodeMap.get(node));
        }
        return label;
    }

    public static Map<EntityReference, Set<EntityReference>>[] getAffectedDownstreamMaps(Graph graph) {
        Map[] map = new Map[]{new HashMap(), new HashMap()};
        int i = 0;
        for (ProteinReference pr : graph.getModel().getObjects(ProteinReference.class)) {
            if (!CausalityExecuter.isHuman(pr)) continue;
            System.out.print(".");
            if (++i % 150 == 0) {
                System.out.println();
            }
            map[0].put(pr, new HashSet());
            map[1].put(pr, new HashSet());
            BFS bfs = new BFS(graph.getForAll(pr.getEntityReferenceOf()), null, Direction.UPSTREAM, 3, true);
            Map<GraphObject, Integer> labels = bfs.run();
            for (GraphObject go : labels.keySet()) {
                EntityReference er;
                PhysicalEntityWrapper pew;
                PhysicalEntity pe;
                if (labels.get(go) == 0 || !(go instanceof PhysicalEntityWrapper) || !((pe = (pew = (PhysicalEntityWrapper)go).getPhysicalEntity()) instanceof SimplePhysicalEntity) || pew.getPathSign() == 0 || (er = ((SimplePhysicalEntity)pe).getEntityReference()) == null || er == pr) continue;
                ((Set)map[pew.getPathSign() == 1 ? 0 : 1].get(pr)).add(er);
            }
            graph.clear();
        }
        System.out.println();
        System.out.println("Positives = " + CausalityExecuter.countNonEmpty(map[0]));
        System.out.println("Negatives = " + CausalityExecuter.countNonEmpty(map[1]));
        return map;
    }

    private static int countNonEmpty(Map<EntityReference, Set<EntityReference>> map) {
        int cnt = 0;
        for (EntityReference er : map.keySet()) {
            if (map.get(er).isEmpty()) continue;
            ++cnt;
        }
        return cnt;
    }

    private static boolean isHuman(ProteinReference pr) {
        return pr.getOrganism() != null && pr.getOrganism().getDisplayName().equals("Homo sapiens");
    }

    public static Map<EntityReference, int[]> getActivityPredictions(Map<EntityReference, Set<EntityReference>>[] down, AlterationProvider ap, int i) {
        HashMap<EntityReference, int[]> map = new HashMap<EntityReference, int[]>();
        for (EntityReference er : down[0].keySet()) {
            Change ch;
            AlterationPack alt;
            String id;
            map.put(er, new int[2]);
            for (EntityReference dEr : down[0].get(er)) {
                id = CausalityExecuter.getEGID(dEr);
                if (id == null || (alt = ap.getAlterations(id)) == null) continue;
                ch = alt.getChange(Alteration.ANY, i);
                if (ch == Change.ACTIVATING) {
                    int[] nArray = (int[])map.get(er);
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                if (ch != Change.INHIBITING) continue;
                int[] nArray = (int[])map.get(er);
                nArray[1] = nArray[1] + 1;
            }
            for (EntityReference dEr : down[1].get(er)) {
                id = CausalityExecuter.getEGID(dEr);
                if (id == null || (alt = ap.getAlterations(id)) == null) continue;
                ch = alt.getChange(Alteration.ANY, i);
                if (ch == Change.ACTIVATING) {
                    int[] nArray = (int[])map.get(er);
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                if (ch != Change.INHIBITING) continue;
                int[] nArray = (int[])map.get(er);
                nArray[0] = nArray[0] + 1;
            }
        }
        return map;
    }

    private static String getEGID(EntityReference er) {
        for (Xref xref2 : er.getXref()) {
            if (!xref2.getDb().equals("Entrez Gene")) continue;
            return xref2.getId();
        }
        return null;
    }

    public static void predictActivityFromDownstream(Model model, Set<String> ubiqueIDs, AlterationProvider ap) {
        Graph graph = new Graph(model, ubiqueIDs);
        Map<EntityReference, Set<EntityReference>>[] downMaps = CausalityExecuter.getAffectedDownstreamMaps(graph);
        int expSize = ap.getAlterations("367").get(Alteration.ANY).length;
        System.out.println("expSize = " + expSize);
        Histogram h1 = new Histogram(0.02);
        Histogram h2 = new Histogram(0.02);
        HashMap<EntityReference, int[]> count = new HashMap<EntityReference, int[]>();
        int cnt_total = 0;
        int cnt_result = 0;
        for (int i = 0; i < expSize; ++i) {
            Map<EntityReference, int[]> pred = CausalityExecuter.getActivityPredictions(downMaps, ap, i);
            for (EntityReference er : pred.keySet()) {
                int inh;
                int act;
                int total;
                Change ch;
                AlterationPack alt = ap.getAlterations(CausalityExecuter.getEGID(er));
                if (alt == null) continue;
                if (!count.containsKey(er)) {
                    count.put(er, new int[4]);
                }
                if (!(ch = alt.getChange(Alteration.ANY, i)).isAltered() || (total = (act = pred.get(er)[0]) + (inh = pred.get(er)[1])) <= 5) continue;
                ++cnt_total;
                double pval = Binomial.getPval(act, inh);
                h1.count(pval);
                int randHeads = 0;
                int randTrials = 1;
                for (int j = 0; j < randTrials; ++j) {
                    randHeads += Binomial.generateRand(total);
                }
                double pvRand = Binomial.getPval(randHeads /= randTrials, total - randHeads);
                h2.count(pvRand);
                if (!(pval < 0.05)) continue;
                ++cnt_result;
                if (ch == Change.ACTIVATING && act > inh) {
                    int[] nArray = (int[])count.get(er);
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                if (ch == Change.ACTIVATING && act < inh) {
                    int[] nArray = (int[])count.get(er);
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                if (ch == Change.INHIBITING && act > inh) {
                    int[] nArray = (int[])count.get(er);
                    nArray[2] = nArray[2] + 1;
                    continue;
                }
                if (ch != Change.INHIBITING || act >= inh) continue;
                int[] nArray = (int[])count.get(er);
                nArray[3] = nArray[3] + 1;
            }
        }
        h1.printTogether(h2);
        System.out.println("Expected result by chance = " + (double)cnt_total * 0.05);
        System.out.println("Result size = " + cnt_result);
        int hold = 0;
        int donthold = 0;
        int geneCount = 0;
        for (EntityReference er : count.keySet()) {
            int[] c = (int[])count.get(er);
            if (Summary.sum(c) <= 1) continue;
            ++geneCount;
            System.out.println(er.getDisplayName() + "\t" + c[0] + "\t" + c[1] + "\t" + c[2] + "\t" + c[3]);
            hold += c[0] + c[3];
            donthold += c[1] + c[2];
        }
        System.out.println("hold = " + hold);
        System.out.println("donthold = " + donthold);
        System.out.println("geneCount = " + geneCount);
    }

    private static AlterationPack getAPack(AlterationProvider ap) {
        AlterationPack pack = null;
        for (int i = 0; i < 1000 && (pack = ap.getAlterations("" + i)) == null; ++i) {
        }
        return pack;
    }

    public static int[][][] searchDistances(Model model, List<ProteinReference> prs, int limit, Set<String> ubiques) {
        int[][][] d = new int[2][prs.size()][prs.size()];
        for (int j = 0; j < d[0].length; ++j) {
            for (int k = 0; k < d[0][j].length; ++k) {
                d[0][j][k] = Integer.MAX_VALUE;
                d[1][j][k] = Integer.MAX_VALUE;
            }
        }
        Graph graph = new Graph(model, ubiques);
        int ind1 = 0;
        for (ProteinReference pr : prs) {
            System.out.print(".");
            if ((ind1 + 1) % 150 == 0) {
                System.out.println();
            }
            Set<Node> source = graph.getForAll(pr.getEntityReferenceOf());
            BFS bfs = new BFS(source, null, Direction.DOWNSTREAM, limit, false);
            Map<GraphObject, Integer> labelMap = bfs.run();
            for (GraphObject go : labelMap.keySet()) {
                EntityReference er;
                PhysicalEntity pe;
                if (!(go instanceof PhysicalEntityWrapper) || !((pe = ((PhysicalEntityWrapper)go).getPhysicalEntity()) instanceof SimplePhysicalEntity) || !((er = ((SimplePhysicalEntity)pe).getEntityReference()) instanceof ProteinReference) || er == pr) continue;
                int dist = labelMap.get(go);
                int sign = ((PhysicalEntityWrapper)go).getPathSign();
                int ind2 = prs.indexOf(er);
                if (ind2 < 0) continue;
                if (d[0][ind1][ind2] > dist) {
                    d[0][ind1][ind2] = dist;
                    d[1][ind1][ind2] = sign;
                    continue;
                }
                if (d[1][ind1][ind2] == sign) continue;
                d[1][ind1][ind2] = 0;
            }
            ++ind1;
            graph.clear();
        }
        return d;
    }
}

