/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.PatternBox;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.query.algorithm.BFS;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.model.AbstractNode;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3.ConversionWrapper;
import org.biopax.paxtools.query.wrapperL3.EdgeL3;
import org.biopax.paxtools.query.wrapperL3.GraphL3;
import org.biopax.paxtools.query.wrapperL3.UbiqueFilter;

public class ConversionTypeLabeler {
    private static PathAccessor paModif = new PathAccessor("PhysicalEntity/feature:ModificationFeature/modificationType/term");
    private static PathAccessor paComp = new PathAccessor("PhysicalEntity/componentOf*");
    private static PathAccessor paMem = new PathAccessor("Complex/component*");

    public Map<Conversion, Integer> label(EntityReference er, Model model, Set<String> ubiq, Map<EntityReference, Set<ModificationFeature>> activating, Map<EntityReference, Set<ModificationFeature>> inhibiting) {
        Conversion conv;
        HashMap<Conversion, Integer> convMap = new HashMap<Conversion, Integer>();
        Set<PhysicalEntity> active = this.getActiveStates(er);
        Set<Conversion> modifConv = this.getModifierConversions(er);
        for (Conversion conv2 : modifConv) {
            int type = 0;
            if (conv2.getLeft().isEmpty()) {
                type = conv2.getConversionDirection() == ConversionDirectionType.RIGHT_TO_LEFT ? -1 : 1;
            } else if (conv2.getRight().isEmpty()) {
                type = conv2.getConversionDirection() == ConversionDirectionType.RIGHT_TO_LEFT ? 1 : -1;
            }
            if (type == 0) continue;
            convMap.put(conv2, type);
        }
        List<Match> matches = Searcher.search(er, PatternBox.actChange(true, activating, inhibiting));
        for (Match match : matches) {
            conv = (Conversion)match.get(4);
            assert (modifConv.contains(conv));
            if (convMap.containsKey(conv)) continue;
            convMap.put(conv, 1);
        }
        matches = Searcher.search(er, PatternBox.actChange(false, activating, inhibiting));
        for (Match match : matches) {
            conv = (Conversion)match.get(4);
            assert (modifConv.contains(conv));
            if (convMap.containsKey(conv)) continue;
            convMap.put(conv, -1);
        }
        this.enrichActiveStatesWithPredicted(active, convMap);
        Graph graph = new Graph(model, ubiq, modifConv);
        HashSet<Node> source = new HashSet<Node>();
        for (PhysicalEntity pe : active) {
            source.add((Node)graph.getGraphObject(pe));
        }
        BFS bfs = new BFS(source, null, Direction.UPSTREAM, 10);
        Map<GraphObject, Integer> map = bfs.run();
        for (GraphObject go : map.keySet()) {
            ConversionWrapper w;
            Conversion conv3;
            if (!(go instanceof ConversionWrapper) || convMap.containsKey(conv3 = (w = (ConversionWrapper)go).getConversion())) continue;
            convMap.put(conv3, this.decideClassOfConversion(conv3, map, graph));
        }
        return convMap;
    }

    private void enrichActiveStatesWithPredicted(Set<PhysicalEntity> active, Map<Conversion, Integer> convMap) {
    }

    private Set<Conversion> getModifierConversions(EntityReference er) {
        HashSet<Conversion> set = new HashSet<Conversion>();
        Pattern p = PatternBox.modifierConv();
        List<Match> matches = Searcher.search(er, p);
        for (Match match : matches) {
            set.add((Conversion)match.get(4));
        }
        return set;
    }

    private Integer decideClassOfConversion(Conversion cnv, Map<GraphObject, Integer> map, Graph graph) {
        Integer right;
        Integer left = this.getMinLabel(cnv.getLeft(), map, graph);
        if (left.equals(right = this.getMinLabel(cnv.getRight(), map, graph))) {
            return 0;
        }
        if (cnv.getConversionDirection() == ConversionDirectionType.RIGHT_TO_LEFT) {
            return right > left ? 1 : -1;
        }
        return left > right ? 1 : -1;
    }

    private Integer getMinLabel(Set<PhysicalEntity> set, Map<GraphObject, Integer> map, Graph graph) {
        Integer min = Integer.MAX_VALUE;
        for (PhysicalEntity pe : set) {
            Integer lab = map.get(graph.getGraphObject(pe));
            if (lab == null || lab >= min) continue;
            min = lab;
        }
        return min;
    }

    public Set<PhysicalEntity> getActiveStates(EntityReference er) {
        HashSet<PhysicalEntity> active = new HashSet<PhysicalEntity>();
        Pattern p = PatternBox.hasNonSelfEffect();
        for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
            if (Searcher.search(spe, p).isEmpty()) continue;
            this.getActiveStatesRecursive(spe, active);
        }
        return active;
    }

    private void getActiveStatesRecursive(PhysicalEntity pe, Set<PhysicalEntity> active) {
        if (!pe.getControllerOf().isEmpty() || this.hasActiveLabel(pe)) {
            active.add(pe);
        }
        for (Complex cmp : pe.getComponentOf()) {
            this.getActiveStatesRecursive(cmp, active);
        }
    }

    private boolean hasActiveLabel(PhysicalEntity pe) {
        if (paModif.getValueFromBean(pe).contains("residue modification, active")) {
            return true;
        }
        if (this.stringContainsActive(pe.getDisplayName()) || this.stringContainsActive(pe.getStandardName())) {
            return true;
        }
        for (String name : pe.getName()) {
            if (!this.stringContainsActive(name)) continue;
            return true;
        }
        return false;
    }

    private boolean stringContainsActive(String s) {
        if (s == null) {
            return false;
        }
        return (s = s.toLowerCase()).contains("activ") && !s.contains("inactiv");
    }

    private boolean stringContainsInactive(String s) {
        if (s == null) {
            return false;
        }
        s = s.toLowerCase();
        return s.contains("inactiv");
    }

    private boolean hasInactiveLabel(PhysicalEntity pe) {
        if (paModif.getValueFromBean(pe).contains("residue modification, inactive")) {
            return true;
        }
        if (this.stringContainsInactive(pe.getDisplayName()) || this.stringContainsInactive(pe.getStandardName())) {
            return true;
        }
        for (String name : pe.getName()) {
            if (!this.stringContainsInactive(name)) continue;
            return true;
        }
        return false;
    }

    private void enrichActiveStatesWithComplexes(Set<PhysicalEntity> active) {
        for (PhysicalEntity pe : new HashSet<PhysicalEntity>(active)) {
            if (!this.hasActiveLabel(pe)) continue;
            for (Object o : paComp.getValueFromBean(pe)) {
                Complex comp = (Complex)o;
                if (comp.getControllerOf().isEmpty() && this.hasInactiveMember(comp)) continue;
                active.add(comp);
            }
        }
    }

    private boolean hasInactiveMember(Complex comp) {
        for (Object o : paMem.getValueFromBean(comp)) {
            PhysicalEntity pe = (PhysicalEntity)o;
            if (!this.hasInactiveLabel(pe)) continue;
            return true;
        }
        return false;
    }

    class ControlWrapper
    extends org.biopax.paxtools.query.wrapperL3.ControlWrapper {
        protected ControlWrapper(Control ctrl, GraphL3 graph) {
            super(ctrl, graph);
        }

        @Override
        public void initUpstream() {
        }

        @Override
        public void initDownstream() {
        }
    }

    class PhysicalEntityWrapper
    extends org.biopax.paxtools.query.wrapperL3.PhysicalEntityWrapper {
        public PhysicalEntityWrapper(PhysicalEntity pe, GraphL3 graph) {
            super(pe, graph);
            if (pe instanceof SmallMolecule) {
                this.setUbique(true);
            }
        }

        @Override
        public void initDownstream() {
            for (Interaction inter : this.getDownstreamInteractions(this.pe.getParticipantOf())) {
                if (inter instanceof Control) continue;
                AbstractNode node = (AbstractNode)this.graph.getGraphObject(inter);
                if (inter instanceof Conversion) {
                    Conversion conv = (Conversion)inter;
                    if (!((Graph)this.getGraph()).getModifierConv().contains(conv)) continue;
                    ConversionWrapper conW = (ConversionWrapper)node;
                    if (conv.getConversionDirection() == ConversionDirectionType.REVERSIBLE && conv.getRight().contains(this.pe)) {
                        node = conW.getReverse();
                    }
                }
                EdgeL3 edge = new EdgeL3(this, node, this.graph);
                this.getDownstreamNoInit().add(edge);
                node.getUpstreamNoInit().add(edge);
            }
        }

        @Override
        public void initUpstream() {
            for (Conversion conv : this.getUpstreamConversions(this.pe.getParticipantOf())) {
                if (!((Graph)this.getGraph()).getModifierConv().contains(conv)) continue;
                ConversionWrapper conW = (ConversionWrapper)this.graph.getGraphObject(conv);
                if (conv.getConversionDirection() == ConversionDirectionType.REVERSIBLE && conv.getLeft().contains(this.pe)) {
                    conW = conW.getReverse();
                }
                EdgeL3 edge = new EdgeL3(conW, this, this.graph);
                conW.getDownstreamNoInit().add(edge);
                this.getUpstreamNoInit().add(edge);
            }
        }
    }

    class Graph
    extends GraphL3 {
        Set<Conversion> modifierConv;

        public Graph(Model model, Set<String> ubiqueIDs, Set<Conversion> modifierConv) {
            super(model, new UbiqueFilter(ubiqueIDs));
            this.modifierConv = modifierConv;
        }

        public Set<Conversion> getModifierConv() {
            return this.modifierConv;
        }

        @Override
        public Node wrap(Object obj) {
            if (obj instanceof PhysicalEntity) {
                return new PhysicalEntityWrapper((PhysicalEntity)obj, this);
            }
            if (obj instanceof Control) {
                return new ControlWrapper((Control)obj, this);
            }
            return super.wrap(obj);
        }
    }
}

