/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.pattern.constraint.ConBox;
import org.biopax.paxtools.pattern.constraint.ConversionSide;
import org.biopax.paxtools.pattern.constraint.Equality;
import org.biopax.paxtools.pattern.constraint.LinkedPE;
import org.biopax.paxtools.pattern.constraint.ParticipatesInConv;
import org.biopax.paxtools.pattern.constraint.Type;
import org.biopax.paxtools.pattern.util.RelType;
import org.cbio.causality.ActivityRecognizer;

public class ModelPreparer {
    private static final Pattern PARTICIPANT_AND_CONTROLLER_PATTERN = ModelPreparer.prepareParticipantAndControllerPattern();
    private static final Pattern INPUT_TO_CONV_PATTERN = ModelPreparer.prepareInputToConv();
    private static final Pattern OUTPUT_TO_CONV_PATTERN = ModelPreparer.prepareOutputToConv();
    private static final Pattern BOTH_INPUT_AND_OUTPUT_PATTERN = ModelPreparer.prepareBothInputAndOutputPattern();
    private static final Pattern RELATED_ER_PATTERN = ModelPreparer.prepareRelatedERPattern();
    private static final Pattern SIMPLE_MEMBER_PATTERN = ModelPreparer.prepareSimpleMemberPattern();
    private static final PathAccessor COMPLEX_ACC = new PathAccessor("PhysicalEntity/componentOf*");
    private static final PathAccessor PARTICIPATES_ACC = new PathAccessor("PhysicalEntity/participantOf");
    private static final PathAccessor PARTICIPANTS_ACC = new PathAccessor("Interaction/participant");
    private static final Random rand = new Random();

    public static void prepare(Model model) {
        System.out.println("----Fix control and participant");
        ModelPreparer.removeControlIfAlsoParticipant(model);
        System.out.println("----Fixed");
        System.out.println("----Fix both input and output");
        ModelPreparer.fixBothInputAndOutputs(model);
        System.out.println("----Fixed");
        System.out.println("----Process loops");
        ModelPreparer.processLoops(model);
        System.out.println("----Processed");
    }

    public static void main(String[] args) throws FileNotFoundException {
        SimpleIOHandler h = new SimpleIOHandler();
        Model model = h.convertFromOWL(new FileInputStream("/home/ozgun/Desktop/MDM2-TP53-Neigh.owl"));
        ModelPreparer.prepare(model);
        ActivityRecognizer ar = new ActivityRecognizer(model);
        ar.run();
        h.convertToOWL(model, new FileOutputStream("/home/ozgun/Desktop/MDM2-TP53-Neigh-prepared.owl"));
    }

    public static void writePatternMatches() throws FileNotFoundException {
        Searcher.searchInFile(BOTH_INPUT_AND_OUTPUT_PATTERN, "/home/ozgun/Desktop/cpath2.owl", "/home/ozgun/Desktop/pattern-matches/BOTH_INPUT_AND_OUTPUT_PATTERN.owl");
    }

    private static String generateID() {
        return "ModelPreparer-" + System.currentTimeMillis() + "-" + rand.nextDouble();
    }

    public static void removeControlIfAlsoParticipant(Model model) {
        for (Match match : Searcher.searchPlain(model, PARTICIPANT_AND_CONTROLLER_PATTERN)) {
            Control c = (Control)match.get(2);
            if (c.getControlled().size() != 1) {
                System.err.println("Control controls more than one. ID = " + c.getUri());
            }
            if (c.getController().size() != 1) {
                System.err.println("Control has more than one controller. ID = " + c.getUri());
            }
            model.remove(c);
            for (Process controlled : new HashSet<Process>(c.getControlled())) {
                c.removeControlled(controlled);
            }
            for (Controller controller : new HashSet<Controller>(c.getController())) {
                c.removeController(controller);
            }
            for (Pathway pathway2 : c.getPathwayComponentOf()) {
                pathway2.removePathwayComponent(c);
            }
            for (PathwayStep step : c.getStepProcessOf()) {
                step.removeStepProcess(c);
            }
        }
    }

    public static void fixBothInputAndOutputs(Model model) {
        for (Conversion cnv : new HashSet<Conversion>(model.getObjects(Conversion.class))) {
            for (Match match : Searcher.search(cnv, BOTH_INPUT_AND_OUTPUT_PATTERN)) {
                PhysicalEntity pe = (PhysicalEntity)match.get(1);
                cnv.removeLeft(pe);
                cnv.removeRight(pe);
                Control ctrl = model.addNew(Control.class, ModelPreparer.generateID());
                ctrl.addController(pe);
                ctrl.addControlled(cnv);
                ctrl.setControlType(ControlType.ACTIVATION);
            }
        }
    }

    private static void processLoops(Model model) {
        HashSet<Set<Conversion>> groups = new HashSet<Set<Conversion>>();
        for (int i = 2; i < 5; ++i) {
            System.out.println("running for loop size " + i);
            List<Match> list = Searcher.searchPlain(model, ModelPreparer.prepareLoop(i));
            groups.addAll(ModelPreparer.extractUniqueConversionGroups(list));
            System.out.println("matches.size() = " + list.size());
            System.out.println("groups.size() = " + groups.size());
        }
        for (Set set : groups) {
            ModelPreparer.createReplacementConversion(model, set);
        }
    }

    private static void createReplacementConversion(Model model, Set<Conversion> cons) {
        HashSet<PhysicalEntity> inputs = new HashSet<PhysicalEntity>();
        HashSet<PhysicalEntity> outputs = new HashSet<PhysicalEntity>();
        HashSet<PhysicalEntity> effectors = new HashSet<PhysicalEntity>();
        for (Object o : PARTICIPANTS_ACC.getValueFromBeans((Collection<? extends BioPAXElement>)cons)) {
            PhysicalEntity pe;
            if (!(o instanceof PhysicalEntity) || (pe = (PhysicalEntity)o) instanceof SmallMolecule) continue;
            boolean isInput = ModelPreparer.isAssociated(pe, true, cons);
            boolean isOutput = ModelPreparer.isAssociated(pe, false, cons);
            if (isInput && isOutput) {
                effectors.add(pe);
                continue;
            }
            if (isInput) {
                inputs.add(pe);
                continue;
            }
            if (!isOutput) continue;
            outputs.add(pe);
        }
        if (!(inputs.isEmpty() || outputs.isEmpty() || effectors.isEmpty())) {
            HashSet<PhysicalEntity> inOut = new HashSet<PhysicalEntity>(inputs);
            inOut.addAll(outputs);
            Set<EntityReference> inOutERs = Searcher.searchAndCollect(inOut, RELATED_ER_PATTERN, 2, EntityReference.class);
            Conversion conv = model.addNew(Conversion.class, ModelPreparer.generateID());
            for (PhysicalEntity pe : inputs) {
                conv.addLeft(pe);
            }
            for (PhysicalEntity pe : outputs) {
                conv.addRight(pe);
            }
            Control ctrl = model.addNew(Control.class, ModelPreparer.generateID());
            for (PhysicalEntity pe : Searcher.searchAndCollect(effectors, SIMPLE_MEMBER_PATTERN, 1, PhysicalEntity.class)) {
                if (!ModelPreparer.relatedERsDifferent(pe, inOutERs)) continue;
                ctrl.addController(pe);
            }
            ctrl.addControlled(conv);
        }
    }

    private static Set<Set<Conversion>> extractUniqueConversionGroups(List<Match> matches) {
        HashSet<Set<Conversion>> set = new HashSet<Set<Conversion>>();
        HashSet<Integer> encountered = new HashSet<Integer>();
        for (Match match : matches) {
            Set<Conversion> cvns = ModelPreparer.getConversions(match);
            Integer hash = ModelPreparer.hashSum(cvns);
            if (encountered.contains(hash)) continue;
            encountered.add(hash);
            set.add(cvns);
        }
        return set;
    }

    private static Set<Conversion> getConversions(Match match) {
        HashSet<Conversion> set = new HashSet<Conversion>();
        for (BioPAXElement ele : match.getVariables()) {
            if (!(ele instanceof Conversion)) continue;
            set.add((Conversion)ele);
        }
        return set;
    }

    private static Integer hashSum(Set<Conversion> set) {
        int x = 0;
        for (Conversion inter : set) {
            x += inter.hashCode();
        }
        return x;
    }

    private static boolean isAssociated(PhysicalEntity pe, boolean input, Set<Conversion> cons) {
        for (Match match : Searcher.search(pe, input ? INPUT_TO_CONV_PATTERN : OUTPUT_TO_CONV_PATTERN)) {
            if (!cons.contains(match.get(1))) continue;
            return true;
        }
        return false;
    }

    private static boolean relatedERsDifferent(PhysicalEntity pe, Set<EntityReference> ers) {
        for (EntityReference er : Searcher.searchAndCollect(pe, RELATED_ER_PATTERN, 2, EntityReference.class)) {
            if (ers.contains(er)) continue;
            return true;
        }
        return false;
    }

    private static Pattern prepareParticipantAndControllerPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add(ConBox.participatesInInter(), "PE", "Inter");
        p.add(ConBox.peToControl(), "PE", "Ctrl");
        p.add(ConBox.controlled(), "Ctrl", "Controlled");
        p.add((Constraint)new Equality(true), "Inter", "Controlled");
        return p;
    }

    private static Pattern prepareInputToConv() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "PE", "Conv");
        return p;
    }

    private static Pattern prepareOutputToConv() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new ParticipatesInConv(RelType.OUTPUT), "PE", "Conv");
        return p;
    }

    private static Pattern prepareSimpleMemberPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add(ConBox.withSimpleMembers(), "PE", "SPE");
        p.add((Constraint)new Type(SimplePhysicalEntity.class), "SPE");
        return p;
    }

    private static Pattern prepareRelatedERPattern() {
        Pattern p = new Pattern(PhysicalEntity.class, "PE");
        p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_SPECIFIC), "PE", "SPE");
        p.add(ConBox.peToER(), "SPE", "ER");
        return p;
    }

    private static Pattern prepareBothInputAndOutputPattern() {
        Pattern p = new Pattern(Conversion.class, "Conv");
        p.add(ConBox.left(), "Conv", "PE left");
        p.add(ConBox.isHuman(), "PE left");
        p.add(ConBox.right(), "PE left");
        return p;
    }

    private static Pattern prepareLoop(int loopLength) {
        assert (loopLength > 1);
        Pattern p = new Pattern(ProteinReference.class, "PR1");
        p.add(ConBox.isHuman(), "PR1");
        p.add(ConBox.erToPE(), "PR1", "SPE1 in");
        p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_GENERAL), "SPE1 in", "PE1 in");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "PE1 in", "Conv1");
        p.add(ConBox.notControlled(), "Conv1");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE1 in", "Conv", "PE1 out");
        p.add((Constraint)new Equality(false), "PE1 in", "PE1 out");
        p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_SPECIFIC), "PE1 out", "SPE1 out");
        p.add(ConBox.peToER(), "SPE1 out", "PR1");
        for (int i = 2; i <= loopLength; ++i) {
            int j;
            p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "PE" + (i - 1) + " out", "Conv" + i);
            p.add(ConBox.notControlled(), "Conv" + i);
            for (j = 1; j < i; ++j) {
                p.add((Constraint)new Equality(false), "Conv" + j, "Conv" + i);
            }
            if (i == loopLength) {
                p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE" + (i - 1) + " out", "Conv" + i, "PE1 in");
                continue;
            }
            p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE" + (i - 1) + " out", "Conv" + i, "PE" + i + " out");
            for (j = 1; j < i; ++j) {
                p.add((Constraint)new Equality(false), "PE" + j + " out", "PE" + i + " out");
            }
            p.add((Constraint)new LinkedPE(LinkedPE.Type.TO_SPECIFIC), "PE" + i + " out", "SPE" + i + " out");
            p.add(ConBox.peToER(), "SPE" + i + " out", "PR");
        }
        return p;
    }
}

