/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cbio.causality.analysis.Graph;

public class ComponentSorter {
    private Graph graph;
    private List<Set<String>> components;

    public ComponentSorter(Set<String> genes, Graph graph) {
        this.graph = graph;
        this.components = new ArrayList<Set<String>>();
        for (String gene : genes) {
            this.add(gene);
        }
        this.sort();
    }

    public List<Set<String>> getComponents(int sizeThr) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        for (Set<String> comp : this.components) {
            if (comp.size() < sizeThr) continue;
            result.add(comp);
        }
        return result;
    }

    private void add(String gene) {
        Set<String> set;
        Set<String> neighbors = this.graph.getNeighbors(gene);
        ArrayList<Set<String>> matches = new ArrayList<Set<String>>();
        for (Set<String> comp : this.components) {
            if (!this.intersects(comp, neighbors)) continue;
            matches.add(comp);
        }
        if (matches.isEmpty()) {
            set = new HashSet<String>();
            set.add(gene);
            this.components.add(set);
        } else if (matches.size() == 1) {
            ((Set)matches.get(0)).add(gene);
        } else {
            int i;
            set = (Set)matches.get(0);
            set.add(gene);
            for (i = 1; i < matches.size(); ++i) {
                set.addAll((Collection)matches.get(i));
            }
            for (i = matches.size() - 1; i > 0; --i) {
                this.components.remove(matches.get(i));
            }
        }
    }

    private void sort() {
        Collections.sort(this.components, new Comparator<Set<String>>(){

            @Override
            public int compare(Set<String> o1, Set<String> o2) {
                return new Integer(o2.size()).compareTo(o1.size());
            }
        });
    }

    private boolean intersects(Set<String> set1, Set<String> set2) {
        HashSet<String> temp = new HashSet<String>(set1);
        temp.retainAll(set2);
        return !temp.isEmpty();
    }
}

