/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.util.Set;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.model.Edge;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;
import org.cbio.causality.model.Path;
import org.cbio.causality.model.PathUser;

public class Exhaustive {
    protected Path path;
    org.cbio.causality.model.Node source;
    int limit;
    Direction direction;
    Set<GraphObject> limitingSet;
    boolean limitEdgesToo;

    public Exhaustive(org.cbio.causality.model.Node source, Direction direction, int limit, PathUser user) {
        this(source, direction, limit, user, null);
    }

    public Exhaustive(org.cbio.causality.model.Node source, Direction direction, int limit, PathUser user, Set<GraphObject> limitingSet) {
        if (direction == Direction.BOTHSTREAM) {
            throw new IllegalArgumentException("Cannot perform exhaustive search to both sides. Please select either UPSTREAM or DOWNSTREAM.");
        }
        this.source = source;
        this.limit = limit;
        this.direction = direction;
        this.path = new Path(source, user);
        if (direction == Direction.UPSTREAM) {
            this.path.setReverse(true);
        }
        this.limitingSet = limitingSet;
        this.limitEdgesToo = true;
    }

    public boolean isLimitEdgesToo() {
        return this.limitEdgesToo;
    }

    public void setLimitEdgesToo(boolean limitEdgesToo) {
        this.limitEdgesToo = limitEdgesToo;
    }

    public void run() {
        this.advanceRecursive();
    }

    protected void advanceRecursive() {
        org.cbio.causality.model.Node node = this.path.getLastNode();
        if (this.path.getNodeSize() == 1 || this.path.getLastEdge() != null) {
            this.processEquivalents(true);
            this.processEquivalents(false);
        }
        if (this.path.getLength() == this.limit) {
            return;
        }
        for (Edge edge : this.direction == Direction.DOWNSTREAM ? node.getDownstream() : node.getUpstream()) {
            if (this.limitEdgesToo && this.limitingSet != null && !this.limitingSet.contains(edge)) continue;
            org.cbio.causality.model.Node neigh = (org.cbio.causality.model.Node)(this.direction == Direction.DOWNSTREAM ? edge.getTargetNode() : edge.getSourceNode());
            if (this.limitingSet != null && !this.limitingSet.contains(node) || !this.path.canAdd(neigh)) continue;
            this.path.add(neigh, edge);
            this.advanceRecursive();
            this.path.removeLast();
        }
    }

    protected void processEquivalents(boolean upper) {
        org.cbio.causality.model.Node node = this.path.getLastNode();
        for (Node equivalent : upper ? node.getUpperEquivalent() : node.getLowerEquivalent()) {
            org.cbio.causality.model.Node eq;
            if (this.limitingSet != null && !this.limitingSet.contains(equivalent) || !this.path.canAdd(eq = (org.cbio.causality.model.Node)equivalent)) continue;
            this.path.add(eq, null);
            this.advanceRecursive();
            this.processEquivalents(upper);
            this.path.removeLast();
        }
    }
}

