/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.analysis.BranchDataProvider;
import org.cbio.causality.analysis.Graph;

public class GeneBranch {
    public String gene;
    public String root;
    public Set<GeneBranch> branches;
    boolean selected = false;
    public Set<GeneBranch> equivalents;
    private BranchDataProvider data;

    GeneBranch(String gene, BranchDataProvider data, String root) {
        this.gene = gene;
        this.data = data;
        this.root = root;
        this.branches = new HashSet<GeneBranch>();
    }

    GeneBranch(String gene, BranchDataProvider data) {
        this(gene, data, gene);
    }

    public boolean isLeaf() {
        return this.branches.isEmpty();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean selectLeaves(Collection<String> leaves) {
        if (this.isLeaf()) {
            this.selected = leaves.contains(this.gene);
            return this.selected;
        }
        boolean modified = false;
        for (GeneBranch branch : this.branches) {
            modified = branch.selectLeaves(leaves) || modified;
        }
        this.selected = modified;
        return this.selected;
    }

    public void deselect() {
        this.selected = false;
        for (GeneBranch branch : this.branches) {
            branch.deselect();
        }
    }

    public boolean removeNonTargetLeaf(Collection<String> targets) {
        boolean modified = false;
        for (GeneBranch gwu : new HashSet<GeneBranch>(this.branches)) {
            if (!gwu.branches.isEmpty()) {
                boolean mod;
                do {
                    boolean bl = modified = (mod = gwu.removeNonTargetLeaf(targets)) || modified;
                } while (mod);
            }
            if (!gwu.branches.isEmpty() || targets.contains(gwu.gene)) continue;
            this.branches.remove(gwu);
            modified = true;
        }
        return modified;
    }

    public void trimToMajorPaths(Collection<String> targets) {
        if (this.isLeaf()) {
            return;
        }
        HashMap<GeneBranch, Set<String>> contentMap = new HashMap<GeneBranch, Set<String>>();
        for (GeneBranch u : this.branches) {
            Set<String> genes = u.getAllGenes();
            genes.retainAll(targets);
            contentMap.put(u, genes);
        }
        HashSet<GeneBranch> remove = new HashSet<GeneBranch>();
        for (GeneBranch g1 : contentMap.keySet()) {
            for (GeneBranch g2 : contentMap.keySet()) {
                if (g1 == g2 || !((Set)contentMap.get(g1)).containsAll((Collection)contentMap.get(g2)) || ((Set)contentMap.get(g1)).size() <= ((Set)contentMap.get(g2)).size()) continue;
                remove.add(g2);
            }
        }
        this.branches.removeAll(remove);
        for (GeneBranch u : this.branches) {
            u.trimToMajorPaths(targets);
        }
    }

    public boolean removeAbsentLeafConnections(Graph graph, boolean upstream) {
        boolean modified = false;
        for (GeneBranch branch : new HashSet<GeneBranch>(this.branches)) {
            if (!branch.branches.isEmpty()) {
                boolean mod;
                do {
                    boolean bl = modified = (mod = branch.removeAbsentLeafConnections(graph, upstream)) || modified;
                } while (mod);
            }
            if (!branch.branches.isEmpty() || (upstream ? graph.getUpstream(branch.gene) : graph.getDownstream(branch.gene)).contains(this.gene)) continue;
            this.branches.remove(branch);
            modified = true;
        }
        return modified;
    }

    public Set<String> getAllGenes() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.gene);
        for (GeneBranch u : this.branches) {
            set.addAll(u.getAllGenes());
        }
        return set;
    }

    public Set<String> getLeafGenes() {
        HashSet<String> set = new HashSet<String>();
        if (this.isLeaf()) {
            set.add(this.gene);
        } else {
            for (GeneBranch u : this.branches) {
                set.addAll(u.getLeafGenes());
            }
        }
        return set;
    }

    public Set<String> getAllGenesWithEq() {
        Set<String> set = this.getAllGenes();
        if (this.equivalents != null) {
            for (GeneBranch eq : this.equivalents) {
                set.add(eq.gene);
            }
        }
        return set;
    }

    private Map<GeneBranch, Set<GeneBranch>> getParentsMapping(Map<GeneBranch, Set<GeneBranch>> map) {
        if (!this.isLeaf()) {
            if (map == null) {
                map = new HashMap<GeneBranch, Set<GeneBranch>>();
            }
            for (GeneBranch branch : this.branches) {
                if (!map.containsKey(branch)) {
                    map.put(branch, new HashSet());
                }
                map.get(branch).add(this);
                branch.getParentsMapping(map);
            }
        }
        return map;
    }

    public void identifyEquivalents(boolean selectedOnly) {
        this.identifyEquivalents(null, selectedOnly);
    }

    private void identifyEquivalents(Map<GeneBranch, Set<GeneBranch>> parents, boolean selectedOnly) {
        if (this.isLeaf()) {
            return;
        }
        if (parents == null) {
            parents = this.getParentsMapping(null);
        }
        for (GeneBranch b1 : this.branches) {
            if (!b1.selected) continue;
            for (GeneBranch b2 : this.branches) {
                if (!b2.selected || b2 == b1 || b1.branches.size() != b2.branches.size() || !b1.branches.containsAll(b2.branches)) continue;
                Set<GeneBranch> p1 = parents.get(b1);
                Set<GeneBranch> p2 = parents.get(b2);
                if (p1.size() != p2.size() || !p1.containsAll(p2)) continue;
                if (b1.equivalents == null) {
                    b1.equivalents = new HashSet<GeneBranch>();
                }
                if (b2.equivalents == null) {
                    b2.equivalents = new HashSet<GeneBranch>();
                }
                b1.equivalents.add(b2);
                b2.equivalents.add(b1);
            }
            b1.identifyEquivalents(parents, selectedOnly);
        }
    }

    public List<List<GeneBranch>> getLevels() {
        ArrayList<GeneBranch> next;
        ArrayList<List<GeneBranch>> levels = new ArrayList<List<GeneBranch>>();
        ArrayList<GeneBranch> level = new ArrayList<GeneBranch>(1);
        level.add(this);
        HashSet<GeneBranch> visited = new HashSet<GeneBranch>();
        do {
            levels.add(level);
            for (GeneBranch b : level) {
                assert (!visited.contains(b));
            }
            visited.addAll(level);
            next = new ArrayList<GeneBranch>();
            for (GeneBranch br : level) {
                next.addAll(br.branches);
            }
        } while (!(level = next).isEmpty());
        return levels;
    }

    public Color getColor() {
        return this.data.getColor(this.gene, this.root);
    }

    public double getThickness() {
        return this.data.getThickness(this, this.root);
    }

    public GeneBranch copy(boolean selectedOnly) {
        if (selectedOnly && !this.isSelected()) {
            return null;
        }
        GeneBranch copy = new GeneBranch(this.gene, this.data, this.root);
        for (GeneBranch branch : this.branches) {
            GeneBranch bc = branch.copy(selectedOnly);
            if (bc == null) continue;
            copy.branches.add(bc);
        }
        return copy;
    }

    public String toString() {
        return this.gene + "\t" + this.branches.size();
    }
}

