/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.analysis.Graph;

public class GraphList
extends Graph {
    protected List<Graph> graphs = new ArrayList<Graph>();
    protected Map<String, Graph> type2graph = new HashMap<String, Graph>();

    public GraphList(String name) {
        super(name, null);
        this.ppMap = null;
        this.dwMap = null;
        this.upMap = null;
        this.mediators = null;
    }

    public void addGraph(Graph graph) {
        this.graphs.add(graph);
        this.type2graph.put(graph.getEdgeType(), graph);
    }

    public List<Graph> getGraphs() {
        return this.graphs;
    }

    public Graph getGraph(String edgeType) {
        return this.type2graph.get(edgeType);
    }

    @Override
    public void write(Writer writer) {
        for (Graph graph : this.graphs) {
            graph.write(writer);
        }
    }

    @Override
    public boolean isDirected() {
        for (Graph graph : this.graphs) {
            if (!graph.isDirected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUndirected() {
        for (Graph graph : this.graphs) {
            if (!graph.isUndirected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> goBFS(String seed, boolean downstream) {
        HashSet<String> result = new HashSet<String>();
        for (Graph graph : this.graphs) {
            result.addAll(graph.goBFS(seed, downstream ? graph.dwMap : graph.upMap));
        }
        return result;
    }

    @Override
    public Set<String> goBFS(Set<String> seed, Set<String> visited, boolean downstream) {
        HashSet<String> result = new HashSet<String>();
        for (Graph graph : this.graphs) {
            result.addAll(graph.goBFS(seed, visited, downstream ? graph.dwMap : graph.upMap));
        }
        return result;
    }

    @Override
    public Set<String> goBFS(Set<String> seed, Set<String> visited) {
        HashSet<String> result = new HashSet<String>();
        for (Graph graph : this.graphs) {
            result.addAll(graph.goBFS(seed, visited, graph.ppMap));
        }
        return result;
    }

    @Override
    public Set<String> getUpstream(String gene) {
        HashSet<String> result = new HashSet<String>();
        for (Graph graph : this.graphs) {
            result.addAll(graph.getUpstream(gene));
        }
        return result;
    }

    @Override
    public Set<String> getDownstream(String gene) {
        HashSet<String> result = new HashSet<String>();
        for (Graph graph : this.graphs) {
            result.addAll(graph.getDownstream(gene));
        }
        return result;
    }

    @Override
    public Set<String> getNeighbors(String gene) {
        HashSet<String> result = new HashSet<String>();
        for (Graph graph : this.graphs) {
            result.addAll(graph.getNeighbors(gene));
        }
        return result;
    }

    @Override
    public Set<String> getSymbols(boolean directed) {
        HashSet<String> syms = new HashSet<String>();
        for (Graph graph : this.graphs) {
            syms.addAll(graph.getSymbols(directed));
        }
        return syms;
    }

    @Override
    public void printStats() {
        System.out.println("Graph list: " + this.getName());
        System.out.println("--------");
        for (Graph graph : this.graphs) {
            graph.printStats();
            System.out.println();
        }
        System.out.println("--------");
    }

    @Override
    public Graph copy() {
        GraphList copy = new GraphList(this.getName());
        for (Graph graph : this.graphs) {
            copy.addGraph(graph.copy());
        }
        return copy;
    }

    @Override
    public GraphList changeTo(boolean directed) {
        for (Graph graph : this.graphs) {
            graph.changeTo(directed);
        }
        return this;
    }

    @Override
    public void crop(Collection<String> symbols) {
        for (Graph graph : this.graphs) {
            graph.crop(symbols);
        }
    }

    @Override
    protected Set<String> getRelationStrings(boolean directed) {
        HashSet<String> set = new HashSet<String>();
        for (Graph graph : this.graphs) {
            set.addAll(graph.getRelationStrings(directed));
        }
        return set;
    }

    @Override
    public Set<String> toString(Set<String> from, Set<String> to) {
        HashSet<String> result = new HashSet<String>();
        for (Graph graph : this.graphs) {
            result.addAll(graph.toString(from, to));
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

