/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.util.ArrayUtil;
import org.cbio.causality.util.Summary;

public class Outlier {
    public static boolean[] getOutlierAltered(Collection<AlterationPack> genes, Alteration type) {
        try {
            int i;
            final HashMap<Integer, Integer> sample2Cnt = new HashMap<Integer, Integer>();
            int size = genes.iterator().next().getSize();
            for (int i2 = 0; i2 < size; ++i2) {
                int cnt = 0;
                for (AlterationPack gene : genes) {
                    if (!gene.get(type)[i2].isAltered()) continue;
                    ++cnt;
                }
                sample2Cnt.put(i2, cnt);
            }
            ArrayList<Integer> samples = new ArrayList<Integer>(sample2Cnt.keySet());
            Collections.sort(samples, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return ((Integer)sample2Cnt.get(o1)).compareTo((Integer)sample2Cnt.get(o2));
                }
            });
            boolean[] outlier = new boolean[samples.size()];
            for (i = samples.size(); i > 0 && Outlier.isRightOutlier(samples, sample2Cnt, i); --i) {
                outlier[((Integer)samples.get((int)(i - 1))).intValue()] = true;
            }
            System.out.println("original sample size: " + outlier.length);
            int ro = ArrayUtil.countValue(outlier, true);
            System.out.println("Right outlier: " + ro);
            int rightBorder = i - 1;
            while (i > 0) {
                outlier[((Integer)samples.get((int)(--i))).intValue()] = false;
            }
            for (i = 0; i < rightBorder && Outlier.isLeftOutlier(samples, sample2Cnt, i, rightBorder); ++i) {
                outlier[((Integer)samples.get((int)i)).intValue()] = true;
            }
            System.out.println("Left outliers: " + (ArrayUtil.countValue(outlier, true) - ro));
            System.out.println("Outlier ratio: " + (double)ArrayUtil.countValue(outlier, true) / (double)samples.size());
            return outlier;
        }
        catch (MathException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isRightOutlier(List<Integer> samples, Map<Integer, Integer> cnts, int test) throws MathException {
        double[] v = new double[test];
        for (int i = 0; i < test; ++i) {
            v[i] = cnts.get(samples.get(i)).intValue();
        }
        return Outlier.lastIsOutlier(v);
    }

    private static boolean isLeftOutlier(List<Integer> samples, Map<Integer, Integer> cnts, int test, int rightBorder) throws MathException {
        double[] v = new double[rightBorder - test + 1];
        for (int i = 0; i < v.length; ++i) {
            v[i] = cnts.get(samples.get(i + test)).intValue();
        }
        return Outlier.firstIsOutlier(v);
    }

    private static boolean lastIsOutlier(double[] v) throws MathException {
        double mean = Summary.mean(v);
        double sd = Summary.stdev(v);
        if (sd == 0.0) {
            return true;
        }
        NormalDistributionImpl dist = new NormalDistributionImpl(mean, sd);
        double p = 1.0 - dist.cumulativeProbability(v[v.length - 1]);
        double exp = p * (double)v.length;
        return exp < 0.5;
    }

    private static boolean firstIsOutlier(double[] v) throws MathException {
        double sd;
        double mean = Summary.mean(v);
        NormalDistributionImpl dist = new NormalDistributionImpl(mean, sd = Summary.stdev(v));
        double p = dist.cumulativeProbability(v[0]);
        double exp = p * (double)v.length;
        return exp < 0.5;
    }
}

