/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.util.Set;
import org.cbio.causality.rppa.RPPAData;
import org.cbio.causality.signednetwork.SignedType;
import org.cbio.causality.util.CollectionUtil;

public class Relation {
    public String source;
    public String target;
    public SignedType edgeType;
    public RPPAData sourceData;
    public RPPAData targetData;
    public int corrSign;
    public String mediators;
    public Set<String> sites;

    public Relation(String source, String target, SignedType edgeType, RPPAData sourceData, RPPAData targetData, int corrSign, String mediators, Set<String> sites) {
        this.source = source;
        this.target = target;
        this.edgeType = edgeType;
        this.sourceData = sourceData;
        this.targetData = targetData;
        this.corrSign = corrSign;
        this.mediators = mediators;
        this.sites = sites;
    }

    public String getEdgeData() {
        return this.source + "\t" + this.edgeType.getTag() + "\t" + this.target + "\t" + this.mediators + (this.sites == null ? "" : "\t" + CollectionUtil.merge(this.sites, ";"));
    }

    public String getEdgeDataAntibodyCentric() {
        return this.sourceData.id + "\t" + this.edgeType.getTag() + "\t" + this.targetData.id + "\t" + this.mediators + (this.sites == null ? "" : "\t" + CollectionUtil.merge(this.sites, ";"));
    }

    public boolean siteMatching() {
        if (this.sites == null) {
            return false;
        }
        if (this.targetData.sites == null) {
            return false;
        }
        for (String site : this.targetData.sites.get(this.target)) {
            if (!this.sites.contains(site)) continue;
            return true;
        }
        return false;
    }

    public boolean phosphoEdge() {
        return this.edgeType.isPhospho();
    }

    public boolean dataChangesAsExpected() {
        return this.sourceData.getChangeSign() * this.targetData.getChangeSign() * this.corrSign == 1;
    }

    public boolean dataChangesAsUnxpected() {
        return this.sourceData.getChangeSign() * this.targetData.getChangeSign() * this.corrSign == -1;
    }

    public boolean dataChangesInsignificant() {
        return this.sourceData.getChangeSign() * this.targetData.getChangeSign() == 0;
    }

    public boolean siteMatches() {
        if (!this.targetData.isPhospho()) {
            return true;
        }
        if (this.sites == null) {
            return false;
        }
        for (String site : this.sites) {
            if (!this.targetData.sites.get(this.target).contains(site)) continue;
            return true;
        }
        return false;
    }
}

